import UITypes from './UITypes';
import { RelationTypes, RolesObj, RolesType } from './globals';
import { ClientType } from './enums';
import { ColumnType, IntegrationsType } from './Api';
import { FormulaDataTypes } from './formula/enums';
declare const filterOutSystemColumns: (columns: any) => any;
declare const getSystemColumnsIds: (columns: any) => any;
declare const getSystemColumns: (columns: any) => any;
declare const isSystemColumn: (col: any) => boolean;
declare const isSelfReferencingTableColumn: (col: any) => boolean;
declare const extractRolesObj: (roles: RolesType) => RolesObj;
declare const stringifyRolesObj: (roles?: RolesObj | null) => string;
declare const getAvailableRollupForColumn: (column: ColumnType) => string[];
declare const getAvailableRollupForUiType: (type: string) => string[];
declare const getAvailableRollupForFormulaType: (type: FormulaDataTypes) => string[];
declare const getRenderAsTextFunForUiType: (type: UITypes) => string[];
declare function populateUniqueFileName(fileName: string, attachments: string[]): string;
declare function roundUpToPrecision(number: number, precision?: number): string;
export { filterOutSystemColumns, getSystemColumnsIds, getSystemColumns, isSystemColumn, isSelfReferencingTableColumn, extractRolesObj, stringifyRolesObj, getAvailableRollupForColumn, getAvailableRollupForUiType, getAvailableRollupForFormulaType, getRenderAsTextFunForUiType, populateUniqueFileName, roundUpToPrecision, };
export declare const getTestDatabaseName: (db: {
    client: ClientType;
    connection?: {
        database?: string;
    };
}) => any;
export declare const integrationCategoryNeedDefault: (category: IntegrationsType) => boolean;
export declare function parseProp(v: any, fallbackVal?: {}): any;
export declare function stringifyProp(v: any, fallbackVal?: string): string;
export declare function parseHelper(v: any): any;
export declare function stringifyHelper(v: any): string;
export declare function toSafeInteger(value: number): number;
export declare function isCrossBaseLink(col: ColumnType): boolean;
export declare function lookupCanHaveRecursiveEvaluation(param: {
    isEeUI: boolean;
    relationCol: ColumnType;
    relationType: RelationTypes;
    dbClientType: ClientType;
}): boolean;
export declare function formatBytes(bytes: any, decimals?: number, base?: number): string;
