"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.integrationCategoryNeedDefault = exports.getTestDatabaseName = exports.getRenderAsTextFunForUiType = exports.getAvailableRollupForFormulaType = exports.getAvailableRollupForUiType = exports.getAvailableRollupForColumn = exports.stringifyRolesObj = exports.extractRolesObj = exports.isSelfReferencingTableColumn = exports.isSystemColumn = exports.getSystemColumns = exports.getSystemColumnsIds = exports.filterOutSystemColumns = void 0;
exports.populateUniqueFileName = populateUniqueFileName;
exports.roundUpToPrecision = roundUpToPrecision;
exports.parseProp = parseProp;
exports.stringifyProp = stringifyProp;
exports.parseHelper = parseHelper;
exports.stringifyHelper = stringifyHelper;
exports.toSafeInteger = toSafeInteger;
exports.isCrossBaseLink = isCrossBaseLink;
exports.lookupCanHaveRecursiveEvaluation = lookupCanHaveRecursiveEvaluation;
exports.formatBytes = formatBytes;
const UITypes_1 = __importStar(require("./UITypes"));
const globals_1 = require("./globals");
const enums_1 = require("./enums");
const Api_1 = require("./Api");
const enums_2 = require("./formula/enums");
const is_1 = require("../lib/is");
// import {RelationTypes} from "./globals";
const filterOutSystemColumns = (columns) => {
    return (columns && columns.filter((c) => !isSystemColumn(c))) || [];
};
exports.filterOutSystemColumns = filterOutSystemColumns;
const getSystemColumnsIds = (columns) => {
    return ((columns && columns.filter(isSystemColumn)) || []).map((c) => c.id);
};
exports.getSystemColumnsIds = getSystemColumnsIds;
const getSystemColumns = (columns) => columns.filter(isSystemColumn) || [];
exports.getSystemColumns = getSystemColumns;
const isSystemColumn = (col) => !!(col &&
    (col.uidt === UITypes_1.default.ForeignKey ||
        (col.pk && (col.ai || col.cdf)) ||
        (col.pk && col.meta && col.meta.ag) ||
        col.system));
exports.isSystemColumn = isSystemColumn;
const isSelfReferencingTableColumn = (col) => {
    var _a, _b, _c;
    return (col &&
        (col.uidt === UITypes_1.default.Links || col.uidt === UITypes_1.default.LinkToAnotherRecord) &&
        ((col === null || col === void 0 ? void 0 : col.fk_model_id) || ((_a = col === null || col === void 0 ? void 0 : col.colOptions) === null || _a === void 0 ? void 0 : _a.fk_model_id)) &&
        ((_b = col === null || col === void 0 ? void 0 : col.colOptions) === null || _b === void 0 ? void 0 : _b.fk_related_model_id) &&
        ((col === null || col === void 0 ? void 0 : col.fk_model_id) || ((_c = col === null || col === void 0 ? void 0 : col.colOptions) === null || _c === void 0 ? void 0 : _c.fk_model_id)) ===
            col.colOptions.fk_related_model_id);
};
exports.isSelfReferencingTableColumn = isSelfReferencingTableColumn;
const extractRolesObj = (roles) => {
    if (!roles)
        return null;
    if (typeof roles === 'object' && !Array.isArray(roles))
        return roles;
    if (typeof roles === 'string') {
        roles = roles.split(',');
    }
    if (roles.length === 0)
        return null;
    return roles.reduce((acc, role) => {
        acc[role] = true;
        return acc;
    }, {});
};
exports.extractRolesObj = extractRolesObj;
const stringifyRolesObj = (roles) => {
    if (!roles)
        return '';
    const rolesArr = Object.keys(roles).filter((r) => roles[r]);
    return rolesArr.join(',');
};
exports.stringifyRolesObj = stringifyRolesObj;
const getAvailableRollupForColumn = (column) => {
    var _a, _b;
    if ([UITypes_1.default.Formula].includes(column.uidt)) {
        return getAvailableRollupForFormulaType((_b = (_a = column.colOptions.parsed_tree) === null || _a === void 0 ? void 0 : _a.dataType) !== null && _b !== void 0 ? _b : enums_2.FormulaDataTypes.UNKNOWN);
    }
    else {
        return getAvailableRollupForUiType(column.uidt);
    }
};
exports.getAvailableRollupForColumn = getAvailableRollupForColumn;
const getAvailableRollupForUiType = (type) => {
    if ([
        UITypes_1.default.Year,
        UITypes_1.default.Time,
        UITypes_1.default.Date,
        UITypes_1.default.DateTime,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
    ].includes(type)) {
        return ['count', 'min', 'max', 'countDistinct'];
    }
    if ((0, UITypes_1.isNumericCol)(type)) {
        // Number, Currency, Percent, Duration, Rating, Decimal
        return [
            'sum',
            'count',
            'min',
            'max',
            'avg',
            'countDistinct',
            'sumDistinct',
            'avgDistinct',
        ];
    }
    if ([
        UITypes_1.default.SingleLineText,
        UITypes_1.default.LongText,
        UITypes_1.default.User,
        UITypes_1.default.Email,
        UITypes_1.default.PhoneNumber,
        UITypes_1.default.URL,
        UITypes_1.default.JSON,
    ].includes(type)) {
        return ['count', 'countDistinct'];
    }
    if ([UITypes_1.default.Checkbox].includes(type)) {
        return ['count', 'sum'];
    }
    if ([UITypes_1.default.Attachment].includes(type)) {
        return [];
    }
    if ([UITypes_1.default.SingleSelect, UITypes_1.default.MultiSelect].includes(type)) {
        return ['count', 'countDistinct'];
    }
    return [
        'sum',
        'count',
        'min',
        'max',
        'avg',
        'countDistinct',
        'sumDistinct',
        'avgDistinct',
    ];
};
exports.getAvailableRollupForUiType = getAvailableRollupForUiType;
const getAvailableRollupForFormulaType = (type) => {
    switch (type) {
        case enums_2.FormulaDataTypes.DATE:
        case enums_2.FormulaDataTypes.INTERVAL: {
            return ['count', 'min', 'max', 'countDistinct'];
        }
        case enums_2.FormulaDataTypes.NUMERIC: {
            return [
                'sum',
                'count',
                'min',
                'max',
                'avg',
                'countDistinct',
                'sumDistinct',
                'avgDistinct',
            ];
        }
        case enums_2.FormulaDataTypes.BOOLEAN: {
            return ['count', 'sum'];
        }
        case enums_2.FormulaDataTypes.STRING: {
            return ['count', 'countDistinct'];
        }
        case enums_2.FormulaDataTypes.UNKNOWN:
        default: {
            return ['count'];
        }
    }
};
exports.getAvailableRollupForFormulaType = getAvailableRollupForFormulaType;
const getRenderAsTextFunForUiType = (type) => {
    if ([
        UITypes_1.default.Year,
        UITypes_1.default.Time,
        UITypes_1.default.Date,
        UITypes_1.default.DateTime,
        UITypes_1.default.CreatedTime,
        UITypes_1.default.LastModifiedTime,
        UITypes_1.default.Currency,
        UITypes_1.default.Duration,
    ].includes(type)) {
        return ['count', 'countDistinct'];
    }
    return [
        'sum',
        'count',
        'avg',
        'min',
        'max',
        'countDistinct',
        'sumDistinct',
        'avgDistinct',
    ];
};
exports.getRenderAsTextFunForUiType = getRenderAsTextFunForUiType;
const getFileName = ({ name, count, ext }) => `${name}${count ? `(${count})` : ''}${ext ? `${ext}` : ''}`;
// add count before extension if duplicate name found
function populateUniqueFileName(fileName, attachments) {
    return fileName.replace(/^(.+?)(?:\((\d+)\))?(\.(?:tar|min)\.(?:\w{2,4})|\.\w+)$/, (fileName, name, count, ext) => {
        let genFileName = fileName;
        let c = count || 1;
        // iterate until a unique name
        while (attachments.some((fn) => fn === genFileName)) {
            genFileName = getFileName({
                name,
                ext,
                count: c++,
            });
        }
        return genFileName;
    });
}
function roundUpToPrecision(number, precision = 0) {
    precision =
        precision == null
            ? 0
            : precision >= 0
                ? Math.min(precision, 292)
                : Math.max(precision, -292);
    if (precision) {
        // Shift with exponential notation to avoid floating-point issues.
        // See [MDN](https://mdn.io/round#Examples) for more details.
        let pair = `${number}e`.split('e');
        const value = Math.round(Number(`${pair[0]}e${+pair[1] + precision}`));
        pair = `${value}e`.split('e');
        return (+`${pair[0]}e${+pair[1] - precision}`).toFixed(precision);
    }
    return Math.round(number).toFixed(precision);
}
const testDataBaseNames = {
    [enums_1.ClientType.MYSQL]: null,
    mysql: null,
    [enums_1.ClientType.PG]: 'postgres',
    oracledb: 'xe',
    [enums_1.ClientType.SQLITE]: 'a.sqlite',
};
const getTestDatabaseName = (db) => {
    var _a;
    if (db.client === enums_1.ClientType.PG || db.client === enums_1.ClientType.SNOWFLAKE)
        return (_a = db.connection) === null || _a === void 0 ? void 0 : _a.database;
    return testDataBaseNames[db.client];
};
exports.getTestDatabaseName = getTestDatabaseName;
const integrationCategoryNeedDefault = (category) => {
    return [Api_1.IntegrationsType.Ai].includes(category);
};
exports.integrationCategoryNeedDefault = integrationCategoryNeedDefault;
function parseProp(v, fallbackVal = {}) {
    var _a;
    if ((0, is_1.ncIsUndefined)(v) || (0, is_1.ncIsNull)(v))
        return {};
    try {
        return typeof v === 'string' ? (_a = JSON.parse(v)) !== null && _a !== void 0 ? _a : fallbackVal : v;
    }
    catch (_b) {
        return fallbackVal;
    }
}
function stringifyProp(v, fallbackVal = '{}') {
    var _a;
    if ((0, is_1.ncIsUndefined)(v) || (0, is_1.ncIsNull)(v))
        return '{}';
    try {
        return typeof v === 'string' ? v : (_a = JSON.stringify(v)) !== null && _a !== void 0 ? _a : fallbackVal;
    }
    catch (_b) {
        return fallbackVal;
    }
}
function parseHelper(v) {
    try {
        return typeof v === 'string' ? JSON.parse(v) : v;
    }
    catch (_a) {
        return v;
    }
}
function stringifyHelper(v) {
    try {
        return typeof v === 'string' ? v : JSON.stringify(v);
    }
    catch (_a) {
        return v;
    }
}
function toSafeInteger(value) {
    return Math.max(Number.MIN_SAFE_INTEGER, Math.min(value, Number.MAX_SAFE_INTEGER));
}
function isCrossBaseLink(col) {
    var _a, _b, _c;
    return (col &&
        (0, UITypes_1.isLinksOrLTAR)(col) &&
        ((_a = col.colOptions) === null || _a === void 0 ? void 0 : _a.fk_related_base_id) &&
        ((_b = col.colOptions) === null || _b === void 0 ? void 0 : _b.fk_related_base_id) !==
            ((_c = col.colOptions) === null || _c === void 0 ? void 0 : _c.base_id));
}
function lookupCanHaveRecursiveEvaluation(param) {
    const { isEeUI, dbClientType, relationType, relationCol } = param;
    return (isEeUI &&
        dbClientType === enums_1.ClientType.PG &&
        isSelfReferencingTableColumn(relationCol) &&
        [globals_1.RelationTypes.HAS_MANY, globals_1.RelationTypes.BELONGS_TO].includes(relationType));
}
function formatBytes(bytes, decimals = 2, base = 1000) {
    if (bytes === 0)
        return '0 Bytes';
    const k = base;
    const dm = Math.max(0, decimals);
    const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return `${(bytes / k ** i).toFixed(dm)} ${sizes[i]}`;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGVscGVyRnVuY3Rpb25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2xpYi9oZWxwZXJGdW5jdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBeVBFLHdEQUFzQjtBQUN0QixnREFBa0I7QUF3QnBCLDhCQU9DO0FBRUQsc0NBT0M7QUFFRCxrQ0FNQztBQUVELDBDQU1DO0FBRUQsc0NBS0M7QUFFRCwwQ0FRQztBQUVELDRFQWFDO0FBRUQsa0NBU0M7QUE3VkQscURBQWlFO0FBQ2pFLHVDQUErRDtBQUMvRCxtQ0FBcUM7QUFDckMsK0JBS2U7QUFDZiwyQ0FBbUQ7QUFDbkQsaUNBQW1EO0FBRW5ELDJDQUEyQztBQUUzQyxNQUFNLHNCQUFzQixHQUFHLENBQUMsT0FBTyxFQUFFLEVBQUU7SUFDekMsT0FBTyxDQUFDLE9BQU8sSUFBSSxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDO0FBQ3RFLENBQUMsQ0FBQztBQThOQSx3REFBc0I7QUE3TnhCLE1BQU0sbUJBQW1CLEdBQUcsQ0FBQyxPQUFPLEVBQUUsRUFBRTtJQUN0QyxPQUFPLENBQUMsQ0FBQyxPQUFPLElBQUksT0FBTyxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBQzlFLENBQUMsQ0FBQztBQTROQSxrREFBbUI7QUExTnJCLE1BQU0sZ0JBQWdCLEdBQUcsQ0FBQyxPQUFPLEVBQUUsRUFBRSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxDQUFDO0FBMk56RSw0Q0FBZ0I7QUF6TmxCLE1BQU0sY0FBYyxHQUFHLENBQUMsR0FBRyxFQUFXLEVBQUUsQ0FDdEMsQ0FBQyxDQUFDLENBQ0EsR0FBRztJQUNILENBQUMsR0FBRyxDQUFDLElBQUksS0FBSyxpQkFBTyxDQUFDLFVBQVU7UUFDOUIsQ0FBQyxHQUFHLENBQUMsRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDL0IsQ0FBQyxHQUFHLENBQUMsRUFBRSxJQUFJLEdBQUcsQ0FBQyxJQUFJLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7UUFDbkMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUNkLENBQUM7QUFtTkYsd0NBQWM7QUFqTmhCLE1BQU0sNEJBQTRCLEdBQUcsQ0FBQyxHQUFHLEVBQVcsRUFBRTs7SUFDcEQsT0FBTyxDQUNMLEdBQUc7UUFDSCxDQUFDLEdBQUcsQ0FBQyxJQUFJLEtBQUssaUJBQU8sQ0FBQyxLQUFLLElBQUksR0FBRyxDQUFDLElBQUksS0FBSyxpQkFBTyxDQUFDLG1CQUFtQixDQUFDO1FBQ3hFLENBQUMsQ0FBQSxHQUFHLGFBQUgsR0FBRyx1QkFBSCxHQUFHLENBQUUsV0FBVyxNQUFJLE1BQUEsR0FBRyxhQUFILEdBQUcsdUJBQUgsR0FBRyxDQUFFLFVBQVUsMENBQUUsV0FBVyxDQUFBLENBQUM7U0FDbEQsTUFBQSxHQUFHLGFBQUgsR0FBRyx1QkFBSCxHQUFHLENBQUUsVUFBVSwwQ0FBRSxtQkFBbUIsQ0FBQTtRQUNwQyxDQUFDLENBQUEsR0FBRyxhQUFILEdBQUcsdUJBQUgsR0FBRyxDQUFFLFdBQVcsTUFBSSxNQUFBLEdBQUcsYUFBSCxHQUFHLHVCQUFILEdBQUcsQ0FBRSxVQUFVLDBDQUFFLFdBQVcsQ0FBQSxDQUFDO1lBQ2hELEdBQUcsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQ3JDLENBQUM7QUFDSixDQUFDLENBQUM7QUF5TUEsb0VBQTRCO0FBdk05QixNQUFNLGVBQWUsR0FBRyxDQUFDLEtBQWdCLEVBQVksRUFBRTtJQUNyRCxJQUFJLENBQUMsS0FBSztRQUFFLE9BQU8sSUFBSSxDQUFDO0lBRXhCLElBQUksT0FBTyxLQUFLLEtBQUssUUFBUSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUM7UUFBRSxPQUFPLEtBQUssQ0FBQztJQUVyRSxJQUFJLE9BQU8sS0FBSyxLQUFLLFFBQVEsRUFBRSxDQUFDO1FBQzlCLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQzNCLENBQUM7SUFFRCxJQUFJLEtBQUssQ0FBQyxNQUFNLEtBQUssQ0FBQztRQUFFLE9BQU8sSUFBSSxDQUFDO0lBRXBDLE9BQU8sS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsRUFBRSxJQUFJLEVBQUUsRUFBRTtRQUNoQyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLE9BQU8sR0FBRyxDQUFDO0lBQ2IsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQ1QsQ0FBQyxDQUFDO0FBeUxBLDBDQUFlO0FBdkxqQixNQUFNLGlCQUFpQixHQUFHLENBQUMsS0FBdUIsRUFBVSxFQUFFO0lBQzVELElBQUksQ0FBQyxLQUFLO1FBQUUsT0FBTyxFQUFFLENBQUM7SUFDdEIsTUFBTSxRQUFRLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzVELE9BQU8sUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUM1QixDQUFDLENBQUM7QUFvTEEsOENBQWlCO0FBbkxuQixNQUFNLDJCQUEyQixHQUFHLENBQUMsTUFBa0IsRUFBRSxFQUFFOztJQUN6RCxJQUFJLENBQUMsaUJBQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLElBQWUsQ0FBQyxFQUFFLENBQUM7UUFDdkQsT0FBTyxnQ0FBZ0MsQ0FDckMsTUFBQSxNQUFDLE1BQU0sQ0FBQyxVQUFpQyxDQUFDLFdBQVcsMENBQUUsUUFBUSxtQ0FDN0Qsd0JBQWdCLENBQUMsT0FBTyxDQUMzQixDQUFDO0lBQ0osQ0FBQztTQUFNLENBQUM7UUFDTixPQUFPLDJCQUEyQixDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNsRCxDQUFDO0FBQ0gsQ0FBQyxDQUFDO0FBMktBLGtFQUEyQjtBQTFLN0IsTUFBTSwyQkFBMkIsR0FBRyxDQUFDLElBQVksRUFBRSxFQUFFO0lBQ25ELElBQ0U7UUFDRSxpQkFBTyxDQUFDLElBQUk7UUFDWixpQkFBTyxDQUFDLElBQUk7UUFDWixpQkFBTyxDQUFDLElBQUk7UUFDWixpQkFBTyxDQUFDLFFBQVE7UUFDaEIsaUJBQU8sQ0FBQyxXQUFXO1FBQ25CLGlCQUFPLENBQUMsZ0JBQWdCO0tBQ3pCLENBQUMsUUFBUSxDQUFDLElBQWUsQ0FBQyxFQUMzQixDQUFDO1FBQ0QsT0FBTyxDQUFDLE9BQU8sRUFBRSxLQUFLLEVBQUUsS0FBSyxFQUFFLGVBQWUsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFDRCxJQUFJLElBQUEsc0JBQVksRUFBQyxJQUFlLENBQUMsRUFBRSxDQUFDO1FBQ2xDLHVEQUF1RDtRQUN2RCxPQUFPO1lBQ0wsS0FBSztZQUNMLE9BQU87WUFDUCxLQUFLO1lBQ0wsS0FBSztZQUNMLEtBQUs7WUFDTCxlQUFlO1lBQ2YsYUFBYTtZQUNiLGFBQWE7U0FDZCxDQUFDO0lBQ0osQ0FBQztJQUVELElBQ0U7UUFDRSxpQkFBTyxDQUFDLGNBQWM7UUFDdEIsaUJBQU8sQ0FBQyxRQUFRO1FBQ2hCLGlCQUFPLENBQUMsSUFBSTtRQUNaLGlCQUFPLENBQUMsS0FBSztRQUNiLGlCQUFPLENBQUMsV0FBVztRQUNuQixpQkFBTyxDQUFDLEdBQUc7UUFDWCxpQkFBTyxDQUFDLElBQUk7S0FDYixDQUFDLFFBQVEsQ0FBQyxJQUFlLENBQUMsRUFDM0IsQ0FBQztRQUNELE9BQU8sQ0FBQyxPQUFPLEVBQUUsZUFBZSxDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUNELElBQUksQ0FBQyxpQkFBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFlLENBQUMsRUFBRSxDQUFDO1FBQ2pELE9BQU8sQ0FBQyxPQUFPLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDMUIsQ0FBQztJQUNELElBQUksQ0FBQyxpQkFBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFlLENBQUMsRUFBRSxDQUFDO1FBQ25ELE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztJQUNELElBQUksQ0FBQyxpQkFBTyxDQUFDLFlBQVksRUFBRSxpQkFBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFlLENBQUMsRUFBRSxDQUFDO1FBQzFFLE9BQU8sQ0FBQyxPQUFPLEVBQUUsZUFBZSxDQUFDLENBQUM7SUFDcEMsQ0FBQztJQUNELE9BQU87UUFDTCxLQUFLO1FBQ0wsT0FBTztRQUNQLEtBQUs7UUFDTCxLQUFLO1FBQ0wsS0FBSztRQUNMLGVBQWU7UUFDZixhQUFhO1FBQ2IsYUFBYTtLQUNkLENBQUM7QUFDSixDQUFDLENBQUM7QUFnSEEsa0VBQTJCO0FBOUc3QixNQUFNLGdDQUFnQyxHQUFHLENBQUMsSUFBc0IsRUFBRSxFQUFFO0lBQ2xFLFFBQVEsSUFBSSxFQUFFLENBQUM7UUFDYixLQUFLLHdCQUFnQixDQUFDLElBQUksQ0FBQztRQUMzQixLQUFLLHdCQUFnQixDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7WUFDL0IsT0FBTyxDQUFDLE9BQU8sRUFBRSxLQUFLLEVBQUUsS0FBSyxFQUFFLGVBQWUsQ0FBQyxDQUFDO1FBQ2xELENBQUM7UUFDRCxLQUFLLHdCQUFnQixDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDOUIsT0FBTztnQkFDTCxLQUFLO2dCQUNMLE9BQU87Z0JBQ1AsS0FBSztnQkFDTCxLQUFLO2dCQUNMLEtBQUs7Z0JBQ0wsZUFBZTtnQkFDZixhQUFhO2dCQUNiLGFBQWE7YUFDZCxDQUFDO1FBQ0osQ0FBQztRQUNELEtBQUssd0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztZQUM5QixPQUFPLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQzFCLENBQUM7UUFDRCxLQUFLLHdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7WUFDN0IsT0FBTyxDQUFDLE9BQU8sRUFBRSxlQUFlLENBQUMsQ0FBQztRQUNwQyxDQUFDO1FBQ0QsS0FBSyx3QkFBZ0IsQ0FBQyxPQUFPLENBQUM7UUFDOUIsT0FBTyxDQUFDLENBQUMsQ0FBQztZQUNSLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNuQixDQUFDO0lBQ0gsQ0FBQztBQUNILENBQUMsQ0FBQztBQWtGQSw0RUFBZ0M7QUFoRmxDLE1BQU0sMkJBQTJCLEdBQUcsQ0FBQyxJQUFhLEVBQUUsRUFBRTtJQUNwRCxJQUNFO1FBQ0UsaUJBQU8sQ0FBQyxJQUFJO1FBQ1osaUJBQU8sQ0FBQyxJQUFJO1FBQ1osaUJBQU8sQ0FBQyxJQUFJO1FBQ1osaUJBQU8sQ0FBQyxRQUFRO1FBQ2hCLGlCQUFPLENBQUMsV0FBVztRQUNuQixpQkFBTyxDQUFDLGdCQUFnQjtRQUN4QixpQkFBTyxDQUFDLFFBQVE7UUFDaEIsaUJBQU8sQ0FBQyxRQUFRO0tBQ2pCLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxFQUNoQixDQUFDO1FBQ0QsT0FBTyxDQUFDLE9BQU8sRUFBRSxlQUFlLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQsT0FBTztRQUNMLEtBQUs7UUFDTCxPQUFPO1FBQ1AsS0FBSztRQUNMLEtBQUs7UUFDTCxLQUFLO1FBQ0wsZUFBZTtRQUNmLGFBQWE7UUFDYixhQUFhO0tBQ2QsQ0FBQztBQUNKLENBQUMsQ0FBQztBQXVEQSxrRUFBMkI7QUFyRDdCLE1BQU0sV0FBVyxHQUFHLENBQUMsRUFBRSxJQUFJLEVBQUUsS0FBSyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUUsQ0FDM0MsR0FBRyxJQUFJLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLEtBQUssR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLEdBQUcsR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUcsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQztBQUU5RCxxREFBcUQ7QUFDckQsU0FBUyxzQkFBc0IsQ0FBQyxRQUFnQixFQUFFLFdBQXFCO0lBQ3JFLE9BQU8sUUFBUSxDQUFDLE9BQU8sQ0FDckIseURBQXlELEVBQ3pELENBQUMsUUFBUSxFQUFFLElBQUksRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLEVBQUU7UUFDN0IsSUFBSSxXQUFXLEdBQUcsUUFBUSxDQUFDO1FBQzNCLElBQUksQ0FBQyxHQUFHLEtBQUssSUFBSSxDQUFDLENBQUM7UUFFbkIsOEJBQThCO1FBQzlCLE9BQU8sV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRSxLQUFLLFdBQVcsQ0FBQyxFQUFFLENBQUM7WUFDcEQsV0FBVyxHQUFHLFdBQVcsQ0FBQztnQkFDeEIsSUFBSTtnQkFDSixHQUFHO2dCQUNILEtBQUssRUFBRSxDQUFDLEVBQUU7YUFDWCxDQUFDLENBQUM7UUFDTCxDQUFDO1FBQ0QsT0FBTyxXQUFXLENBQUM7SUFDckIsQ0FBQyxDQUNGLENBQUM7QUFDSixDQUFDO0FBRUQsU0FBUyxrQkFBa0IsQ0FBQyxNQUFjLEVBQUUsWUFBb0IsQ0FBQztJQUMvRCxTQUFTO1FBQ1AsU0FBUyxJQUFJLElBQUk7WUFDZixDQUFDLENBQUMsQ0FBQztZQUNILENBQUMsQ0FBQyxTQUFTLElBQUksQ0FBQztnQkFDaEIsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQztnQkFDMUIsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDaEMsSUFBSSxTQUFTLEVBQUUsQ0FBQztRQUNkLGtFQUFrRTtRQUNsRSw2REFBNkQ7UUFDN0QsSUFBSSxJQUFJLEdBQUcsR0FBRyxNQUFNLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDbkMsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEdBQUcsU0FBUyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ3ZFLElBQUksR0FBRyxHQUFHLEtBQUssR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUM5QixPQUFPLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsR0FBRyxTQUFTLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBQ0QsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQztBQUMvQyxDQUFDO0FBa0JELE1BQU0saUJBQWlCLEdBQUc7SUFDeEIsQ0FBQyxrQkFBVSxDQUFDLEtBQUssQ0FBQyxFQUFFLElBQUk7SUFDeEIsS0FBSyxFQUFFLElBQUk7SUFDWCxDQUFDLGtCQUFVLENBQUMsRUFBRSxDQUFDLEVBQUUsVUFBVTtJQUMzQixRQUFRLEVBQUUsSUFBSTtJQUNkLENBQUMsa0JBQVUsQ0FBQyxNQUFNLENBQUMsRUFBRSxVQUFVO0NBQ2hDLENBQUM7QUFFSyxNQUFNLG1CQUFtQixHQUFHLENBQUMsRUFHbkMsRUFBRSxFQUFFOztJQUNILElBQUksRUFBRSxDQUFDLE1BQU0sS0FBSyxrQkFBVSxDQUFDLEVBQUUsSUFBSSxFQUFFLENBQUMsTUFBTSxLQUFLLGtCQUFVLENBQUMsU0FBUztRQUNuRSxPQUFPLE1BQUEsRUFBRSxDQUFDLFVBQVUsMENBQUUsUUFBUSxDQUFDO0lBQ2pDLE9BQU8saUJBQWlCLENBQUMsRUFBRSxDQUFDLE1BQXdDLENBQUMsQ0FBQztBQUN4RSxDQUFDLENBQUM7QUFQVyxRQUFBLG1CQUFtQix1QkFPOUI7QUFFSyxNQUFNLDhCQUE4QixHQUFHLENBQUMsUUFBMEIsRUFBRSxFQUFFO0lBQzNFLE9BQU8sQ0FBQyxzQkFBZ0IsQ0FBQyxFQUFFLENBQUMsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLENBQUM7QUFDbEQsQ0FBQyxDQUFDO0FBRlcsUUFBQSw4QkFBOEIsa0NBRXpDO0FBRUYsU0FBZ0IsU0FBUyxDQUFDLENBQU0sRUFBRSxXQUFXLEdBQUcsRUFBRTs7SUFDaEQsSUFBSSxJQUFBLGtCQUFhLEVBQUMsQ0FBQyxDQUFDLElBQUksSUFBQSxhQUFRLEVBQUMsQ0FBQyxDQUFDO1FBQUUsT0FBTyxFQUFFLENBQUM7SUFDL0MsSUFBSSxDQUFDO1FBQ0gsT0FBTyxPQUFPLENBQUMsS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLE1BQUEsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsbUNBQUksV0FBVyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUFDLFdBQU0sQ0FBQztRQUNQLE9BQU8sV0FBVyxDQUFDO0lBQ3JCLENBQUM7QUFDSCxDQUFDO0FBRUQsU0FBZ0IsYUFBYSxDQUFDLENBQU0sRUFBRSxXQUFXLEdBQUcsSUFBSTs7SUFDdEQsSUFBSSxJQUFBLGtCQUFhLEVBQUMsQ0FBQyxDQUFDLElBQUksSUFBQSxhQUFRLEVBQUMsQ0FBQyxDQUFDO1FBQUUsT0FBTyxJQUFJLENBQUM7SUFDakQsSUFBSSxDQUFDO1FBQ0gsT0FBTyxPQUFPLENBQUMsS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsTUFBQSxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxtQ0FBSSxXQUFXLENBQUM7SUFDdEUsQ0FBQztJQUFDLFdBQU0sQ0FBQztRQUNQLE9BQU8sV0FBVyxDQUFDO0lBQ3JCLENBQUM7QUFDSCxDQUFDO0FBRUQsU0FBZ0IsV0FBVyxDQUFDLENBQU07SUFDaEMsSUFBSSxDQUFDO1FBQ0gsT0FBTyxPQUFPLENBQUMsS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBQUMsV0FBTSxDQUFDO1FBQ1AsT0FBTyxDQUFDLENBQUM7SUFDWCxDQUFDO0FBQ0gsQ0FBQztBQUVELFNBQWdCLGVBQWUsQ0FBQyxDQUFNO0lBQ3BDLElBQUksQ0FBQztRQUNILE9BQU8sT0FBTyxDQUFDLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUFDLFdBQU0sQ0FBQztRQUNQLE9BQU8sQ0FBQyxDQUFDO0lBQ1gsQ0FBQztBQUNILENBQUM7QUFFRCxTQUFnQixhQUFhLENBQUMsS0FBYTtJQUN6QyxPQUFPLElBQUksQ0FBQyxHQUFHLENBQ2IsTUFBTSxDQUFDLGdCQUFnQixFQUN2QixJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsZ0JBQWdCLENBQUMsQ0FDekMsQ0FBQztBQUNKLENBQUM7QUFFRCxTQUFnQixlQUFlLENBQUMsR0FBZTs7SUFDN0MsT0FBTyxDQUNMLEdBQUc7UUFDSCxJQUFBLHVCQUFhLEVBQUMsR0FBRyxDQUFDO1NBQ2xCLE1BQUMsR0FBRyxDQUFDLFVBQXNDLDBDQUFFLGtCQUFrQixDQUFBO1FBQy9ELENBQUEsTUFBQyxHQUFHLENBQUMsVUFBc0MsMENBQUUsa0JBQWtCO2FBQzdELE1BQUMsR0FBRyxDQUFDLFVBQXNDLDBDQUFFLE9BQU8sQ0FBQSxDQUN2RCxDQUFDO0FBQ0osQ0FBQztBQUVELFNBQWdCLGdDQUFnQyxDQUFDLEtBS2hEO0lBQ0MsTUFBTSxFQUFFLE1BQU0sRUFBRSxZQUFZLEVBQUUsWUFBWSxFQUFFLFdBQVcsRUFBRSxHQUFHLEtBQUssQ0FBQztJQUNsRSxPQUFPLENBQ0wsTUFBTTtRQUNOLFlBQVksS0FBSyxrQkFBVSxDQUFDLEVBQUU7UUFDOUIsNEJBQTRCLENBQUMsV0FBVyxDQUFDO1FBQ3pDLENBQUMsdUJBQWEsQ0FBQyxRQUFRLEVBQUUsdUJBQWEsQ0FBQyxVQUFVLENBQUMsQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLENBQzFFLENBQUM7QUFDSixDQUFDO0FBRUQsU0FBZ0IsV0FBVyxDQUFDLEtBQUssRUFBRSxRQUFRLEdBQUcsQ0FBQyxFQUFFLElBQUksR0FBRyxJQUFJO0lBQzFELElBQUksS0FBSyxLQUFLLENBQUM7UUFBRSxPQUFPLFNBQVMsQ0FBQztJQUVsQyxNQUFNLENBQUMsR0FBRyxJQUFJLENBQUM7SUFDZixNQUFNLEVBQUUsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsRUFBRSxRQUFRLENBQUMsQ0FBQztJQUNqQyxNQUFNLEtBQUssR0FBRyxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFDeEUsTUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUVwRCxPQUFPLEdBQUcsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsSUFBSSxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztBQUN2RCxDQUFDIn0=