"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMetaWithCompositeKey = getMetaWithCompositeKey;
/**
 * Helper to get table metadata using composite key pattern (baseId:tableId)
 * Falls back to tableId-only lookup for backward compatibility
 *
 * @param metas - Record of table metadata keyed by composite key or tableId
 * @param baseId - Base ID for composite key lookup
 * @param tableId - Table ID to look up
 * @returns Table metadata or undefined
 */
function getMetaWithCompositeKey(metas, baseId, tableId) {
    if (baseId) {
        return metas[`${baseId}:${tableId}`] || metas[tableId];
    }
    return metas[tableId];
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0YUhlbHBlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL2hlbHBlcnMvbWV0YUhlbHBlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFXQSwwREFTQztBQWxCRDs7Ozs7Ozs7R0FRRztBQUNILFNBQWdCLHVCQUF1QixDQUNyQyxLQUFnQyxFQUNoQyxNQUEwQixFQUMxQixPQUFlO0lBRWYsSUFBSSxNQUFNLEVBQUUsQ0FBQztRQUNYLE9BQU8sS0FBSyxDQUFDLEdBQUcsTUFBTSxJQUFJLE9BQU8sRUFBRSxDQUFDLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFDRCxPQUFPLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztBQUN4QixDQUFDIn0=