"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrencyValue = exports.roundTo = exports.numberize = void 0;
const helperFunctions_1 = require("../lib/helperFunctions");
const numberize = (value) => {
    if (value === undefined || value === null) {
        return value;
    }
    if (typeof value === 'number') {
        return value;
    }
    else {
        const result = parseInt(value);
        if (isNaN(result)) {
            return undefined;
        }
        return result;
    }
};
exports.numberize = numberize;
const roundTo = (num, precision = 1) => {
    if (!num || Number.isNaN(num))
        return num;
    const factor = 10 ** precision;
    return Math.round(+num * factor) / factor;
};
exports.roundTo = roundTo;
const getCurrencyValue = (modelValue, col) => {
    var _a, _b, _c;
    const currencyMeta = Object.assign({ currency_locale: 'en-US', currency_code: 'USD', precision: 2 }, (0, helperFunctions_1.parseProp)(col.meta));
    try {
        if (modelValue === null ||
            modelValue === undefined ||
            Number.isNaN(modelValue)) {
            return modelValue === null || modelValue === undefined
                ? ''
                : modelValue;
        }
        const roundedValue = (0, helperFunctions_1.roundUpToPrecision)(Number(modelValue), (_a = currencyMeta.precision) !== null && _a !== void 0 ? _a : 2);
        return new Intl.NumberFormat(currencyMeta.currency_locale || 'en-US', {
            style: 'currency',
            currency: currencyMeta.currency_code || 'USD',
            minimumFractionDigits: (_b = currencyMeta.precision) !== null && _b !== void 0 ? _b : 2,
            maximumFractionDigits: (_c = currencyMeta.precision) !== null && _c !== void 0 ? _c : 2,
        }).format(+roundedValue);
    }
    catch (e) {
        return modelValue;
    }
};
exports.getCurrencyValue = getCurrencyValue;
//# sourceMappingURL=data:application/json;base64,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