"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scopeDescriptions = exports.scopeHierarchy = exports.OAuthScopes = void 0;
var OAuthScopes;
(function (OAuthScopes) {
    OAuthScopes["DATA_RECORDS_READ"] = "data.records:read";
    OAuthScopes["DATA_RECORDS_WRITE"] = "data.records:write";
    OAuthScopes["DATA_RECORD_COMMENT_READ"] = "data.records.comment:read";
    OAuthScopes["DATA_RECORD_COMMENT_WRITE"] = "data.records.comment:write";
    OAuthScopes["SCHEMA_BASE_READ"] = "schema.base:read";
    OAuthScopes["SCHEMA_BASE_WRITE"] = "schema.base:write";
    OAuthScopes["SCHEMA_WORKSPACES_READ"] = "schema.workspaces:read";
    OAuthScopes["SCHEMA_WORKSPACES_WRITE"] = "schema.workspaces:write";
    OAuthScopes["WEBHOOK_MANAGE"] = "webhook:manage";
    OAuthScopes["INTEGRATION_MANAGE"] = "integration:manage";
    OAuthScopes["USER_PROFILE_READ"] = "user.profile:read";
    OAuthScopes["AI_ACCESS"] = "ai:access";
})(OAuthScopes || (exports.OAuthScopes = OAuthScopes = {}));
exports.scopeHierarchy = {
    // Data write includes read
    [OAuthScopes.DATA_RECORDS_WRITE]: [OAuthScopes.DATA_RECORDS_READ],
    [OAuthScopes.DATA_RECORD_COMMENT_WRITE]: [
        OAuthScopes.DATA_RECORD_COMMENT_READ,
    ],
    // Schema write includes read
    [OAuthScopes.SCHEMA_BASE_WRITE]: [OAuthScopes.SCHEMA_BASE_READ],
    [OAuthScopes.SCHEMA_WORKSPACES_WRITE]: [OAuthScopes.SCHEMA_WORKSPACES_READ],
};
exports.scopeDescriptions = {
    [OAuthScopes.DATA_RECORDS_READ]: {
        name: 'Read Records',
        description: 'View data records and their content',
    },
    [OAuthScopes.DATA_RECORDS_WRITE]: {
        name: 'Write Records',
        description: 'Create, update, and delete data records (includes read access)',
    },
    [OAuthScopes.DATA_RECORD_COMMENT_READ]: {
        name: 'Read Comments',
        description: 'View comments on data records',
    },
    [OAuthScopes.DATA_RECORD_COMMENT_WRITE]: {
        name: 'Write Comments',
        description: 'Add, edit, and delete comments on records (includes read access)',
    },
    [OAuthScopes.SCHEMA_BASE_READ]: {
        name: 'Read Base Schema',
        description: 'View base structure and base configuration',
    },
    [OAuthScopes.SCHEMA_BASE_WRITE]: {
        name: 'Write Base Schema',
        description: 'Modify base structure and configuration (includes read access)',
    },
    [OAuthScopes.SCHEMA_WORKSPACES_READ]: {
        name: 'Read Workspace Schema',
        description: 'View workspace structure and organization',
    },
    [OAuthScopes.SCHEMA_WORKSPACES_WRITE]: {
        name: 'Write Workspace Schema',
        description: 'Modify workspace structure and organization (includes read access)',
    },
    [OAuthScopes.WEBHOOK_MANAGE]: {
        name: 'Manage Webhooks',
        description: 'Create, update, and delete webhook configurations',
    },
    [OAuthScopes.INTEGRATION_MANAGE]: {
        name: 'Manage Integrations',
        description: 'Configure and manage third-party integrations',
    },
    [OAuthScopes.USER_PROFILE_READ]: {
        name: 'Read User Profile',
        description: 'Access user profile information and preferences',
    },
    [OAuthScopes.AI_ACCESS]: {
        name: 'AI Access',
        description: 'Use AI-powered features and functionality',
    },
};
//# sourceMappingURL=data:application/json;base64,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