"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const objectHelpers_1 = require("./objectHelpers");
describe('objectHelpers', () => {
    describe('objRemoveEmptyStringProps', () => {
        it('will remove empty string property', () => {
            const a = {
                foo: 'bar',
                boo: '',
                baz: {
                    foo: 'bar',
                    boo: '',
                    baz: [{ foo: 'bar', boo: '' }],
                },
            };
            const expected = {
                foo: 'bar',
                baz: {
                    foo: 'bar',
                    baz: [{ foo: 'bar' }],
                },
            };
            expect((0, objectHelpers_1.objRemoveEmptyStringProps)(a)).toEqual(expected);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib2JqZWN0SGVscGVycy5zcGVjLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2xpYi9vYmplY3RIZWxwZXJzLnNwZWMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxtREFBNEQ7QUFFNUQsUUFBUSxDQUFDLGVBQWUsRUFBRSxHQUFHLEVBQUU7SUFDN0IsUUFBUSxDQUFDLDJCQUEyQixFQUFFLEdBQUcsRUFBRTtRQUN6QyxFQUFFLENBQUMsbUNBQW1DLEVBQUUsR0FBRyxFQUFFO1lBQzNDLE1BQU0sQ0FBQyxHQUFHO2dCQUNSLEdBQUcsRUFBRSxLQUFLO2dCQUNWLEdBQUcsRUFBRSxFQUFFO2dCQUNQLEdBQUcsRUFBRTtvQkFDSCxHQUFHLEVBQUUsS0FBSztvQkFDVixHQUFHLEVBQUUsRUFBRTtvQkFDUCxHQUFHLEVBQUUsQ0FBQyxFQUFFLEdBQUcsRUFBRSxLQUFLLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDO2lCQUMvQjthQUNGLENBQUM7WUFDRixNQUFNLFFBQVEsR0FBRztnQkFDZixHQUFHLEVBQUUsS0FBSztnQkFDVixHQUFHLEVBQUU7b0JBQ0gsR0FBRyxFQUFFLEtBQUs7b0JBQ1YsR0FBRyxFQUFFLENBQUMsRUFBRSxHQUFHLEVBQUUsS0FBSyxFQUFFLENBQUM7aUJBQ3RCO2FBQ0YsQ0FBQztZQUNGLE1BQU0sQ0FBQyxJQUFBLHlDQUF5QixFQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3pELENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDLENBQUMsQ0FBQyJ9