"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.COMMON_TOKEN = void 0;
const chevrotain_1 = require("chevrotain");
const IDENTIFIER = (0, chevrotain_1.createToken)({
    name: 'IDENTIFIER',
    pattern: /[^()'",]+/,
});
const COMMA_SUPPORTED_IDENTIFIER = (0, chevrotain_1.createToken)({
    name: 'COMMA_SUPPORTED_IDENTIFIER',
    pattern: /[^()'"]+/,
});
exports.COMMON_TOKEN = {
    PAREN_START: (0, chevrotain_1.createToken)({ name: 'PAREN_START', pattern: /\(/ }),
    PAREN_END: (0, chevrotain_1.createToken)({ name: 'PAREN_END', pattern: /\)/ }),
    SQ_BRACKET_START: (0, chevrotain_1.createToken)({ name: 'SQ_BRACKET_START', pattern: /\[/ }),
    SQ_BRACKET_END: (0, chevrotain_1.createToken)({ name: 'SQ_BRACKET_END', pattern: /\]/ }),
    CURLY_START: (0, chevrotain_1.createToken)({ name: 'CURLY_START', pattern: /\{/ }),
    CURLY_END: (0, chevrotain_1.createToken)({ name: 'CURLY_END', pattern: /\}/ }),
    NUMBER_LITERAL: (0, chevrotain_1.createToken)({ name: 'NUMBER_LITERAL', pattern: /[1-9]\d*/ }),
    ALPHABET_LITERAL: (0, chevrotain_1.createToken)({
        name: 'ALPHABET_LITERAL',
        pattern: /[a-zA-Z]\d*/,
    }),
    COMMA: (0, chevrotain_1.createToken)({ name: 'COMMA', pattern: /,/ }),
    WHITESPACE: (0, chevrotain_1.createToken)({
        name: 'WHITESPACE',
        // do not delete the space inside aregex
        pattern: /[ \t\n\r]+/,
    }),
    WHITESPACE_SKIP: (0, chevrotain_1.createToken)({
        name: 'WHITESPACE',
        // do not delete the space inside aregex
        pattern: /[ \t\n\r]+/,
        group: chevrotain_1.Lexer.SKIPPED,
    }),
    PLUS: (0, chevrotain_1.createToken)({ name: 'PLUS', pattern: /\+/ }),
    MINUS: (0, chevrotain_1.createToken)({ name: 'MINUS', pattern: /-/ }),
    MULTI: (0, chevrotain_1.createToken)({ name: 'MULTI', pattern: /\*/ }),
    DIVIDE: (0, chevrotain_1.createToken)({ name: 'DIVIDE', pattern: /\// }),
    COLON: (0, chevrotain_1.createToken)({ name: 'COLON', pattern: /:/ }),
    SEMICOLON: (0, chevrotain_1.createToken)({ name: 'SEMICOLON', pattern: /;/ }),
    PIPE: (0, chevrotain_1.createToken)({ name: 'PIPE', pattern: /|/ }),
    SLASH: (0, chevrotain_1.createToken)({ name: 'SLASH', pattern: /\// }),
    BACKSLASH: (0, chevrotain_1.createToken)({ name: 'BACKSLASH', pattern: /\\/ }),
    DBL_QUOTE: (0, chevrotain_1.createToken)({ name: 'DBL_QUOTE', pattern: /"/ }),
    SGL_QUOTE: (0, chevrotain_1.createToken)({ name: 'SGL_QUOTE', pattern: /'/ }),
    IDENTIFIER: IDENTIFIER,
    COMMA_SUPPORTED_IDENTIFIER: COMMA_SUPPORTED_IDENTIFIER,
    EMPTY_QUOTED_IDENTIFIER: (0, chevrotain_1.createToken)({
        name: 'EMPTY_QUOTED_IDENTIFIER',
        pattern: /''|""|``/,
        longer_alt: IDENTIFIER,
    }),
    SUP_SGL_QUOTE_IDENTIFIER: (0, chevrotain_1.createToken)({
        name: 'SUP_SGL_QUOTE_IDENTIFIER',
        pattern: /'((?:\\'|[^'])+)'/,
        longer_alt: IDENTIFIER,
    }),
    SUP_DBL_QUOTE_IDENTIFIER: (0, chevrotain_1.createToken)({
        name: 'SUP_DBL_QUOTE_IDENTIFIER',
        pattern: /"((?:\\"|[^"])+)"/,
        longer_alt: IDENTIFIER,
    }),
    SUP_BACK_QUOTE_IDENTIFIER: (0, chevrotain_1.createToken)({
        name: 'SUP_BACK_QUOTE_IDENTIFIER',
        pattern: /`((?:\\`|[^`])+)`/,
        longer_alt: IDENTIFIER,
    }),
};
//# sourceMappingURL=data:application/json;base64,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