"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseParsingError = exports.parseLexingError = void 0;
const parseLexingError = (e) => {
    return `Lexing error: ${e.message}, please contact support`;
};
exports.parseLexingError = parseLexingError;
const parseParsingError = (e) => {
    var _a, _b;
    try {
        if (e.message.toLowerCase().startsWith('expecting token of type --> ')) {
            const operatorRegex = /^Expecting token of type --> (\S+) <-- but found --> '?([^\s']*)'? <--.?/i;
            const tokens = e.message.match(operatorRegex);
            const [expectation, found] = tokens.slice(1, 3);
            switch (expectation) {
                case 'OPERATOR': {
                    return `Invalid filter expression: '${found}' is not a recognized operator. Please use a valid comparison or logical operator`;
                }
                case 'PAREN_END': {
                    return `Invalid filter syntax: expected a closing parentheses ')', but found '${found}'`;
                }
                default: {
                    return `Invalid filter expression: '${found}' is not a valid token`;
                }
            }
        }
        else if (e.message
            .toLowerCase()
            .startsWith('expecting: one of these possible token sequences:')) {
            const optionRegex = /^\s*\d+\.\s*\[(.+)\]/im;
            const foundRegex = /but found: '?([^\s']+)'?/im;
            const messageParts = e.message.split('\n');
            const options = messageParts
                .slice(1, messageParts.length - 1)
                .map((t) => t.match(optionRegex)[1]);
            const found = messageParts
                .slice(messageParts.length - 1)[0]
                .match(foundRegex)[1];
            if (((_b = (_a = e.token) === null || _a === void 0 ? void 0 : _a.tokenType) === null || _b === void 0 ? void 0 : _b.name) === 'IDENTIFIER' &&
                options.some((k) => k === 'IDENTIFIER, COMMA')) {
                return `Invalid filter syntax: expected comma ',' followed with operator (and value) after field`;
            }
            if (options.some((k) => k === 'NOT_OPERATOR' || k === 'PAREN_START')) {
                return `Invalid filter syntax: expected a logical operator like '~not' or opening parenthesis, but found '${found}'`;
            }
        }
    }
    catch (_c) {
        // silent catch
    }
    return e.message;
};
exports.parseParsingError = parseParsingError;
//# sourceMappingURL=data:application/json;base64,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