"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseCst = exports.parseCallExpression = exports.parseParenClause = exports.parseAndOrClause = exports.parseNotClause = exports.parseMultiClause = exports.parseExpressionArguments = void 0;
const invalid_filter_error_1 = require("../../../lib/error/invalid-filter.error");
const common_cst_parser_1 = require("../common-cst-parser");
const parseExpressionArguments = (cst) => {
    if (cst.children.VARIABLE) {
        return (0, common_cst_parser_1.parseVariableAsArray)(cst.children.VARIABLE);
    }
    return undefined;
};
exports.parseExpressionArguments = parseExpressionArguments;
const parseMultiClause = (cst, opt) => {
    var _a;
    const result = {
        is_group: true,
        logical_op: (_a = opt === null || opt === void 0 ? void 0 : opt.logicalOperator) !== null && _a !== void 0 ? _a : 'and',
        children: [],
    };
    for (let index = 0; index < cst.children.clause.length; index++) {
        const clause = cst.children.clause[index];
        result.children.push(clause.name === 'and_or_clause'
            ? (0, exports.parseAndOrClause)(clause)
            : clause.name === 'not_clause'
                ? (0, exports.parseNotClause)(clause)
                : (0, exports.parseParenClause)(clause));
    }
    return result;
};
exports.parseMultiClause = parseMultiClause;
const parseNotClause = (cst) => {
    return (0, exports.parseParenClause)(cst.children.clause[0], {
        logicalOperator: 'not',
    });
};
exports.parseNotClause = parseNotClause;
const parseAndOrClause = (cst) => {
    if (!['~and', '~or'].includes(cst.children.operator[0].image)) {
        throw new invalid_filter_error_1.InvalidFilterError({
            message: `Invalid filter expression. Expected a valid logical operator like '~or' or '~and', but found '${cst.children.operator[0].image}'`,
        });
    }
    return (0, exports.parseParenClause)(cst.children.clause[0], {
        logicalOperator: cst.children.operator[0].image.replace('~', ''),
    });
};
exports.parseAndOrClause = parseAndOrClause;
const parseParenClause = (cst, opt) => {
    const clause = cst.children.clause[0];
    if (clause.name === 'multi_clause') {
        return (0, exports.parseMultiClause)(clause, opt);
    }
    else {
        return (0, exports.parseCallExpression)(clause, opt);
    }
};
exports.parseParenClause = parseParenClause;
const parseCallExpression = (cst, opt) => {
    const operator = cst.children.OPERATOR[0].image;
    const result = {
        is_group: false,
        field: (0, common_cst_parser_1.parseVariableAsString)(cst.children.VARIABLE),
        comparison_op: operator,
        logical_op: opt === null || opt === void 0 ? void 0 : opt.logicalOperator,
    };
    if (cst.children.expression_arguments &&
        cst.children.expression_arguments[0]) {
        const variables = (0, exports.parseExpressionArguments)(cst.children.expression_arguments[0]);
        result.value = variables;
    }
    handleBlankOperator(result);
    handleInOperator(result);
    handleOperatorAndValue(result);
    return result;
};
exports.parseCallExpression = parseCallExpression;
const handleBlankOperator = (filter) => {
    var _a, _b;
    switch (filter.comparison_op) {
        case 'is':
            if (((_a = filter.value) === null || _a === void 0 ? void 0 : _a[0]) === 'blank') {
                filter.comparison_op = 'blank';
                filter.value = undefined;
            }
            else if (((_b = filter.value) === null || _b === void 0 ? void 0 : _b[0]) === 'notblank') {
                filter.comparison_op = 'notblank';
                filter.value = undefined;
            }
            break;
        case 'isblank':
        case 'is_blank':
            filter.comparison_op = 'blank';
            break;
        case 'isnotblank':
        case 'is_not_blank':
        case 'is_notblank':
            filter.comparison_op = 'notblank';
            break;
    }
};
const handleInOperator = (filter) => {
    var _a;
    if (filter.comparison_op === 'in' && !Array.isArray(filter.value)) {
        filter.value = (_a = filter.value) === null || _a === void 0 ? void 0 : _a.split(',');
    }
};
const handleOperatorAndValue = (filter) => {
    if (Array.isArray(filter.value) &&
        [
            'eq',
            'neq',
            'not',
            'like',
            'nlike',
            'empty',
            'notempty',
            'null',
            'notnull',
            'checked',
            'notchecked',
            'blank',
            'notblank',
            'allof',
            'anyof',
            'nallof',
            'nanyof',
            'gt',
            'lt',
            'gte',
            'lte',
            'ge',
            'le',
            'isnot',
            'is',
            'gb_eq',
        ].includes(filter.comparison_op)) {
        if (filter.value.length === filter.value.filter((k) => k === null).length) {
            filter.value = null;
        }
        else {
            filter.value = filter.value.filter((k) => k).join(',');
        }
    }
    // for equality, replace with empty string if value is undefined
    else if (filter.value === undefined &&
        ['eq', 'neq', 'gb_eq'].includes(filter.comparison_op)) {
        filter.value = '';
    }
};
const parseCst = (cst) => {
    return (0, exports.parseMultiClause)(cst);
};
exports.parseCst = parseCst;
//# sourceMappingURL=data:application/json;base64,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