"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryFilterLexer = exports.QUERY_FILTER_TOKENS = exports.NOT_OPERATOR = exports.TOKEN_OPERATOR = exports.COMPARISON_SUB_OPS = exports.IS_WITHIN_COMPARISON_SUB_OPS = exports.COMPARISON_OPS_ALIAS = exports.COMPARISON_OPS = exports.GROUPBY_COMPARISON_OPS = void 0;
const chevrotain_1 = require("chevrotain");
const common_token_1 = require("../common-token");
exports.GROUPBY_COMPARISON_OPS = [
    // these are used for groupby
    'gb_eq',
    'gb_null',
];
exports.COMPARISON_OPS = [
    'eq',
    'neq',
    'not',
    'like',
    'nlike',
    'empty',
    'notempty',
    'null',
    'notnull',
    'checked',
    'notchecked',
    'blank',
    'notblank',
    'allof',
    'anyof',
    'nallof',
    'nanyof',
    'gt',
    'lt',
    'gte',
    'lte',
    'ge',
    'le',
    'in',
    'isnot',
    'is',
    'isWithin',
    'btw',
    'nbtw',
];
exports.COMPARISON_OPS_ALIAS = [
    'isblank',
    'is_blank',
    'isnotblank',
    'is_not_blank',
    'is_notblank',
];
exports.IS_WITHIN_COMPARISON_SUB_OPS = [
    'pastWeek',
    'pastMonth',
    'pastYear',
    'nextWeek',
    'nextMonth',
    'nextYear',
    'pastNumberOfDays',
    'nextNumberOfDays',
];
exports.COMPARISON_SUB_OPS = [
    'today',
    'tomorrow',
    'yesterday',
    'oneWeekAgo',
    'oneWeekFromNow',
    'oneMonthAgo',
    'oneMonthFromNow',
    'daysAgo',
    'daysFromNow',
    'exactDate',
    ...exports.IS_WITHIN_COMPARISON_SUB_OPS,
];
exports.TOKEN_OPERATOR = (0, chevrotain_1.createToken)({
    name: 'OPERATOR',
    pattern: new RegExp(`\\b(${[
        ...exports.COMPARISON_OPS,
        ...exports.COMPARISON_OPS_ALIAS,
        ...exports.GROUPBY_COMPARISON_OPS,
    ].join('|')})\\b`),
    longer_alt: common_token_1.COMMON_TOKEN.IDENTIFIER,
    categories: [common_token_1.COMMON_TOKEN.IDENTIFIER],
});
exports.NOT_OPERATOR = (0, chevrotain_1.createToken)({
    name: 'NOT_OPERATOR',
    pattern: /~not/,
    longer_alt: common_token_1.COMMON_TOKEN.IDENTIFIER,
    categories: [common_token_1.COMMON_TOKEN.IDENTIFIER],
});
exports.QUERY_FILTER_TOKENS = [
    common_token_1.COMMON_TOKEN.WHITESPACE_SKIP,
    exports.TOKEN_OPERATOR,
    exports.NOT_OPERATOR,
    common_token_1.COMMON_TOKEN.PAREN_START,
    common_token_1.COMMON_TOKEN.PAREN_END,
    common_token_1.COMMON_TOKEN.COMMA,
    common_token_1.COMMON_TOKEN.EMPTY_QUOTED_IDENTIFIER,
    common_token_1.COMMON_TOKEN.SUP_SGL_QUOTE_IDENTIFIER,
    common_token_1.COMMON_TOKEN.SUP_DBL_QUOTE_IDENTIFIER,
    common_token_1.COMMON_TOKEN.IDENTIFIER,
];
exports.QueryFilterLexer = new chevrotain_1.Lexer(exports.QUERY_FILTER_TOKENS);
//# sourceMappingURL=data:application/json;base64,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