"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryFilterParser = void 0;
const query_filter_lexer_1 = require("./query-filter-lexer");
const common_token_1 = require("../common-token");
const common_cst_parser_1 = require("../common-cst-parser");
const query_filter_cst_parser_1 = require("./query-filter-cst-parser");
class QueryFilterParser extends common_cst_parser_1.CommonCstParser {
    constructor() {
        super(query_filter_lexer_1.QUERY_FILTER_TOKENS);
        this.initializeRule();
        // very important to call this after all the rules have been defined.
        // otherwise the parser may not work correctly as it will lack information
        // derived during the self analysis phase.
        this.performSelfAnalysis();
    }
    initializeRule() {
        // not mandatory, using $ (or any other sign) to reduce verbosity (this. this. this. this. .......)
        const $ = this;
        // the parsing methods
        // we define the "rules" of how the syntax will be defined
        $.RULE('multi_clause', () => {
            $.OR([
                { ALT: () => $.SUBRULE($['not_clause'], { LABEL: 'clause' }) },
                { ALT: () => $.SUBRULE($['paren_clause'], { LABEL: 'clause' }) },
            ]);
            $.MANY({
                DEF: () => $.SUBRULE($['and_or_clause'], { LABEL: 'clause' }),
            });
        });
        $.RULE('and_or_clause', () => {
            $.CONSUME(common_token_1.COMMON_TOKEN.IDENTIFIER, { LABEL: 'operator' });
            $.SUBRULE($['paren_clause'], { LABEL: 'clause' });
        });
        $.RULE('not_clause', () => {
            $.CONSUME(query_filter_lexer_1.NOT_OPERATOR);
            $.SUBRULE($['paren_clause'], { LABEL: 'clause' });
        });
        $.RULE('paren_clause', () => {
            $.CONSUME(common_token_1.COMMON_TOKEN.PAREN_START);
            $.OR([
                { ALT: () => $.SUBRULE($['multi_clause'], { LABEL: 'clause' }) },
                { ALT: () => $.SUBRULE($['call_expression'], { LABEL: 'clause' }) },
            ]);
            $.CONSUME(common_token_1.COMMON_TOKEN.PAREN_END);
        });
        $.RULE('call_expression', () => {
            $.SUBRULE($['VARIABLE']);
            $.CONSUME2(common_token_1.COMMON_TOKEN.COMMA);
            $.CONSUME(query_filter_lexer_1.TOKEN_OPERATOR);
            $.OPTION(() => {
                $.CONSUME3(common_token_1.COMMON_TOKEN.COMMA);
                // even after comma, the expression arguments can be blank
                $.OPTION2(() => {
                    $.SUBRULE($['expression_arguments']);
                });
            });
        });
        $.RULE('expression_arguments', () => {
            $.MANY_SEP({
                SEP: common_token_1.COMMON_TOKEN.COMMA,
                DEF: () => {
                    $.SUBRULE2($['VARIABLE']);
                },
            });
        });
    }
    parse() {
        return this.multi_clause();
    }
    static parse(text) {
        var _a, _b;
        const parser = new QueryFilterParser();
        const lexResult = query_filter_lexer_1.QueryFilterLexer.tokenize(text);
        // setting a new input will RESET the parser instance's state.
        parser.input = lexResult.tokens;
        // any top level rule may be used as an entry point
        const cst = parser.parse();
        const parseErrors = [...parser.errors];
        let parsedCst = undefined;
        try {
            parsedCst = parseErrors.length === 0 ? (0, query_filter_cst_parser_1.parseCst)(cst) : undefined;
        }
        catch (error) {
            parseErrors.push({
                name: (_a = error === null || error === void 0 ? void 0 : error.message) !== null && _a !== void 0 ? _a : 'Invalid filter expression',
                message: (_b = error === null || error === void 0 ? void 0 : error.message) !== null && _b !== void 0 ? _b : 'Invalid filter expression',
                token: null,
                resyncedTokens: [],
                context: null,
            });
        }
        return {
            cst: cst,
            lexErrors: lexResult.errors,
            parseErrors,
            parsedCst,
        };
    }
}
exports.QueryFilterParser = QueryFilterParser;
//# sourceMappingURL=data:application/json;base64,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