"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReturnToBillingPage = exports.getUpgradeMessage = exports.PlanFeatureUpgradeMessages = exports.PlanLimitUpgradeMessages = exports.LOYALTY_SEAT_PRICE_CAP = exports.SEAT_PRICE_CAP = exports.LOYALTY_GRACE_PERIOD_END_DATE = exports.GRACE_PERIOD_DURATION = exports.HigherPlan = exports.PlanOrderToPlan = exports.PlanOrder = exports.PlanMeta = exports.LoyaltyPriceReverseLookupKeyMap = exports.LoyaltyPriceLookupKeyMap = exports.PlanPriceLookupKeys = exports.OnPremPlanTitles = exports.PlanTitles = exports.PlanFeatureTypes = exports.PlanLimitTypes = void 0;
var PlanLimitTypes;
(function (PlanLimitTypes) {
    PlanLimitTypes["LIMIT_FREE_WORKSPACE"] = "limit_free_workspace";
    PlanLimitTypes["LIMIT_EDITOR"] = "limit_editor";
    PlanLimitTypes["LIMIT_COMMENTER"] = "limit_commenter";
    PlanLimitTypes["LIMIT_API_PER_SECOND"] = "limit_api_per_second";
    PlanLimitTypes["LIMIT_AI_TOKEN"] = "limit_ai_token";
    PlanLimitTypes["LIMIT_API_CALL"] = "limit_api_call";
    PlanLimitTypes["LIMIT_AUDIT_RETENTION"] = "limit_audit_retention";
    PlanLimitTypes["LIMIT_AUTOMATION_RUN"] = "limit_automation_run";
    PlanLimitTypes["LIMIT_AUTOMATION_RETENTION"] = "limit_automation_retention";
    PlanLimitTypes["LIMIT_WORKFLOW_RUN"] = "limit_workflow_run";
    PlanLimitTypes["LIMIT_WORKFLOW_RETENTION"] = "limit_workflow_retention";
    PlanLimitTypes["LIMIT_WEBHOOK_PER_WORKSPACE"] = "limit_webhook";
    PlanLimitTypes["LIMIT_EXTENSION_PER_WORKSPACE"] = "limit_extension";
    PlanLimitTypes["LIMIT_SNAPSHOT_PER_WORKSPACE"] = "limit_snapshot";
    PlanLimitTypes["LIMIT_STORAGE_PER_WORKSPACE"] = "limit_storage";
    PlanLimitTypes["LIMIT_RECORD_PER_WORKSPACE"] = "limit_record";
    PlanLimitTypes["LIMIT_BASE_PER_WORKSPACE"] = "limit_base";
    PlanLimitTypes["LIMIT_EXTERNAL_SOURCE_PER_WORKSPACE"] = "limit_external_source";
    PlanLimitTypes["LIMIT_TABLE_PER_BASE"] = "limit_table_per_base";
    PlanLimitTypes["LIMIT_COLUMN_PER_TABLE"] = "limit_column_per_table";
    PlanLimitTypes["LIMIT_WEBHOOK_PER_TABLE"] = "limit_webhook_per_table";
    PlanLimitTypes["LIMIT_VIEW_PER_TABLE"] = "limit_view_per_table";
    PlanLimitTypes["LIMIT_FILTER_PER_VIEW"] = "limit_filter_per_view";
    PlanLimitTypes["LIMIT_SORT_PER_VIEW"] = "limit_sort_per_view";
    PlanLimitTypes["LIMIT_ATTACHMENTS_IN_CELL"] = "limit_attachments_in_cell";
    PlanLimitTypes["LIMIT_SCRIPT_PER_WORKSPACE"] = "limit_script";
    PlanLimitTypes["LIMIT_DASHBOARD_PER_WORKSPACE"] = "limit_dashboard";
    PlanLimitTypes["LIMIT_TEAM_MANAGEMENT"] = "limit_team_management";
})(PlanLimitTypes || (exports.PlanLimitTypes = PlanLimitTypes = {}));
var PlanFeatureTypes;
(function (PlanFeatureTypes) {
    PlanFeatureTypes["FEATURE_AI"] = "feature_ai";
    PlanFeatureTypes["FEATURE_AI_INTEGRATIONS"] = "feature_ai_integrations";
    PlanFeatureTypes["FEATURE_AT_MENTION"] = "feature_at_mention";
    PlanFeatureTypes["FEATURE_AUDIT_WORKSPACE"] = "feature_audit_workspace";
    PlanFeatureTypes["FEATURE_COMMENT_RESOLVE"] = "feature_comment_resolve";
    PlanFeatureTypes["FEATURE_CUSTOM_URL"] = "feature_custom_url";
    PlanFeatureTypes["FEATURE_DISCUSSION_MODE"] = "feature_discussion_mode";
    PlanFeatureTypes["FEATURE_EXTENSIONS"] = "feature_extensions";
    PlanFeatureTypes["FEATURE_FILE_MODE"] = "feature_file_mode";
    PlanFeatureTypes["FEATURE_FORM_URL_REDIRECTION"] = "feature_form_url_redirection";
    PlanFeatureTypes["FEATURE_FORM_CUSTOM_LOGO"] = "feature_form_custom_logo";
    PlanFeatureTypes["FEATURE_FORM_FIELD_ON_CONDITION"] = "feature_form_field_on_condition";
    PlanFeatureTypes["FEATURE_FORM_FIELD_VALIDATION"] = "feature_form_field_validation";
    PlanFeatureTypes["FEATURE_GROUP_BY_AGGREGATIONS"] = "feature_group_by_aggregations";
    PlanFeatureTypes["FEATURE_HIDE_BRANDING"] = "feature_hide_branding";
    PlanFeatureTypes["FEATURE_LTAR_LIMIT_SELECTION_BY_FILTER"] = "feature_ltar_limit_selection_by_filter";
    PlanFeatureTypes["FEATURE_LOOKUP_LIMIT_RECORDS_BY_FILTER"] = "feature_lookup_limit_records_by_filter";
    PlanFeatureTypes["FEATURE_ROLLUP_LIMIT_RECORDS_BY_FILTER"] = "feature_rollup_limit_records_by_filter";
    PlanFeatureTypes["FEATURE_PERSONAL_VIEWS"] = "feature_personal_views";
    PlanFeatureTypes["FEATURE_SSO"] = "feature_sso";
    PlanFeatureTypes["FEATURE_WEBHOOK_CUSTOM_PAYLOAD"] = "feature_webhook_custom_payload";
    PlanFeatureTypes["FEATURE_WORKSPACE_CUSTOM_LOGO"] = "feature_workspace_custom_logo";
    PlanFeatureTypes["FEATURE_CURRENT_USER_FILTER"] = "feature_current_user_filter";
    PlanFeatureTypes["FEATURE_ROW_COLOUR"] = "feature_row_colour";
    PlanFeatureTypes["FEATURE_TABLE_AND_FIELD_PERMISSIONS"] = "feature_table_and_field_permissions";
    PlanFeatureTypes["FEATURE_PRIVATE_BASES"] = "feature_private_bases";
    PlanFeatureTypes["FEATURE_API_MEMBER_MANAGEMENT"] = "feature_api_member_management";
    PlanFeatureTypes["FEATURE_TEAM_MANAGEMENT"] = "feature_team_management";
    PlanFeatureTypes["FEATURE_API_SCRIPT_MANAGEMENT"] = "feature_api_script_management";
    PlanFeatureTypes["FEATURE_API_VIEW_V3"] = "feature_api_view_v3";
    PlanFeatureTypes["FEATURE_CALENDAR_RANGE"] = "feature_calendar_range";
    PlanFeatureTypes["FEATURE_AI_PROMPT_FIELD"] = "feature_ai_prompt_field";
    PlanFeatureTypes["FEATURE_AI_BUTTON_FIELD"] = "feature_ai_button_field";
    PlanFeatureTypes["FEATURE_DUPLICATE_TABLE_TO_OTHER_BASE"] = "feature_duplicate_table_to_other_base";
    PlanFeatureTypes["FEATURE_DUPLICATE_TABLE_TO_OTHER_WS"] = "feature_duplicate_table_to_other_ws";
    PlanFeatureTypes["FEATURE_COPY_VIEW_SETTING_FROM_OTHER"] = "feature_copy_view_setting_other";
    PlanFeatureTypes["FEATURE_CARD_FIELD_HEADER_VISIBILITY"] = "feature_card_field_header_visibility";
    PlanFeatureTypes["FEATURE_SYNC"] = "feature_sync";
    PlanFeatureTypes["FEATURE_UNIQUE"] = "feature_unique";
})(PlanFeatureTypes || (exports.PlanFeatureTypes = PlanFeatureTypes = {}));
var PlanTitles;
(function (PlanTitles) {
    PlanTitles["FREE"] = "Free";
    PlanTitles["PLUS"] = "Plus";
    PlanTitles["BUSINESS"] = "Business";
    PlanTitles["ENTERPRISE"] = "Enterprise";
})(PlanTitles || (exports.PlanTitles = PlanTitles = {}));
var OnPremPlanTitles;
(function (OnPremPlanTitles) {
    OnPremPlanTitles["ENTERPRISE_STARTER"] = "EnterpriseStarter";
    OnPremPlanTitles["ENTERPRISE"] = "Enterprise";
})(OnPremPlanTitles || (exports.OnPremPlanTitles = OnPremPlanTitles = {}));
var PlanPriceLookupKeys;
(function (PlanPriceLookupKeys) {
    PlanPriceLookupKeys["PLUS_MONTHLY"] = "plus_monthly";
    PlanPriceLookupKeys["PLUS_YEARLY"] = "plus_yearly";
    PlanPriceLookupKeys["BUSINESS_MONTHLY"] = "business_monthly";
    PlanPriceLookupKeys["BUSINESS_YEARLY"] = "business_yearly";
})(PlanPriceLookupKeys || (exports.PlanPriceLookupKeys = PlanPriceLookupKeys = {}));
exports.LoyaltyPriceLookupKeyMap = {
    [PlanPriceLookupKeys.PLUS_MONTHLY]: 'loyalty_plus_monthly',
    [PlanPriceLookupKeys.PLUS_YEARLY]: 'loyalty_plus_yearly',
    [PlanPriceLookupKeys.BUSINESS_MONTHLY]: 'loyalty_business_monthly',
    [PlanPriceLookupKeys.BUSINESS_YEARLY]: 'loyalty_business_yearly',
};
exports.LoyaltyPriceReverseLookupKeyMap = {
    [exports.LoyaltyPriceLookupKeyMap[PlanPriceLookupKeys.PLUS_MONTHLY]]: PlanPriceLookupKeys.PLUS_MONTHLY,
    [exports.LoyaltyPriceLookupKeyMap[PlanPriceLookupKeys.PLUS_YEARLY]]: PlanPriceLookupKeys.PLUS_YEARLY,
    [exports.LoyaltyPriceLookupKeyMap[PlanPriceLookupKeys.BUSINESS_MONTHLY]]: PlanPriceLookupKeys.BUSINESS_MONTHLY,
    [exports.LoyaltyPriceLookupKeyMap[PlanPriceLookupKeys.BUSINESS_YEARLY]]: PlanPriceLookupKeys.BUSINESS_YEARLY,
};
exports.PlanMeta = {
    [PlanTitles.FREE]: {
        title: PlanTitles.FREE,
        color: 'var(--free-plan-color, #F9F9FA)',
        accent: 'var(--free-plan-accent, #E7E7E9)',
        primary: 'var(--free-plan-primary, #1F293A)',
        bgLight: 'var(--free-plan-bg-light, #F9F9FA)',
        bgDark: 'var(--free-plan-bg-dark, #F4F4F5)',
        border: 'var(--free-plan-border, #E7E7E9)',
        chartFillColor: 'var(--color-gray-500, #6A7184)',
        badgeBgColor: 'var(--free-plan-badge-bg-color, #F4F4F5)',
        badgeTextColor: 'var(--free-plan-badge-text-color, #1F293A)',
    },
    [PlanTitles.PLUS]: {
        title: PlanTitles.PLUS,
        color: 'var(--plus-plan-color, #EDF9FF)',
        accent: 'var(--plus-plan-accent, #AFE5FF)',
        primary: 'var(--plus-plan-primary, #207399)',
        bgLight: 'var(--plus-plan-bg-light, #EDF9FF)',
        bgDark: 'var(--plus-plan-bg-dark, #D7F2FF)',
        border: 'var(--plus-plan-border, #AFE5FF)',
        chartFillColor: 'var(--plus-plan-chart-fill-color, #207399)',
        badgeBgColor: 'var(--plus-plan-badge-bg-color, #D7F2FF)',
        badgeTextColor: 'var(--plus-plan-badge-text-color, #207399)',
    },
    [PlanTitles.BUSINESS]: {
        title: PlanTitles.BUSINESS,
        color: 'var(--business-plan-color, #FAF5FF)',
        accent: 'var(--business-plan-accent, #FEB0E8)',
        primary: 'var(--business-plan-primary, #972377)',
        bgLight: 'var(--business-plan-bg-light, #FFEEFB)',
        bgDark: 'var(--business-plan-bg-dark, #FED8F4)',
        border: 'var(--business-plan-border, #FEB0E8)',
        chartFillColor: 'var(--business-plan-chart-fill-color, #972377)',
        badgeBgColor: 'var(--business-plan-badge-bg-color, #FED8F4)',
        badgeTextColor: 'var(--business-plan-badge-text-color, #972377)',
    },
    [PlanTitles.ENTERPRISE]: {
        title: PlanTitles.ENTERPRISE,
        color: 'var(--enterprise-plan-color, #FFF5EF)',
        accent: 'var(--enterprise-plan-accent, #663B1F)',
        primary: 'var(--enterprise-plan-primary, #C86827)',
        bgLight: 'var(--enterprise-plan-bg-light, #FFF5EF)',
        bgDark: 'var(--enterprise-plan-bg-dark, #FEE6D6)',
        border: 'var(--enterprise-plan-border, #FDCDAD)',
        chartFillColor: 'var(--enterprise-plan-chart-fill-color, #C86827)',
        badgeBgColor: 'var(--enterprise-plan-badge-bg-color, #FEE6D6)',
        badgeTextColor: 'var(--enterprise-plan-badge-text-color, #C86827)',
    },
};
exports.PlanOrder = {
    [PlanTitles.FREE]: 0,
    [PlanTitles.PLUS]: 1,
    [PlanTitles.BUSINESS]: 2,
    [PlanTitles.ENTERPRISE]: 3,
};
exports.PlanOrderToPlan = Object.entries(exports.PlanOrder).reduce((acc, [plan, order]) => {
    acc[order] = plan;
    return acc;
}, {});
exports.HigherPlan = {
    [PlanTitles.FREE]: PlanTitles.PLUS,
    [PlanTitles.PLUS]: PlanTitles.BUSINESS,
    [PlanTitles.BUSINESS]: PlanTitles.ENTERPRISE,
};
exports.GRACE_PERIOD_DURATION = 14;
exports.LOYALTY_GRACE_PERIOD_END_DATE = '2025-09-03';
exports.SEAT_PRICE_CAP = 9;
exports.LOYALTY_SEAT_PRICE_CAP = 4;
exports.PlanLimitUpgradeMessages = {
    [PlanLimitTypes.LIMIT_FREE_WORKSPACE]: 'to add more workspaces.',
    [PlanLimitTypes.LIMIT_EDITOR]: 'to add more editors.',
    [PlanLimitTypes.LIMIT_COMMENTER]: 'to add more commenters.',
    [PlanLimitTypes.LIMIT_API_PER_SECOND]: 'due to reaching the API per second limit.',
    [PlanLimitTypes.LIMIT_AI_TOKEN]: 'due to reaching the AI token usage limit.',
    [PlanLimitTypes.LIMIT_API_CALL]: 'due to reaching the API call limit.',
    [PlanLimitTypes.LIMIT_AUDIT_RETENTION]: 'to increase audit retention.',
    [PlanLimitTypes.LIMIT_AUTOMATION_RUN]: 'to run more automations.',
    [PlanLimitTypes.LIMIT_AUTOMATION_RETENTION]: 'to increase automation retention.',
    [PlanLimitTypes.LIMIT_WEBHOOK_PER_WORKSPACE]: 'to add more webhooks.',
    [PlanLimitTypes.LIMIT_EXTENSION_PER_WORKSPACE]: 'to add more extensions.',
    [PlanLimitTypes.LIMIT_SNAPSHOT_PER_WORKSPACE]: 'due to reaching the snapshot limit.',
    [PlanLimitTypes.LIMIT_STORAGE_PER_WORKSPACE]: 'due to reaching the storage limit.',
    [PlanLimitTypes.LIMIT_RECORD_PER_WORKSPACE]: 'as the record limit has been reached.',
    [PlanLimitTypes.LIMIT_BASE_PER_WORKSPACE]: 'to add more bases.',
    [PlanLimitTypes.LIMIT_EXTERNAL_SOURCE_PER_WORKSPACE]: 'to connect more external sources.',
    [PlanLimitTypes.LIMIT_TABLE_PER_BASE]: 'to add more tables in a base.',
    [PlanLimitTypes.LIMIT_COLUMN_PER_TABLE]: 'to add more columns in a table.',
    [PlanLimitTypes.LIMIT_WEBHOOK_PER_TABLE]: 'to add more table-level webhooks.',
    [PlanLimitTypes.LIMIT_VIEW_PER_TABLE]: 'to add more views in a table.',
    [PlanLimitTypes.LIMIT_FILTER_PER_VIEW]: 'to add more filters in a view.',
    [PlanLimitTypes.LIMIT_SORT_PER_VIEW]: 'to add more sort rules in a view.',
    [PlanLimitTypes.LIMIT_ATTACHMENTS_IN_CELL]: 'to add more attachments in a cell.',
    [PlanLimitTypes.LIMIT_SCRIPT_PER_WORKSPACE]: 'to add more scripts in a workspace.',
    [PlanLimitTypes.LIMIT_DASHBOARD_PER_WORKSPACE]: 'to add more dashboards in a workspace.',
    [PlanLimitTypes.LIMIT_TEAM_MANAGEMENT]: 'to add more teams in a workspace.',
    [PlanLimitTypes.LIMIT_WORKFLOW_RUN]: 'to run more workflows.',
    [PlanLimitTypes.LIMIT_WORKFLOW_RETENTION]: 'to increase workflow logs retention.',
};
exports.PlanFeatureUpgradeMessages = {
    [PlanFeatureTypes.FEATURE_AI]: 'to enable AI features.',
    [PlanFeatureTypes.FEATURE_AI_INTEGRATIONS]: 'to use AI integrations.',
    [PlanFeatureTypes.FEATURE_AT_MENTION]: 'to use @mention in comments.',
    [PlanFeatureTypes.FEATURE_AUDIT_WORKSPACE]: 'to access workspace audit logs.',
    [PlanFeatureTypes.FEATURE_COMMENT_RESOLVE]: 'to enable comment resolution.',
    [PlanFeatureTypes.FEATURE_CUSTOM_URL]: 'to use a custom URL.',
    [PlanFeatureTypes.FEATURE_DISCUSSION_MODE]: 'to use discussion mode.',
    [PlanFeatureTypes.FEATURE_EXTENSIONS]: 'to enable extensions.',
    [PlanFeatureTypes.FEATURE_FILE_MODE]: 'to enable file mode.',
    [PlanFeatureTypes.FEATURE_FORM_URL_REDIRECTION]: 'to access redirect after form submission feature',
    [PlanFeatureTypes.FEATURE_FORM_CUSTOM_LOGO]: 'to add a custom logo to forms.',
    [PlanFeatureTypes.FEATURE_FORM_FIELD_ON_CONDITION]: 'to access conditional form fields feature',
    [PlanFeatureTypes.FEATURE_FORM_FIELD_VALIDATION]: 'to access form field validation feature',
    [PlanFeatureTypes.FEATURE_GROUP_BY_AGGREGATIONS]: 'to use group-by aggregations.',
    [PlanFeatureTypes.FEATURE_HIDE_BRANDING]: 'to remove branding.',
    [PlanFeatureTypes.FEATURE_LTAR_LIMIT_SELECTION_BY_FILTER]: 'to limit row selection by filters.',
    [PlanFeatureTypes.FEATURE_LOOKUP_LIMIT_RECORDS_BY_FILTER]: 'to limit lookup records by filters.',
    [PlanFeatureTypes.FEATURE_ROLLUP_LIMIT_RECORDS_BY_FILTER]: 'to limit rollup records by filters.',
    [PlanFeatureTypes.FEATURE_PERSONAL_VIEWS]: 'to use personal views.',
    [PlanFeatureTypes.FEATURE_SSO]: 'to enable SSO (Single Sign-On).',
    [PlanFeatureTypes.FEATURE_WEBHOOK_CUSTOM_PAYLOAD]: 'to send custom webhook payloads.',
    [PlanFeatureTypes.FEATURE_WORKSPACE_CUSTOM_LOGO]: 'to upload a custom image as workspace avatar',
    [PlanFeatureTypes.FEATURE_CURRENT_USER_FILTER]: 'to filter view by current user',
    [PlanFeatureTypes.FEATURE_ROW_COLOUR]: 'to use row colouring.',
    [PlanFeatureTypes.FEATURE_TABLE_AND_FIELD_PERMISSIONS]: 'to use table and field permissions.',
    [PlanFeatureTypes.FEATURE_PRIVATE_BASES]: 'to use private bases.',
    [PlanFeatureTypes.FEATURE_API_MEMBER_MANAGEMENT]: 'to use member management api.',
    [PlanFeatureTypes.FEATURE_TEAM_MANAGEMENT]: 'to use team management.',
    [PlanFeatureTypes.FEATURE_API_VIEW_V3]: 'to use view api.',
    [PlanFeatureTypes.FEATURE_API_SCRIPT_MANAGEMENT]: 'to use script api.',
    [PlanFeatureTypes.FEATURE_CALENDAR_RANGE]: 'to visualize records in a calendar range.',
    [PlanFeatureTypes.FEATURE_AI_PROMPT_FIELD]: 'to use AI text fields.',
    [PlanFeatureTypes.FEATURE_AI_BUTTON_FIELD]: 'to use AI button fields.',
    [PlanFeatureTypes.FEATURE_DUPLICATE_TABLE_TO_OTHER_BASE]: 'to target different base when duplicate table.',
    [PlanFeatureTypes.FEATURE_DUPLICATE_TABLE_TO_OTHER_WS]: 'to target different workspace when duplicate table.',
    [PlanFeatureTypes.FEATURE_COPY_VIEW_SETTING_FROM_OTHER]: 'to copy view configuration from another view.',
    [PlanFeatureTypes.FEATURE_CARD_FIELD_HEADER_VISIBILITY]: 'to hide field headers in Gallery and Kanban views.',
    [PlanFeatureTypes.FEATURE_SYNC]: 'to use sync feature.',
    [PlanFeatureTypes.FEATURE_UNIQUE]: 'to use unique constraint.',
};
const getUpgradeMessage = (limitOrFeature) => {
    if (!limitOrFeature)
        return '';
    if (exports.PlanLimitUpgradeMessages[limitOrFeature]) {
        return exports.PlanLimitUpgradeMessages[limitOrFeature];
    }
    if (exports.PlanFeatureUpgradeMessages[limitOrFeature]) {
        return exports.PlanFeatureUpgradeMessages[limitOrFeature];
    }
    return limitOrFeature;
};
exports.getUpgradeMessage = getUpgradeMessage;
var ReturnToBillingPage;
(function (ReturnToBillingPage) {
    ReturnToBillingPage["ORG"] = "org";
    ReturnToBillingPage["ACCOUNT"] = "account";
    ReturnToBillingPage["WS"] = "ws";
})(ReturnToBillingPage || (exports.ReturnToBillingPage = ReturnToBillingPage = {}));
//# sourceMappingURL=data:application/json;base64,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