export declare enum PermissionKey {
    TABLE_VISIBILITY = "TABLE_VISIBILITY",
    TABLE_RECORD_ADD = "TABLE_RECORD_ADD",
    TABLE_RECORD_DELETE = "TABLE_RECORD_DELETE",
    RECORD_FIELD_EDIT = "RECORD_FIELD_EDIT"
}
export declare enum PermissionGrantedType {
    ROLE = "role",
    USER = "user",
    NOBODY = "nobody"
}
export declare enum PermissionEntity {
    TABLE = "table",
    FIELD = "field"
}
export declare enum PermissionRole {
    OWNER = "owner",
    CREATOR = "creator",
    EDITOR = "editor",
    COMMENTER = "commenter",
    VIEWER = "viewer"
}
export declare enum PermissionOptionValue {
    VIEWERS_AND_UP = "viewers_and_up",
    COMMENTERS_AND_UP = "commenters_and_up",
    EDITORS_AND_UP = "editors_and_up",
    CREATORS_AND_UP = "creators_and_up",
    SPECIFIC_USERS = "specific_users",
    NOBODY = "nobody",
    EVERYONE = "everyone"
}
export interface PermissionOption {
    value: PermissionOptionValue;
    label: string;
    description: string;
    icon: string;
    isDefault?: boolean;
}
export declare const PermissionOptions: PermissionOption[];
export declare const PermissionRolePower: {
    owner: number;
    creator: number;
    editor: number;
    commenter: number;
    viewer: number;
};
export declare const PermissionRoleMap: {
    owner: PermissionRole;
    creator: PermissionRole;
    editor: PermissionRole;
    commenter: PermissionRole;
    viewer: PermissionRole;
    "workspace-level-owner": PermissionRole;
    "workspace-level-creator": PermissionRole;
    "workspace-level-editor": PermissionRole;
    "workspace-level-commenter": PermissionRole;
    "workspace-level-viewer": PermissionRole;
};
export declare const PermissionMeta: {
    TABLE_VISIBILITY: {
        minimumRole: PermissionRole;
        label: string;
        description: string;
        userSelectorDescription: string;
    };
    TABLE_RECORD_ADD: {
        minimumRole: PermissionRole;
        label: string;
        description: string;
        userSelectorDescription: string;
    };
    TABLE_RECORD_DELETE: {
        minimumRole: PermissionRole;
        label: string;
        description: string;
        userSelectorDescription: string;
    };
    RECORD_FIELD_EDIT: {
        minimumRole: PermissionRole;
        label: string;
        description: string;
        userSelectorDescription: string;
    };
};
export declare const getPermissionOption: (value: string) => PermissionOption | undefined;
export declare const getPermissionLabel: (value: string) => string;
export declare const getPermissionIcon: (value: string) => string;
export declare const getPermissionOptionValue: (grantedType: PermissionGrantedType, grantedRole?: PermissionRole) => PermissionOptionValue;
