"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPermissionOptionValue = exports.getPermissionIcon = exports.getPermissionLabel = exports.getPermissionOption = exports.PermissionMeta = exports.PermissionRoleMap = exports.PermissionRolePower = exports.PermissionOptions = exports.PermissionOptionValue = exports.PermissionRole = exports.PermissionEntity = exports.PermissionGrantedType = exports.PermissionKey = void 0;
const enums_1 = require("../enums");
var PermissionKey;
(function (PermissionKey) {
    PermissionKey["TABLE_VISIBILITY"] = "TABLE_VISIBILITY";
    PermissionKey["TABLE_RECORD_ADD"] = "TABLE_RECORD_ADD";
    PermissionKey["TABLE_RECORD_DELETE"] = "TABLE_RECORD_DELETE";
    PermissionKey["RECORD_FIELD_EDIT"] = "RECORD_FIELD_EDIT";
})(PermissionKey || (exports.PermissionKey = PermissionKey = {}));
var PermissionGrantedType;
(function (PermissionGrantedType) {
    PermissionGrantedType["ROLE"] = "role";
    PermissionGrantedType["USER"] = "user";
    PermissionGrantedType["NOBODY"] = "nobody";
})(PermissionGrantedType || (exports.PermissionGrantedType = PermissionGrantedType = {}));
var PermissionEntity;
(function (PermissionEntity) {
    PermissionEntity["TABLE"] = "table";
    PermissionEntity["FIELD"] = "field";
})(PermissionEntity || (exports.PermissionEntity = PermissionEntity = {}));
var PermissionRole;
(function (PermissionRole) {
    PermissionRole["OWNER"] = "owner";
    PermissionRole["CREATOR"] = "creator";
    PermissionRole["EDITOR"] = "editor";
    PermissionRole["COMMENTER"] = "commenter";
    PermissionRole["VIEWER"] = "viewer";
})(PermissionRole || (exports.PermissionRole = PermissionRole = {}));
// Permission option values used across the application
var PermissionOptionValue;
(function (PermissionOptionValue) {
    PermissionOptionValue["VIEWERS_AND_UP"] = "viewers_and_up";
    PermissionOptionValue["COMMENTERS_AND_UP"] = "commenters_and_up";
    PermissionOptionValue["EDITORS_AND_UP"] = "editors_and_up";
    PermissionOptionValue["CREATORS_AND_UP"] = "creators_and_up";
    PermissionOptionValue["SPECIFIC_USERS"] = "specific_users";
    PermissionOptionValue["NOBODY"] = "nobody";
    PermissionOptionValue["EVERYONE"] = "everyone";
})(PermissionOptionValue || (exports.PermissionOptionValue = PermissionOptionValue = {}));
exports.PermissionOptions = [
    {
        value: PermissionOptionValue.CREATORS_AND_UP,
        label: 'Creators & up',
        description: 'Members with Creator or Owner role',
        icon: 'role_creator',
    },
    {
        value: PermissionOptionValue.EDITORS_AND_UP,
        label: 'Editors & up',
        description: 'Members with Editor, Creator or Owner role',
        icon: 'role_editor',
        isDefault: true,
    },
    {
        value: PermissionOptionValue.VIEWERS_AND_UP,
        label: 'Viewers and up',
        description: 'Members with Viewer, Commenter, Editor, Creator or Owner role',
        icon: 'role_viewer',
    },
    {
        value: PermissionOptionValue.SPECIFIC_USERS,
        label: 'Specific users',
        description: 'Specific set of members',
        icon: 'ncUsers',
    },
    {
        value: PermissionOptionValue.EVERYONE,
        label: 'Everyone',
        description: 'All members can access',
        icon: 'ncUsers',
        isDefault: true,
    },
    {
        value: PermissionOptionValue.NOBODY,
        label: 'Nobody',
        description: 'No one can add records',
        icon: 'role_no_access',
    },
];
exports.PermissionRolePower = {
    [PermissionRole.OWNER]: 6,
    [PermissionRole.CREATOR]: 5,
    [PermissionRole.EDITOR]: 4,
    [PermissionRole.COMMENTER]: 3,
    [PermissionRole.VIEWER]: 2,
};
exports.PermissionRoleMap = {
    [enums_1.ProjectRoles.OWNER]: PermissionRole.OWNER,
    [enums_1.ProjectRoles.CREATOR]: PermissionRole.CREATOR,
    [enums_1.ProjectRoles.EDITOR]: PermissionRole.EDITOR,
    [enums_1.ProjectRoles.COMMENTER]: PermissionRole.COMMENTER,
    [enums_1.ProjectRoles.VIEWER]: PermissionRole.VIEWER,
    [enums_1.WorkspaceUserRoles.OWNER]: PermissionRole.OWNER,
    [enums_1.WorkspaceUserRoles.CREATOR]: PermissionRole.CREATOR,
    [enums_1.WorkspaceUserRoles.EDITOR]: PermissionRole.EDITOR,
    [enums_1.WorkspaceUserRoles.COMMENTER]: PermissionRole.COMMENTER,
    [enums_1.WorkspaceUserRoles.VIEWER]: PermissionRole.VIEWER,
};
exports.PermissionMeta = {
    [PermissionKey.TABLE_VISIBILITY]: {
        minimumRole: PermissionRole.VIEWER,
        label: 'Who can view table',
        description: 'can view table',
        userSelectorDescription: 'Only members selected here will be able to view and access this table.',
    },
    [PermissionKey.TABLE_RECORD_ADD]: {
        minimumRole: PermissionRole.EDITOR,
        label: 'Who can create records',
        description: 'can create records',
        userSelectorDescription: 'Only members selected here will be able to create records.',
    },
    [PermissionKey.TABLE_RECORD_DELETE]: {
        minimumRole: PermissionRole.EDITOR,
        label: 'Who can delete records',
        description: 'can delete records',
        userSelectorDescription: 'Only members selected here will be able to delete records.',
    },
    [PermissionKey.RECORD_FIELD_EDIT]: {
        minimumRole: PermissionRole.EDITOR,
        label: 'Who can edit data in this field',
        description: 'can edit records',
        userSelectorDescription: 'Only members selected here will be able to edit values in the {{field}} field.',
    },
};
// Utility functions for permission management
const getPermissionOption = (value) => {
    return exports.PermissionOptions.find((option) => option.value === value);
};
exports.getPermissionOption = getPermissionOption;
const getPermissionLabel = (value) => {
    var _a;
    return ((_a = (0, exports.getPermissionOption)(value)) === null || _a === void 0 ? void 0 : _a.label) || 'Editors & up';
};
exports.getPermissionLabel = getPermissionLabel;
const getPermissionIcon = (value) => {
    var _a;
    return ((_a = (0, exports.getPermissionOption)(value)) === null || _a === void 0 ? void 0 : _a.icon) || 'role_editor';
};
exports.getPermissionIcon = getPermissionIcon;
const getPermissionOptionValue = (grantedType, grantedRole) => {
    if (grantedType === PermissionGrantedType.ROLE) {
        if (grantedRole === PermissionRole.VIEWER) {
            return PermissionOptionValue.VIEWERS_AND_UP;
        }
        else if (grantedRole === PermissionRole.COMMENTER) {
            return PermissionOptionValue.COMMENTERS_AND_UP;
        }
        else if (grantedRole === PermissionRole.CREATOR) {
            return PermissionOptionValue.CREATORS_AND_UP;
        }
        else {
            return PermissionOptionValue.EDITORS_AND_UP;
        }
    }
    else if (grantedType === PermissionGrantedType.USER) {
        return PermissionOptionValue.SPECIFIC_USERS;
    }
    else if (grantedType === PermissionGrantedType.NOBODY) {
        return PermissionOptionValue.NOBODY;
    }
    // Default for table visibility is everyone, for others it's editors and up
    return PermissionOptionValue.EDITORS_AND_UP;
};
exports.getPermissionOptionValue = getPermissionOptionValue;
//# sourceMappingURL=data:application/json;base64,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