"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.REGEXP_NUMBER_VALUE = exports.REGEXP_INTL_LETTER = exports.REGEXP_JAPANESE = exports.REGEXP_HIRA_KATA_KANA = exports.REGEXP_MANDARIN = exports.REGEXP_CHINESE = exports.REGEXP_ALPHABET = exports.REGEXSTR_BACK_QUOTED_IDENTIFIER_SPECIAL_CHAR = exports.REGEXSTR_DBL_QUOTED_IDENTIFIER_SPECIAL_CHAR = exports.REGEXSTR_SGL_QUOTED_IDENTIFIER_SPECIAL_CHAR = exports.REGEXSTR_IDENTIFIER = exports.REGEXSTR_IDENTIFIER_SPECIAL_CHAR = exports.REGEXSTR_NUMERIC_ARABIC = exports.REGEXSTR_INTL_LETTER = exports.REGEXSTR_VIETNAMESE = exports.REGEXSTR_SYRIAC = exports.REGEXSTR_SINHALA = exports.REGEXSTR_MYANMAR = exports.REGEXSTR_MONGOLIAN = exports.REGEXSTR_MALAYALAM = exports.REGEXSTR_KHMER = exports.REGEXSTR_KANNADA = exports.REGEXSTR_GUJARATI = exports.REGEXSTR_GEORGIAN = exports.REGEXSTR_BENGALI = exports.REGEXSTR_ARMENIAN = exports.REGEXSTR_TAMIL = exports.REGEXSTR_THAI = exports.REGEXSTR_HEBREW = exports.REGEXSTR_GREEK = exports.REGEXSTR_DEVANAGARI = exports.REGEXSTR_ARABIC = exports.REGEXSTR_KOREAN = exports.REGEXSTR_HANGUL = exports.REGEXSTR_CYRILLIC = exports.REGEXSTR_JAPANESE = exports.REGEXSTR_HIRA_KATA_KANA = exports.REGEXSTR_MANDARIN = exports.REGEXSTR_CHINESE = exports.REGEXSTR_WHITESPACE = exports.REGEXSTR_ALPHABET = void 0;
exports.REGEXSTR_ALPHABET = 'A-Za-z';
exports.REGEXSTR_WHITESPACE = ' ';
exports.REGEXSTR_CHINESE = '一-龠';
exports.REGEXSTR_MANDARIN = exports.REGEXSTR_CHINESE;
exports.REGEXSTR_HIRA_KATA_KANA = 'ぁ-ゔァ-ヴー々〆〤ヶ';
exports.REGEXSTR_JAPANESE = exports.REGEXSTR_HIRA_KATA_KANA;
exports.REGEXSTR_CYRILLIC = '\u0400-\u04FF';
exports.REGEXSTR_HANGUL = ('\u1100-\u11FF\u3130-\u318F\uA960-\uA97F\uAC00-\uD7AF\uD7B0-\uD7FF');
exports.REGEXSTR_KOREAN = exports.REGEXSTR_HANGUL;
exports.REGEXSTR_ARABIC = '\u0621-\u064A';
exports.REGEXSTR_DEVANAGARI = '\u0900-\u097F';
exports.REGEXSTR_GREEK = '\u0370-\u03FF';
exports.REGEXSTR_HEBREW = '\u0590-\u05FF';
exports.REGEXSTR_THAI = '\u0E00-\u0E7F';
exports.REGEXSTR_TAMIL = '\u0B80-\u0BFF';
exports.REGEXSTR_ARMENIAN = '\u0530-\u058F';
exports.REGEXSTR_BENGALI = '\u0980-\u09FF';
exports.REGEXSTR_GEORGIAN = '\u10A0-\u10FF';
exports.REGEXSTR_GUJARATI = '\u0A80-\u0AFF';
exports.REGEXSTR_KANNADA = '\u0C80-\u0CFF';
exports.REGEXSTR_KHMER = '\u1780-\u17FF';
exports.REGEXSTR_MALAYALAM = '\u0D00-\u0D7F';
exports.REGEXSTR_MONGOLIAN = '\u1800-\u18AF';
exports.REGEXSTR_MYANMAR = '\u1000-\u109F';
exports.REGEXSTR_SINHALA = '\u0D80-\u0DFF';
exports.REGEXSTR_SYRIAC = '\u0700-\u074F';
// alphabet is ommitted to prevent duplicates
exports.REGEXSTR_VIETNAMESE = '\u0300-\u036F'; // Latin characters with diacritics
exports.REGEXSTR_INTL_LETTER = [
    exports.REGEXSTR_ALPHABET,
    exports.REGEXSTR_CHINESE,
    exports.REGEXSTR_CYRILLIC,
    exports.REGEXSTR_HIRA_KATA_KANA,
    exports.REGEXSTR_KOREAN,
    exports.REGEXSTR_ARABIC,
    exports.REGEXSTR_DEVANAGARI,
    exports.REGEXSTR_GREEK,
    exports.REGEXSTR_HEBREW,
    exports.REGEXSTR_THAI,
    exports.REGEXSTR_TAMIL,
    exports.REGEXSTR_ARMENIAN,
    exports.REGEXSTR_BENGALI,
    exports.REGEXSTR_GEORGIAN,
    exports.REGEXSTR_GUJARATI,
    exports.REGEXSTR_KANNADA,
    exports.REGEXSTR_KHMER,
    exports.REGEXSTR_MALAYALAM,
    exports.REGEXSTR_MONGOLIAN,
    exports.REGEXSTR_MYANMAR,
    exports.REGEXSTR_SINHALA,
    exports.REGEXSTR_SYRIAC,
    exports.REGEXSTR_VIETNAMESE,
].join('');
exports.REGEXSTR_NUMERIC_ARABIC = '0-9';
exports.REGEXSTR_IDENTIFIER_SPECIAL_CHAR = ('!@#$%^&*_+\\-=[\\]{};:\\\\|.<>/?');
exports.REGEXSTR_IDENTIFIER = [
    exports.REGEXSTR_INTL_LETTER,
    exports.REGEXSTR_NUMERIC_ARABIC,
    exports.REGEXSTR_IDENTIFIER_SPECIAL_CHAR,
].join('');
exports.REGEXSTR_SGL_QUOTED_IDENTIFIER_SPECIAL_CHAR = [
    exports.REGEXSTR_IDENTIFIER_SPECIAL_CHAR,
    '`"(),` ',
].join('');
exports.REGEXSTR_DBL_QUOTED_IDENTIFIER_SPECIAL_CHAR = [
    exports.REGEXSTR_IDENTIFIER_SPECIAL_CHAR,
    "`'(), ",
].join('');
exports.REGEXSTR_BACK_QUOTED_IDENTIFIER_SPECIAL_CHAR = [
    exports.REGEXSTR_IDENTIFIER_SPECIAL_CHAR,
    `'"(), `,
].join('');
exports.REGEXP_ALPHABET = new RegExp(`[${exports.REGEXSTR_ALPHABET}]*`);
exports.REGEXP_CHINESE = new RegExp(`[${exports.REGEXSTR_CHINESE}]*`);
exports.REGEXP_MANDARIN = exports.REGEXP_CHINESE;
exports.REGEXP_HIRA_KATA_KANA = new RegExp(`[${exports.REGEXSTR_HIRA_KATA_KANA}]*`);
exports.REGEXP_JAPANESE = exports.REGEXP_HIRA_KATA_KANA;
exports.REGEXP_INTL_LETTER = new RegExp(`[${exports.REGEXSTR_INTL_LETTER}]*`);
exports.REGEXP_NUMBER_VALUE = /^[+-]?((\d+(\.\d*)?)|(\.\d+))$/;
//# sourceMappingURL=data:application/json;base64,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