"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const token_1 = require("./token");
describe('regex-token', () => {
    it('will test alphabet', () => {
        const testValue = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${token_1.REGEXSTR_ALPHABET}]+`))[0]).toBe('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
    });
    it('will test arabic numeral', () => {
        const testValue = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${token_1.REGEXSTR_NUMERIC_ARABIC}]+`))[0]).toBe('0123456789');
    });
    it('will test chinese letters', () => {
        const testValue = '新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${token_1.REGEXSTR_CHINESE}]+`))[0]).toBe('新年快乐');
    });
    it('will test japanese letters', () => {
        const testValue = '新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${token_1.REGEXSTR_JAPANESE}]+`))[0]).toBe('おはようございます');
    });
    it('will test cryillic letters', () => {
        const testValue = '新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${token_1.REGEXSTR_CYRILLIC}]+`))[0]).toBe('ЁёАя');
    });
    it('will test international letters', () => {
        const testValue = '新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.';
        expect(testValue.match(new RegExp(`[${token_1.REGEXSTR_INTL_LETTER}]+`))[0]).toBe('新年快乐おはようございますЁёАяabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
    });
});
//# sourceMappingURL=data:application/json;base64,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