import { ProjectRoles, WorkspaceUserRoles } from './enums';
export declare function extractProjectRolePower(user: any, 
/**
 * forbiddenCallback is used to keep old function behaviour
 */
forbiddenCallback?: () => void): number;
/**
 * Get the power of the workspace role of the user.
 * @param user - The user object.
 * @returns The power of the workspace role of the user.
 */
export declare function extractWorkspaceRolePower(user: any, 
/**
 * forbiddenCallback is used to keep old function behaviour
 */ forbiddenCallback?: () => void): number;
/**
 * Map the workspace roles object to the project roles object.
 * @param wsRoles - The workspace roles object.
 * @returns The project roles object.
 */
export declare function mapWorkspaceRolesObjToProjectRolesObj(wsRoles: any): Record<string, any>;
export declare function getProjectRole(user: any, inheritFromWorkspace?: boolean): any;
export declare function hasMinimumRoleAccess(user: any, minimumRole: ProjectRoles, 
/**
 * forbiddenCallback is used to keep old function behaviour
 */
forbiddenCallback?: () => void): boolean;
export declare function extractBaseRoleFromWorkspaceRole(workspaceRole: string | null | undefined): string | null;
export declare function getEffectiveBaseRole({ baseRole, baseTeamRole, workspaceRole, workspaceTeamRole, defaultBaseRole, }: {
    baseRole: ProjectRoles;
    baseTeamRole?: ProjectRoles;
    workspaceRole?: WorkspaceUserRoles;
    workspaceTeamRole?: WorkspaceUserRoles;
    defaultBaseRole?: ProjectRoles;
}): ProjectRoles.OWNER | ProjectRoles.CREATOR | ProjectRoles.EDITOR | ProjectRoles.COMMENTER | ProjectRoles.VIEWER | ProjectRoles.NO_ACCESS;
