import { ColumnType, NormalColumnRequestType } from '../Api';
import UITypes from '../UITypes';
import { IDType } from './index';
import { SqlUi } from './SqlUI.types';
export declare class OracleUi implements SqlUi {
    static getNewTableColumns(): any[];
    static getNewColumn(suffix: any): {
        column_name: string;
        dt: string;
        dtx: string;
        ct: string;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        cdf: any;
        clen: number;
        np: any;
        ns: any;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: string;
        uip: string;
        uicn: string;
    };
    static getDefaultLengthForDatatype(type: any): string;
    static getDefaultLengthIsDisabled(type: any): any;
    static getDefaultValueForDatatype(type: any): string;
    static getDefaultScaleForDatatype(type: any): any;
    static colPropAIDisabled(col: any, columns: any): boolean;
    static colPropUNDisabled(_col: any): boolean;
    static onCheckboxChangeAI(col: any): void;
    static showScale(_columnObj: any): boolean;
    static removeUnsigned(columns: any): void;
    static columnEditable(colObj: any): boolean;
    static extractFunctionName(query: any): any;
    static extractProcedureName(query: any): any;
    static splitQueries(query: any): any;
    static onCheckboxChangeAU(col: any): void;
    /**
     * if sql statement is SELECT - it limits to a number
     * @param args
     * @returns {string|*}
     */
    sanitiseQuery(args: any): any;
    getColumnsFromJson(json: any, tn: any): any[];
    static colPropAuDisabled(_col: any): boolean;
    static getAbstractType(col: any): any;
    static getUIType(col: any): any;
    static getDataTypeForUiType(col: {
        uidt: UITypes | NormalColumnRequestType['uidt'];
    }, idType?: IDType): any;
    static getUnsupportedFnList(): string[];
    static getCurrentDateDefault(_col: Partial<ColumnType>): any;
    static isEqual(dataType1: string, dataType2: string): boolean;
    getNewTableColumns(): readonly any[];
    getNewColumn(suffix: string): {
        column_name: string;
        dt: string;
        dtx: string;
        ct: string;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        cdf: null;
        clen: number;
        np: number;
        ns: number;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: string;
        uip: string;
        uicn: string;
    };
    getDefaultLengthForDatatype(type: string): number | string;
    getDefaultLengthIsDisabled(type: string): any;
    getDefaultValueForDatatype(type: string): string;
    getDefaultScaleForDatatype(type: any): string;
    colPropAIDisabled(col: ColumnType, columns: ColumnType[]): boolean;
    colPropUNDisabled(col: ColumnType): boolean;
    onCheckboxChangeAI(col: ColumnType): void;
    showScale(columnObj: ColumnType): boolean;
    removeUnsigned(columns: ColumnType[]): void;
    columnEditable(colObj: ColumnType): boolean;
    onCheckboxChangeAU(col: ColumnType): void;
    colPropAuDisabled(col: ColumnType): boolean;
    getAbstractType(col: ColumnType): string;
    getUIType(col: ColumnType): string;
    getDataTypeForUiType(col: {
        uidt: UITypes;
    }, idType?: IDType): any;
    getDataTypeListForUiType(_col: {
        uidt: UITypes;
    }, _idType?: IDType): string[];
    getUnsupportedFnList(): string[];
    getCurrentDateDefault(_col: Partial<ColumnType>): any;
    isEqual(dataType1: string, dataType2: string): boolean;
    adjustLengthAndScale(_newColumn: Partial<ColumnType>, _oldColumn?: ColumnType): void;
    isParsedJsonReturnType(_col: ColumnType): boolean;
    get tableNameLengthLimit(): number;
}
