"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OracleUi = void 0;
const UITypes_1 = __importDefault(require("../UITypes"));
class OracleUi {
    //#region statics
    static getNewTableColumns() {
        return [
            {
                column_name: 'id',
                title: 'Id',
                dt: 'integer',
                dtx: 'integer',
                ct: 'int(11)',
                nrqd: false,
                rqd: true,
                ck: false,
                pk: true,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: 'ID',
                uip: '',
                uicn: '',
            },
            {
                column_name: 'title',
                title: 'Title',
                dt: 'TEXT',
                dtx: 'specificType',
                ct: null,
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: null,
                ns: null,
                dtxp: '45',
                dtxs: '',
                altered: 1,
                uidt: 'SingleLineText',
                uip: '',
                uicn: '',
            },
            // {
            //  column_name: "created_at",
            //   dt: "timestamp",
            //   dtx: "specificType",
            //   ct: "varchar(45)",
            //   nrqd: true,
            //   rqd: false,
            //   ck: false,
            //   pk: false,
            //   un: false,
            //   ai: false,
            //   cdf: 'CURRENT_TIMESTAMP',
            //   clen: 45,
            //   np: null,
            //   ns: null,
            //   dtxp: '',
            //   dtxs: ''
            // },
            // {
            //  column_name: "updated_at",
            //   dt: "timestamp",
            //   dtx: "specificType",
            //   ct: "varchar(45)",
            //   nrqd: true,
            //   rqd: false,
            //   ck: false,
            //   pk: false,
            //   un: false,
            //   ai: false,
            //   cdf: 'CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP',
            //   clen: 45,
            //   np: null,
            //   ns: null,
            //   dtxp: '',
            //   dtxs: ''
            // }
            {
                column_name: 'nc_order',
                title: 'nc_order',
                dt: 'number',
                dtx: 'specificType',
                ct: 'number(38,19)',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: 38,
                ns: 19,
                dtxp: '38,19',
                dtxs: '',
                altered: 1,
                uidt: UITypes_1.default.Order,
                uip: '',
                uicn: '',
                system: true,
            },
        ];
    }
    static getNewColumn(suffix) {
        return {
            column_name: 'title' + suffix,
            dt: 'varchar',
            dtx: 'specificType',
            ct: 'varchar(45)',
            nrqd: true,
            rqd: false,
            ck: false,
            pk: false,
            un: false,
            ai: false,
            cdf: null,
            clen: 45,
            np: null,
            ns: null,
            dtxp: '45',
            dtxs: '',
            altered: 1,
            uidt: 'SingleLineText',
            uip: '',
            uicn: '',
        };
    }
    // static getDefaultLengthForDatatype(type) {
    //   switch (type) {
    //     case "int":
    //       return 11;
    //       break;
    //     case "tinyint":
    //       return 1;
    //       break;
    //     case "smallint":
    //       return 5;
    //       break;
    //
    //     case "mediumint":
    //       return 9;
    //       break;
    //     case "bigint":
    //       return 20;
    //       break;
    //     case "bit":
    //       return 64;
    //       break;
    //     case "boolean":
    //       return '';
    //       break;
    //     case "float":
    //       return 12;
    //       break;
    //     case "decimal":
    //       return 10;
    //       break;
    //     case "double":
    //       return 22;
    //       break;
    //     case "serial":
    //       return 20;
    //       break;
    //     case "date":
    //       return '';
    //       break;
    //     case "datetime":
    //     case "timestamp":
    //       return 6;
    //       break;
    //     case "time":
    //       return '';
    //       break;
    //     case "year":
    //       return '';
    //       break;
    //     case "char":
    //       return 255;
    //       break;
    //     case "varchar":
    //       return 45;
    //       break;
    //     case "nchar":
    //       return 255;
    //       break;
    //     case "text":
    //       return '';
    //       break;
    //     case "tinytext":
    //       return '';
    //       break;
    //     case "mediumtext":
    //       return '';
    //       break;
    //     case "longtext":
    //       break;
    //       return ''
    //     case "binary":
    //       return 255;
    //       break;
    //     case "varbinary":
    //       return 65500;
    //       break;
    //     case "blob":
    //       return '';
    //       break;
    //     case "tinyblob":
    //       return '';
    //       break;
    //     case "mediumblob":
    //       return '';
    //       break;
    //     case "longblob":
    //       return '';
    //       break;
    //     case "enum":
    //       return '\'a\',\'b\'';
    //       break;
    //     case "set":
    //       return '\'a\',\'b\'';
    //       break;
    //     case "geometry":
    //       return '';
    //     case "point":
    //       return '';
    //     case "linestring":
    //       return '';
    //     case "polygon":
    //       return '';
    //     case "multipoint":
    //       return '';
    //     case "multilinestring":
    //       return '';
    //     case "multipolygon":
    //       return '';
    //     case "json":
    //       return ''
    //       break;
    //
    //   }
    //
    // }
    static getDefaultLengthForDatatype(type) {
        switch (type) {
            default:
                return '';
        }
    }
    static getDefaultLengthIsDisabled(type) {
        switch (type) {
            case 'integer':
                return true;
            case 'bfile':
            case 'binary rowid':
            case 'binary double':
            case 'binary_float':
            case 'blob':
            case 'canoical':
            case 'cfile':
            case 'char':
            case 'clob':
            case 'content pointer':
            case 'contigous array':
            case 'date':
            case 'decimal':
            case 'double precision':
            case 'float':
            case 'interval day to second':
            case 'interval year to month':
            case 'lob pointer':
            case 'long':
            case 'long raw':
            case 'named collection':
            case 'named object':
            case 'nchar':
            case 'nclob':
            case 'number':
            case 'nvarchar2':
            case 'octet':
            case 'oid':
            case 'pointer':
            case 'raw':
            case 'real':
            case 'ref':
            case 'ref cursor':
            case 'rowid':
            case 'signed binary integer':
            case 'smallint':
            case 'table':
            case 'time':
            case 'time with tz':
            case 'timestamp':
            case 'timestamp with local time zone':
            case 'timestamp with local tz':
            case 'timestamp with timezone':
            case 'timestamp with tz':
            case 'unsigned binary integer':
            case 'urowid':
            case 'varchar':
            case 'varchar2':
            case 'varray':
            case 'varying array':
                return false;
        }
    }
    static getDefaultValueForDatatype(type) {
        switch (type) {
            default:
                return '';
        }
    }
    static getDefaultScaleForDatatype(type) {
        switch (type) {
            case 'integer':
            case 'bfile':
            case 'binary rowid':
            case 'binary double':
            case 'binary_float':
            case 'blob':
            case 'canoical':
            case 'cfile':
            case 'char':
            case 'clob':
            case 'content pointer':
            case 'contigous array':
            case 'date':
            case 'decimal':
            case 'double precision':
            case 'float':
            case 'interval day to second':
            case 'interval year to month':
            case 'lob pointer':
            case 'long':
            case 'long raw':
            case 'named collection':
            case 'named object':
            case 'nchar':
            case 'nclob':
            case 'number':
            case 'nvarchar2':
            case 'octet':
            case 'oid':
            case 'pointer':
            case 'raw':
            case 'real':
            case 'ref':
            case 'ref cursor':
            case 'rowid':
            case 'signed binary integer':
            case 'smallint':
            case 'table':
            case 'time':
            case 'time with tz':
            case 'timestamp':
            case 'timestamp with local time zone':
            case 'timestamp with local tz':
            case 'timestamp with timezone':
            case 'timestamp with tz':
            case 'unsigned binary integer':
            case 'urowid':
            case 'varchar':
            case 'varchar2':
            case 'varray':
            case 'varying array':
                return ' ';
        }
    }
    static colPropAIDisabled(col, columns) {
        // console.log(col);
        if (col.dt === 'int4' ||
            col.dt === 'integer' ||
            col.dt === 'bigint' ||
            col.dt === 'smallint') {
            for (let i = 0; i < columns.length; ++i) {
                if (columns[i].cn !== col.cn && columns[i].ai) {
                    return true;
                }
            }
            return false;
        }
        else {
            return true;
        }
    }
    static colPropUNDisabled(_col) {
        // console.log(col);
        return true;
        // if (col.dt === 'int' ||
        //   col.dt === 'tinyint' ||
        //   col.dt === 'smallint' ||
        //   col.dt === 'mediumint' ||
        //   col.dt === 'bigint') {
        //   return false;
        // } else {
        //   return true;
        // }
    }
    static onCheckboxChangeAI(col) {
        console.log(col);
        if (col.dt === 'int' ||
            col.dt === 'bigint' ||
            col.dt === 'smallint' ||
            col.dt === 'tinyint') {
            col.altered = col.altered || 2;
        }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    static showScale(_columnObj) {
        return false;
    }
    static removeUnsigned(columns) {
        for (let i = 0; i < columns.length; ++i) {
            if (columns[i].altered === 1 &&
                !(columns[i].dt === 'int' ||
                    columns[i].dt === 'bigint' ||
                    columns[i].dt === 'tinyint' ||
                    columns[i].dt === 'smallint' ||
                    columns[i].dt === 'mediumint')) {
                columns[i].un = false;
                console.log('>> resetting unsigned value', columns[i].cn);
            }
            console.log(columns[i].cn);
        }
    }
    static columnEditable(colObj) {
        return colObj.tn !== '_evolutions' || colObj.tn !== 'nc_evolutions';
    }
    static extractFunctionName(query) {
        const reg = /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*FUNCTION\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
        const match = query.match(reg);
        return match && match[1];
    }
    static extractProcedureName(query) {
        const reg = /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*PROCEDURE\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
        const match = query.match(reg);
        return match && match[1];
    }
    static splitQueries(query) {
        /***
         * we are splitting based on semicolon
         * there are mechanism to escape semicolon within single/double quotes(string)
         */
        return query.match(/\b("[^"]*;[^"]*"|'[^']*;[^']*'|[^;])*;/g);
    }
    static onCheckboxChangeAU(col) {
        console.log(col);
        // if (1) {
        col.altered = col.altered || 2;
        // }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    /**
     * if sql statement is SELECT - it limits to a number
     * @param args
     * @returns {string|*}
     */
    sanitiseQuery(args) {
        let q = args.query.trim().split(';');
        if (q[0].startsWith('Select')) {
            q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
        }
        else if (q[0].startsWith('select')) {
            q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
        }
        else if (q[0].startsWith('SELECT')) {
            q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
        }
        else {
            return args.query;
        }
        return q;
    }
    getColumnsFromJson(json, tn) {
        const columns = [];
        try {
            if (typeof json === 'object' && !Array.isArray(json)) {
                const keys = Object.keys(json);
                for (let i = 0; i < keys.length; ++i) {
                    switch (typeof json[keys[i]]) {
                        case 'number':
                            if (Number.isInteger(json[keys[i]])) {
                                columns.push({
                                    dp: null,
                                    tn,
                                    column_name: keys[i],
                                    cno: keys[i],
                                    dt: 'int',
                                    np: 10,
                                    ns: 0,
                                    clen: null,
                                    cop: 1,
                                    pk: false,
                                    nrqd: false,
                                    rqd: false,
                                    un: false,
                                    ct: 'int(11) unsigned',
                                    ai: false,
                                    unique: false,
                                    cdf: null,
                                    cc: '',
                                    csn: null,
                                    dtx: 'specificType',
                                    dtxp: '11',
                                    dtxs: 0,
                                    altered: 1,
                                });
                            }
                            else {
                                columns.push({
                                    dp: null,
                                    tn,
                                    column_name: keys[i],
                                    cno: keys[i],
                                    dt: 'float',
                                    np: 10,
                                    ns: 2,
                                    clen: null,
                                    cop: 1,
                                    pk: false,
                                    nrqd: false,
                                    rqd: false,
                                    un: false,
                                    ct: 'int(11) unsigned',
                                    ai: false,
                                    unique: false,
                                    cdf: null,
                                    cc: '',
                                    csn: null,
                                    dtx: 'specificType',
                                    dtxp: '11',
                                    dtxs: 2,
                                    altered: 1,
                                });
                            }
                            break;
                        case 'string':
                            if (json[keys[i]].length <= 255) {
                                columns.push({
                                    dp: null,
                                    tn,
                                    column_name: keys[i],
                                    cno: keys[i],
                                    dt: 'varchar',
                                    np: 45,
                                    ns: 0,
                                    clen: null,
                                    cop: 1,
                                    pk: false,
                                    nrqd: false,
                                    rqd: false,
                                    un: false,
                                    ct: 'int(11) unsigned',
                                    ai: false,
                                    unique: false,
                                    cdf: null,
                                    cc: '',
                                    csn: null,
                                    dtx: 'specificType',
                                    dtxp: '45',
                                    dtxs: 0,
                                    altered: 1,
                                });
                            }
                            else {
                                columns.push({
                                    dp: null,
                                    tn,
                                    column_name: keys[i],
                                    cno: keys[i],
                                    dt: 'text',
                                    np: null,
                                    ns: 0,
                                    clen: null,
                                    cop: 1,
                                    pk: false,
                                    nrqd: false,
                                    rqd: false,
                                    un: false,
                                    ct: 'int(11) unsigned',
                                    ai: false,
                                    unique: false,
                                    cdf: null,
                                    cc: '',
                                    csn: null,
                                    dtx: 'specificType',
                                    dtxp: null,
                                    dtxs: 0,
                                    altered: 1,
                                });
                            }
                            break;
                        case 'boolean':
                            columns.push({
                                dp: null,
                                tn,
                                column_name: keys[i],
                                cno: keys[i],
                                dt: 'boolean',
                                np: 3,
                                ns: 0,
                                clen: null,
                                cop: 1,
                                pk: false,
                                nrqd: false,
                                rqd: false,
                                un: false,
                                ct: 'int(11) unsigned',
                                ai: false,
                                unique: false,
                                cdf: null,
                                cc: '',
                                csn: null,
                                dtx: 'specificType',
                                dtxp: '1',
                                dtxs: 0,
                                altered: 1,
                            });
                            break;
                        case 'object':
                            columns.push({
                                dp: null,
                                tn,
                                column_name: keys[i],
                                cno: keys[i],
                                dt: 'json',
                                np: 3,
                                ns: 0,
                                clen: null,
                                cop: 1,
                                pk: false,
                                nrqd: false,
                                rqd: false,
                                un: false,
                                ct: 'int(11) unsigned',
                                ai: false,
                                unique: false,
                                cdf: null,
                                cc: '',
                                csn: null,
                                dtx: 'specificType',
                                dtxp: null,
                                dtxs: 0,
                                altered: 1,
                            });
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        catch (e) {
            console.log('Error in getColumnsFromJson', e);
        }
        return columns;
    }
    static colPropAuDisabled(_col) {
        return true;
    }
    static getAbstractType(col) {
        var _a;
        switch ((_a = col.dt) === null || _a === void 0 ? void 0 : _a.toLowerCase()) {
            case 'integer':
                return 'integer';
            case 'bfile':
            case 'binary rowid':
            case 'binary double':
            case 'binary_float':
                return 'string';
            case 'blob':
                return 'blob';
            case 'canoical':
            case 'cfile':
            case 'char':
            case 'clob':
            case 'content pointer':
            case 'contigous array':
                return 'string';
            case 'date':
                return 'date';
            case 'decimal':
            case 'double precision':
            case 'float':
                return 'float';
            case 'interval day to second':
            case 'interval year to month':
                return 'string';
            case 'lob pointer':
                return 'string';
            case 'long':
                return 'integer';
            case 'long raw':
                return 'string';
            case 'named collection':
            case 'named object':
            case 'nchar':
            case 'nclob':
                return 'string';
            case 'nvarchar2':
            case 'octet':
            case 'oid':
            case 'pointer':
            case 'raw':
                return 'string';
            case 'real':
            case 'number':
                return 'float';
            case 'ref':
            case 'ref cursor':
            case 'rowid':
            case 'signed binary integer':
                return 'string';
            case 'smallint':
                return 'integer';
            case 'table':
                return 'string';
            case 'time':
            case 'time with tz':
                return 'time';
            case 'timestamp':
            case 'timestamp with local time zone':
            case 'timestamp with local tz':
            case 'timestamp with timezone':
            case 'timestamp with tz':
                return 'datetime';
            case 'unsigned binary integer':
            case 'urowid':
            case 'varchar':
            case 'varchar2':
                return 'string';
            case 'varray':
            case 'varying array':
                return 'string';
        }
        return 'string';
    }
    static getUIType(col) {
        switch (this.getAbstractType(col)) {
            case 'integer':
                return 'Number';
            case 'boolean':
                return 'Checkbox';
            case 'float':
                return 'Decimal';
            case 'date':
                return 'Date';
            case 'datetime':
                return 'CreatedTime';
            case 'time':
                return 'Time';
            case 'year':
                return 'Year';
            case 'string':
                return 'SingleLineText';
            case 'text':
                return 'LongText';
            case 'blob':
                return 'Attachment';
            case 'enum':
                return 'SingleSelect';
            case 'set':
                return 'MultiSelect';
            case 'json':
                return 'LongText';
        }
    }
    static getDataTypeForUiType(col, idType) {
        const colProp = {};
        switch (col.uidt) {
            case 'ID':
                {
                    const isAutoIncId = idType === 'AI';
                    const isAutoGenId = idType === 'AG';
                    colProp.dt = isAutoGenId ? 'varchar' : 'integer';
                    colProp.pk = true;
                    colProp.un = isAutoIncId;
                    colProp.ai = isAutoIncId;
                    colProp.rqd = true;
                    colProp.meta = isAutoGenId ? { ag: 'nc' } : undefined;
                }
                break;
            case 'ForeignKey':
                colProp.dt = 'varchar';
                break;
            case 'SingleLineText':
                colProp.dt = 'clob';
                break;
            case 'LongText':
                colProp.dt = 'clob';
                break;
            case 'Attachment':
                colProp.dt = 'clob';
                break;
            case 'GeoData':
                colProp.dt = 'varchar';
                break;
            case 'Checkbox':
                colProp.dt = 'tinyint';
                colProp.dtxp = 1;
                colProp.cdf = '0';
                break;
            case 'MultiSelect':
                colProp.dt = 'varchar2';
                break;
            case 'SingleSelect':
                colProp.dt = 'varchar2';
                break;
            case 'Collaborator':
                colProp.dt = 'varchar';
                break;
            case 'Date':
                colProp.dt = 'varchar';
                break;
            case 'Year':
                colProp.dt = 'year';
                break;
            case 'Time':
                colProp.dt = 'time';
                break;
            case 'PhoneNumber':
                colProp.dt = 'varchar';
                colProp.validate = {
                    func: ['isMobilePhone'],
                    args: [''],
                    msg: ['Validation failed : isMobilePhone'],
                };
                break;
            case 'Email':
                colProp.dt = 'varchar';
                colProp.validate = {
                    func: ['isEmail'],
                    args: [''],
                    msg: ['Validation failed : isEmail'],
                };
                break;
            case 'URL':
                colProp.dt = 'clob';
                colProp.validate = {
                    func: ['isURL'],
                    args: [''],
                    msg: ['Validation failed : isURL'],
                };
                break;
            case 'Number':
                colProp.dt = 'integer';
                break;
            case 'Decimal':
                colProp.dt = 'decimal';
                break;
            case 'Currency':
                colProp.dt = 'decimal';
                colProp.validate = {
                    func: ['isCurrency'],
                    args: [''],
                    msg: ['Validation failed : isCurrency'],
                };
                break;
            case 'Percent':
                colProp.dt = 'double';
                break;
            case 'Duration':
                colProp.dt = 'integer';
                break;
            case 'Rating':
                colProp.dt = 'integer';
                colProp.cdf = '0';
                break;
            case 'Formula':
                colProp.dt = 'varchar';
                break;
            case 'Rollup':
                colProp.dt = 'varchar';
                break;
            case 'Count':
                colProp.dt = 'integer';
                break;
            case 'Lookup':
                colProp.dt = 'varchar';
                break;
            case 'DateTime':
                colProp.dt = 'timestamp';
                break;
            case 'CreatedTime':
                colProp.dt = 'timestamp';
                break;
            case 'LastModifiedTime':
                colProp.dt = 'timestamp';
                break;
            case 'AutoNumber':
                colProp.dt = 'integer';
                break;
            case 'Barcode':
                colProp.dt = 'varchar';
                break;
            case 'Button':
                colProp.dt = 'varchar';
                break;
            default:
                colProp.dt = 'varchar';
                break;
        }
        return colProp;
    }
    static getUnsupportedFnList() {
        return [
            'XOR',
            'REGEX_MATCH',
            'REGEX_EXTRACT',
            'REGEX_REPLACE',
            'VALUE',
            'COUNTA',
            'COUNT',
            'ROUNDDOWN',
            'ROUNDUP',
            'DATESTR',
            'ARRAYSORT',
            'ARRAYUNIQUE',
            'ARRAYSLICE',
            'ARRAYCOMPACT',
        ];
    }
    static getCurrentDateDefault(_col) {
        return null;
    }
    static isEqual(dataType1, dataType2) {
        if (dataType1 === dataType2)
            return true;
        const abstractType1 = this.getAbstractType({ dt: dataType1 });
        const abstractType2 = this.getAbstractType({ dt: dataType2 });
        if (abstractType1 &&
            abstractType1 === abstractType2 &&
            ['integer', 'float'].includes(abstractType1))
            return true;
        return false;
    }
    //#endregion statics
    //#region methods
    getNewTableColumns() {
        return OracleUi.getNewTableColumns();
    }
    getNewColumn(suffix) {
        return OracleUi.getNewColumn(suffix);
    }
    getDefaultLengthForDatatype(type) {
        return OracleUi.getDefaultLengthForDatatype(type);
    }
    getDefaultLengthIsDisabled(type) {
        return OracleUi.getDefaultLengthIsDisabled(type);
    }
    getDefaultValueForDatatype(type) {
        return OracleUi.getDefaultValueForDatatype(type);
    }
    getDefaultScaleForDatatype(type) {
        return OracleUi.getDefaultScaleForDatatype(type);
    }
    colPropAIDisabled(col, columns) {
        return OracleUi.colPropAIDisabled(col, columns);
    }
    colPropUNDisabled(col) {
        return OracleUi.colPropUNDisabled(col);
    }
    onCheckboxChangeAI(col) {
        return OracleUi.onCheckboxChangeAI(col);
    }
    showScale(columnObj) {
        return OracleUi.showScale(columnObj);
    }
    removeUnsigned(columns) {
        return OracleUi.removeUnsigned(columns);
    }
    columnEditable(colObj) {
        return OracleUi.columnEditable(colObj);
    }
    onCheckboxChangeAU(col) {
        return OracleUi.onCheckboxChangeAU(col);
    }
    colPropAuDisabled(col) {
        return OracleUi.colPropAuDisabled(col);
    }
    getAbstractType(col) {
        return OracleUi.getAbstractType(col);
    }
    getUIType(col) {
        return OracleUi.getUIType(col);
    }
    getDataTypeForUiType(col, idType) {
        return OracleUi.getDataTypeForUiType(col, idType);
    }
    getDataTypeListForUiType(_col, _idType) {
        throw new Error('Not implemented');
    }
    getUnsupportedFnList() {
        return OracleUi.getUnsupportedFnList();
    }
    getCurrentDateDefault(_col) {
        return OracleUi.getCurrentDateDefault(_col);
    }
    isEqual(dataType1, dataType2) {
        return OracleUi.isEqual(dataType1, dataType2);
    }
    adjustLengthAndScale(_newColumn, _oldColumn) { }
    isParsedJsonReturnType(_col) {
        return false;
    }
    get tableNameLengthLimit() {
        return 255;
    }
}
exports.OracleUi = OracleUi;
// module.exports = PgUiHelp;
//# sourceMappingURL=data:application/json;base64,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