"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqlUiFactory = void 0;
const MysqlUi_1 = require("./MysqlUi");
const OracleUi_1 = require("./OracleUi");
const PgUi_1 = require("./PgUi");
const SqliteUi_1 = require("./SqliteUi");
const SnowflakeUi_1 = require("./SnowflakeUi");
const DatabricksUi_1 = require("./DatabricksUi");
// import {YugabyteUi} from "./YugabyteUi";
// import {TidbUi} from "./TidbUi";
// import {VitessUi} from "./VitessUi";
class SqlUiFactory {
    static create(connectionConfig) {
        // connectionConfig.meta = connectionConfig.meta || {};
        // connectionConfig.meta.dbtype = connectionConfig.meta.dbtype || "";
        if (connectionConfig.client === 'mysql' ||
            connectionConfig.client === 'mysql2') {
            // if (connectionConfig.meta.dbtype === "tidb")
            //   return Tidb;
            // if (connectionConfig.meta.dbtype === "vitess")
            //   return Vitess;
            return new MysqlUi_1.MysqlUi();
        }
        if (connectionConfig.client === 'sqlite3') {
            return new SqliteUi_1.SqliteUi();
        }
        if (connectionConfig.client === 'oracledb') {
            return new OracleUi_1.OracleUi();
        }
        if (connectionConfig.client === 'pg') {
            // if (connectionConfig.meta.dbtype === "yugabyte")
            //   return Yugabyte;
            return new PgUi_1.PgUi();
        }
        if (connectionConfig.client === 'snowflake') {
            return new SnowflakeUi_1.SnowflakeUi();
        }
        if (connectionConfig.client === 'databricks') {
            return new DatabricksUi_1.DatabricksUi();
        }
        throw new Error('Database not supported');
    }
}
exports.SqlUiFactory = SqlUiFactory;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3FsVWlGYWN0b3J5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2xpYi9zcWxVaS9TcWxVaUZhY3RvcnkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0EsdUNBQW9DO0FBQ3BDLHlDQUFzQztBQUN0QyxpQ0FBOEI7QUFDOUIseUNBQXNDO0FBQ3RDLCtDQUE0QztBQUM1QyxpREFBOEM7QUFHOUMsMkNBQTJDO0FBQzNDLG1DQUFtQztBQUNuQyx1Q0FBdUM7QUFFdkMsTUFBYSxZQUFZO0lBQ3ZCLE1BQU0sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCO1FBQzVCLHVEQUF1RDtRQUN2RCxxRUFBcUU7UUFDckUsSUFDRSxnQkFBZ0IsQ0FBQyxNQUFNLEtBQUssT0FBTztZQUNuQyxnQkFBZ0IsQ0FBQyxNQUFNLEtBQUssUUFBUSxFQUNwQyxDQUFDO1lBQ0QsK0NBQStDO1lBQy9DLGlCQUFpQjtZQUNqQixpREFBaUQ7WUFDakQsbUJBQW1CO1lBRW5CLE9BQU8sSUFBSSxpQkFBTyxFQUFFLENBQUM7UUFDdkIsQ0FBQztRQUVELElBQUksZ0JBQWdCLENBQUMsTUFBTSxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQzFDLE9BQU8sSUFBSSxtQkFBUSxFQUFFLENBQUM7UUFDeEIsQ0FBQztRQUNELElBQUksZ0JBQWdCLENBQUMsTUFBTSxLQUFLLFVBQVUsRUFBRSxDQUFDO1lBQzNDLE9BQU8sSUFBSSxtQkFBUSxFQUFFLENBQUM7UUFDeEIsQ0FBQztRQUVELElBQUksZ0JBQWdCLENBQUMsTUFBTSxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ3JDLG1EQUFtRDtZQUNuRCxxQkFBcUI7WUFDckIsT0FBTyxJQUFJLFdBQUksRUFBRSxDQUFDO1FBQ3BCLENBQUM7UUFFRCxJQUFJLGdCQUFnQixDQUFDLE1BQU0sS0FBSyxXQUFXLEVBQUUsQ0FBQztZQUM1QyxPQUFPLElBQUkseUJBQVcsRUFBRSxDQUFDO1FBQzNCLENBQUM7UUFFRCxJQUFJLGdCQUFnQixDQUFDLE1BQU0sS0FBSyxZQUFZLEVBQUUsQ0FBQztZQUM3QyxPQUFPLElBQUksMkJBQVksRUFBRSxDQUFDO1FBQzVCLENBQUM7UUFFRCxNQUFNLElBQUksS0FBSyxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDNUMsQ0FBQztDQUNGO0FBdkNELG9DQXVDQyJ9