import UITypes from '../UITypes';
import { IDType } from './index';
import { ColumnType } from '../../lib';
import { SqlUi } from '../../lib/sqlUi/SqlUI.types';
export declare class SqliteUi implements SqlUi {
    static getNewTableColumns(): ({
        column_name: string;
        title: string;
        dt: string;
        dtx: string;
        ct: string;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        cdf: any;
        clen: any;
        np: any;
        ns: number;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: string;
        uip: string;
        uicn: string;
        system?: undefined;
    } | {
        column_name: string;
        title: string;
        dt: string;
        dtx: string;
        ct: string;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        cdf: any;
        clen: number;
        np: any;
        ns: any;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: string;
        uip: string;
        uicn: string;
        system?: undefined;
    } | {
        column_name: string;
        title: string;
        dt: string;
        dtx: string;
        ct: string;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        clen: number;
        np: any;
        ns: any;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: UITypes;
        uip: string;
        uicn: string;
        system: boolean;
        cdf?: undefined;
    })[];
    static getNewColumn(suffix: any): {
        column_name: string;
        dt: string;
        dtx: string;
        ct: string;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        cdf: any;
        clen: number;
        np: any;
        ns: any;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: string;
        uip: string;
        uicn: string;
    };
    static getDefaultLengthForDatatype(_type: any): string;
    static getDefaultLengthIsDisabled(type: any): any;
    static getDefaultValueForDatatype(type: any): any;
    static getDefaultScaleForDatatype(type: any): any;
    static colPropAIDisabled(col: any, columns: any): boolean;
    static colPropUNDisabled(_col: any): boolean;
    static onCheckboxChangeAI(col: any): void;
    static showScale(_columnObj: any): boolean;
    static removeUnsigned(columns: any): void;
    static columnEditable(_colObj: any): boolean;
    static onCheckboxChangeAU(col: any): void;
    static colPropAuDisabled(col: any): boolean;
    static getAbstractType(col: any): any;
    static getUIType(col: any): any;
    static getDataTypeForUiType(col: {
        uidt: UITypes;
    }, idType?: IDType): any;
    static getDataTypeListForUiType(col: {
        uidt: UITypes;
    }, idType?: IDType): string[];
    static getUnsupportedFnList(): string[];
    static getCurrentDateDefault(_col: Partial<ColumnType>): any;
    static isEqual(dataType1: string, dataType2: string): boolean;
    getNewTableColumns(): readonly any[];
    getNewColumn(suffix: string): {
        column_name: string;
        dt: string;
        dtx: string;
        ct: string;
        nrqd: boolean;
        rqd: boolean;
        ck: boolean;
        pk: boolean;
        un: boolean;
        ai: boolean;
        cdf: null;
        clen: number;
        np: number;
        ns: number;
        dtxp: string;
        dtxs: string;
        altered: number;
        uidt: string;
        uip: string;
        uicn: string;
    };
    getDefaultLengthForDatatype(type: string): number | string;
    getDefaultLengthIsDisabled(type: string): any;
    getDefaultValueForDatatype(type: string): any;
    getDefaultScaleForDatatype(type: any): string;
    colPropAIDisabled(col: ColumnType, columns: ColumnType[]): boolean;
    colPropUNDisabled(col: ColumnType): boolean;
    onCheckboxChangeAI(col: ColumnType): void;
    showScale(columnObj: ColumnType): boolean;
    removeUnsigned(columns: ColumnType[]): void;
    columnEditable(colObj: ColumnType): boolean;
    onCheckboxChangeAU(col: ColumnType): void;
    colPropAuDisabled(col: ColumnType): boolean;
    getAbstractType(col: ColumnType): string;
    getUIType(col: ColumnType): string;
    getDataTypeForUiType(col: {
        uidt: UITypes;
    }, idType?: IDType): any;
    getDataTypeListForUiType(col: {
        uidt: UITypes;
    }, idType?: IDType): string[];
    getUnsupportedFnList(): string[];
    getCurrentDateDefault(_col: Partial<ColumnType>): any;
    isEqual(dataType1: string, dataType2: string): boolean;
    adjustLengthAndScale(_newColumn: Partial<ColumnType>, _oldColumn?: ColumnType): void;
    isParsedJsonReturnType(_col: ColumnType): boolean;
    get tableNameLengthLimit(): number;
}
