export declare enum AppendToLengthSuffix {
    _ = "_",
    dot = "dot"
}
/**
 * get a row & column given a numeric position
 * row & column start at 0
 */
export declare function getRowColPositionFromIndex({ stack, position, }: {
    stack: string;
    position: number;
}): {
    column: number;
    row: number;
};
export declare function appendToLength(param: {
    value: string;
    appendage: string;
    maxLength: number;
    isExists: (value: string) => Promise<boolean>;
    suffix?: AppendToLengthSuffix;
}): Promise<string>;
export declare function truncateToLength(param: {
    value: string;
    maxLength: number;
    currentIndex?: number;
    isExists: (value: string) => Promise<boolean>;
    suffix?: AppendToLengthSuffix;
}): Promise<string>;
/**
 * Generates a unique copy name by checking against existing names/items
 */
export declare function generateUniqueCopyName<T = string>(originalName: string, existing: T[] | string[], options?: {
    /** Property name or accessor function to get the name from objects */
    accessor?: keyof T | ((item: T) => string);
    /** Prefix to use (default: "Copy of") */
    prefix?: string | null;
    /** Separator before counter (default: " ") */
    separator?: string;
    /** Format for counter, use {counter} placeholder (default: "({counter})") */
    counterFormat?: string;
}): string;
export declare function escapeRegexString(string: string): string;
/**
 * Trim matching quotes from the string
 * @param str - The string to trim
 * @returns The trimmed string
 */
export declare const trimMatchingQuotes: (str?: string | null) => string;
/**
 * Get all matches of a regex in a string
 * @param str - The string to search
 * @param regex - The regular expression to match against
 * @returns An array of all matches of the regex in the string
 *
 * Note: Since we are using ES2017, `String.prototype.matchAll` is not available.
 * This function acts as a fallback to achieve the same behavior.
 */
export declare function stringAllMatches(str: string, regex: RegExp): RegExpExecArray[];
export declare function generateRandomUuid(): string;
