"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.trimMatchingQuotes = exports.AppendToLengthSuffix = void 0;
exports.getRowColPositionFromIndex = getRowColPositionFromIndex;
exports.appendToLength = appendToLength;
exports.truncateToLength = truncateToLength;
exports.generateUniqueCopyName = generateUniqueCopyName;
exports.escapeRegexString = escapeRegexString;
exports.stringAllMatches = stringAllMatches;
exports.generateRandomUuid = generateRandomUuid;
const uuid_1 = require("uuid");
const is_1 = require("./is");
const AppendToLengthSuffixConfig = {
    _: {
        replacement: '___{index}',
        replacementRegex: /___\s?(\d*)$/,
    },
    dot: {
        replacement: '...{index}',
        replacementRegex: /\.\.\.\s?(\d*)$/,
    },
};
var AppendToLengthSuffix;
(function (AppendToLengthSuffix) {
    AppendToLengthSuffix["_"] = "_";
    AppendToLengthSuffix["dot"] = "dot";
})(AppendToLengthSuffix || (exports.AppendToLengthSuffix = AppendToLengthSuffix = {}));
/**
 * get a row & column given a numeric position
 * row & column start at 0
 */
function getRowColPositionFromIndex({ stack, position, }) {
    const parts = stack.substring(0, position).split('\n');
    return {
        column: parts[parts.length - 1].length,
        row: parts.length - 1,
    };
}
async function appendToLength(param) {
    var _a, _b;
    const { value, appendage, maxLength, isExists } = param;
    const suffixConfig = AppendToLengthSuffixConfig[(_a = param.suffix) !== null && _a !== void 0 ? _a : AppendToLengthSuffix.dot];
    // if it's already in the form of truncated
    // skip with usual append
    if ((value + appendage).length > maxLength) {
        const existingIndex = (_b = value.match(suffixConfig.replacementRegex)) === null || _b === void 0 ? void 0 : _b[1];
        return truncateToLength({
            value,
            maxLength,
            currentIndex: !(0, is_1.ncIsUndefined)(existingIndex) && existingIndex !== ''
                ? Number(existingIndex)
                : undefined,
            isExists,
            suffix: param.suffix,
        });
    }
    let currentIndex = 1;
    let needle = value + appendage;
    while (await isExists(needle)) {
        needle = value + appendage + '_' + currentIndex++;
        if (needle.length >= maxLength) {
            return appendToLength(Object.assign(Object.assign({}, param), { appendage: appendage + '_' + currentIndex++, suffix: param.suffix }));
        }
    }
    return needle;
}
async function truncateToLength(param) {
    var _a;
    const { value, currentIndex, maxLength, isExists } = param;
    const suffixConfig = AppendToLengthSuffixConfig[(_a = param.suffix) !== null && _a !== void 0 ? _a : AppendToLengthSuffix.dot];
    const replacement = (0, is_1.ncIsUndefined)(currentIndex) ? '' : `${currentIndex}`;
    const suffix = suffixConfig.replacement.replace('{index}', replacement);
    const needle = value.substring(0, maxLength - suffix.length) + suffix;
    if (!(await isExists(needle))) {
        return needle;
    }
    else {
        return truncateToLength(Object.assign(Object.assign({}, param), { currentIndex: (0, is_1.ncIsUndefined)(currentIndex) ? 2 : currentIndex + 1 }));
    }
}
/**
 * Generates a unique copy name by checking against existing names/items
 */
function generateUniqueCopyName(originalName, existing, options = {}) {
    const { accessor, prefix = 'Copy of', separator = ' ', counterFormat = '({counter})', } = options;
    // Extract names from the existing array
    const existingNames = existing.map((item) => {
        if (typeof item === 'string')
            return item;
        if (accessor) {
            return typeof accessor === 'function'
                ? accessor(item)
                : String(item[accessor]);
        }
        // Default to 'title' property if no accessor specified
        return String(item.title);
    });
    const getPrefix = () => {
        return prefix ? `${prefix} ` : prefix !== null && prefix !== void 0 ? prefix : '';
    };
    let newName = `${getPrefix()}${originalName}`;
    let counter = 1;
    while (existingNames.includes(newName)) {
        const counterText = counterFormat.replace('{counter}', counter.toString());
        newName = `${getPrefix()}${originalName}${separator}${counterText}`;
        counter++;
    }
    return newName;
}
function escapeRegexString(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}
/**
 * Trim matching quotes from the string
 * @param str - The string to trim
 * @returns The trimmed string
 */
const trimMatchingQuotes = (str) => {
    var _a, _b;
    if (!(str === null || str === void 0 ? void 0 : str.trim()))
        return '';
    return (_b = (_a = str === null || str === void 0 ? void 0 : str.trim()) === null || _a === void 0 ? void 0 : _a.replace(/^(['"])(.*)\1$/, '$2')) !== null && _b !== void 0 ? _b : '';
};
exports.trimMatchingQuotes = trimMatchingQuotes;
/**
 * Get all matches of a regex in a string
 * @param str - The string to search
 * @param regex - The regular expression to match against
 * @returns An array of all matches of the regex in the string
 *
 * Note: Since we are using ES2017, `String.prototype.matchAll` is not available.
 * This function acts as a fallback to achieve the same behavior.
 */
function stringAllMatches(str, regex) {
    // Ensure regex has the global flag, because exec() needs it to iterate
    const globalRegex = new RegExp(regex.source, regex.flags.includes('g') ? regex.flags : regex.flags + 'g');
    const matches = [];
    let m;
    while ((m = globalRegex.exec(str)) !== null) {
        matches.push(m);
    }
    return matches;
}
function generateRandomUuid() {
    if ((crypto === null || crypto === void 0 ? void 0 : crypto.randomUUID) && typeof crypto.randomUUID === 'function') {
        return crypto.randomUUID();
    }
    return (0, uuid_1.v4)();
}
//# sourceMappingURL=data:application/json;base64,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