"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stringHelpers_1 = require("./stringHelpers");
describe('stringHelpers', () => {
    describe('truncateToLength', () => {
        it('will truncate string to max length', async () => {
            const cases = [
                {
                    value: '01234567890123456789',
                    currentIndex: undefined,
                    maxLength: 20,
                    existing: [],
                    expected: '01234567890123456...',
                },
                {
                    value: '01234567890123456789',
                    currentIndex: undefined,
                    maxLength: 20,
                    existing: ['01234567890123456...'],
                    expected: '0123456789012345...2',
                },
                {
                    value: '0123456789012345...9',
                    currentIndex: 9,
                    maxLength: 20,
                    existing: ['0123456789012345...9'],
                    expected: '012345678901234...10',
                },
            ];
            for (const eachCase of cases) {
                const isExists = async (needle) => {
                    return eachCase.existing.includes(needle);
                };
                const result = await (0, stringHelpers_1.truncateToLength)({
                    value: eachCase.value,
                    currentIndex: eachCase.currentIndex,
                    maxLength: eachCase.maxLength,
                    isExists,
                });
                expect(result).toBe(eachCase.expected);
            }
        });
        it('will truncate string to max length (_ suffix)', async () => {
            const cases = [
                {
                    value: '01234567890123456789',
                    currentIndex: undefined,
                    maxLength: 20,
                    existing: [],
                    expected: '01234567890123456___',
                },
                {
                    value: '01234567890123456789',
                    currentIndex: undefined,
                    maxLength: 20,
                    existing: ['01234567890123456___'],
                    expected: '0123456789012345___2',
                },
                {
                    value: '0123456789012345___9',
                    currentIndex: 9,
                    maxLength: 20,
                    existing: ['0123456789012345___9'],
                    expected: '012345678901234___10',
                },
            ];
            for (const eachCase of cases) {
                const isExists = async (needle) => {
                    return eachCase.existing.includes(needle);
                };
                const result = await (0, stringHelpers_1.truncateToLength)({
                    value: eachCase.value,
                    currentIndex: eachCase.currentIndex,
                    maxLength: eachCase.maxLength,
                    suffix: stringHelpers_1.AppendToLengthSuffix._,
                    isExists,
                });
                expect(result).toBe(eachCase.expected);
            }
        });
    });
    describe('appendToLength', () => {
        it('will append without problem', async () => {
            const cases = [
                {
                    value: 'abcdefghij',
                    appendage: ' klmnopq',
                    maxLength: 30,
                    existing: [],
                    expected: 'abcdefghij klmnopq',
                },
                {
                    value: 'abcdefghij',
                    appendage: ' klmnopq',
                    maxLength: 30,
                    existing: ['abcdefghij klmnopq'],
                    expected: 'abcdefghij klmnopq_1',
                },
                {
                    value: '012345678901234',
                    appendage: ' copy',
                    maxLength: 20,
                    existing: [],
                    expected: '012345678901234 copy',
                },
            ];
            for (const eachCase of cases) {
                const isExists = async (needle) => {
                    return eachCase.existing.includes(needle);
                };
                const result = await (0, stringHelpers_1.appendToLength)({
                    value: eachCase.value,
                    appendage: eachCase.appendage,
                    maxLength: eachCase.maxLength,
                    isExists,
                });
                expect(result).toBe(eachCase.expected);
            }
        });
        it('will append existing truncated', async () => {
            const cases = [
                {
                    value: '012345678901234',
                    appendage: ' copy',
                    maxLength: 20,
                    existing: ['012345678901234 copy'],
                    expected: '012345678901234...',
                },
                {
                    value: '012345678901234',
                    appendage: ' copy',
                    maxLength: 20,
                    existing: ['012345678901234 copy', '012345678901234...'],
                    expected: '012345678901234...2',
                },
            ];
            for (const eachCase of cases) {
                const isExists = async (needle) => {
                    return eachCase.existing.includes(needle);
                };
                const result = await (0, stringHelpers_1.appendToLength)({
                    value: eachCase.value,
                    appendage: eachCase.appendage,
                    maxLength: eachCase.maxLength,
                    isExists,
                });
                expect(result).toBe(eachCase.expected);
            }
        });
        it('will append existing truncated (_ suffix)', async () => {
            const cases = [
                {
                    value: '012345678901234',
                    appendage: ' copy',
                    maxLength: 20,
                    existing: ['012345678901234 copy'],
                    expected: '012345678901234___',
                },
                {
                    value: '012345678901234',
                    appendage: ' copy',
                    maxLength: 20,
                    existing: ['012345678901234 copy', '012345678901234___'],
                    expected: '012345678901234___2',
                },
            ];
            for (const eachCase of cases) {
                const isExists = async (needle) => {
                    return eachCase.existing.includes(needle);
                };
                const result = await (0, stringHelpers_1.appendToLength)({
                    value: eachCase.value,
                    appendage: eachCase.appendage,
                    maxLength: eachCase.maxLength,
                    isExists,
                    suffix: stringHelpers_1.AppendToLengthSuffix._,
                });
                expect(result).toBe(eachCase.expected);
            }
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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