"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TARGET_TABLES_META = exports.TARGET_TABLES = exports.SyncCategoryMeta = exports.SyncTypeMeta = exports.OnDeleteActionMeta = exports.SyncTriggerMeta = exports.SyncCategory = exports.OnDeleteAction = exports.SyncTrigger = exports.SyncType = void 0;
var SyncType;
(function (SyncType) {
    SyncType["Full"] = "full";
    SyncType["Incremental"] = "incremental";
})(SyncType || (exports.SyncType = SyncType = {}));
var SyncTrigger;
(function (SyncTrigger) {
    SyncTrigger["Manual"] = "manual";
    SyncTrigger["Schedule"] = "schedule";
    SyncTrigger["Webhook"] = "webhook";
})(SyncTrigger || (exports.SyncTrigger = SyncTrigger = {}));
var OnDeleteAction;
(function (OnDeleteAction) {
    OnDeleteAction["Delete"] = "delete";
    OnDeleteAction["MarkDeleted"] = "mark_deleted";
})(OnDeleteAction || (exports.OnDeleteAction = OnDeleteAction = {}));
var SyncCategory;
(function (SyncCategory) {
    SyncCategory["TICKETING"] = "ticketing";
    SyncCategory["HRIS"] = "hris";
    SyncCategory["CRM"] = "crm";
    SyncCategory["FILE_STORAGE"] = "file_storage";
    SyncCategory["CUSTOM"] = "custom";
})(SyncCategory || (exports.SyncCategory = SyncCategory = {}));
exports.SyncTriggerMeta = {
    [SyncTrigger.Manual]: {
        value: SyncTrigger.Manual,
        label: 'Manual',
        description: 'Sync changes only when explicitly requested.',
    },
    [SyncTrigger.Schedule]: {
        value: SyncTrigger.Schedule,
        label: 'Scheduled',
        description: 'Automatically sync data at predefined time intervals.',
    },
    [SyncTrigger.Webhook]: {
        value: SyncTrigger.Webhook,
        label: 'Webhook',
        description: 'Sync initiated instantly by external events or system notifications.',
    },
};
exports.OnDeleteActionMeta = {
    [OnDeleteAction.MarkDeleted]: {
        value: OnDeleteAction.MarkDeleted,
        label: 'Ignore',
        description: 'Keep records even if the source deletes them.',
    },
    [OnDeleteAction.Delete]: {
        value: OnDeleteAction.Delete,
        label: 'Delete',
        description: 'Remove records when they are deleted at the source.',
    },
};
exports.SyncTypeMeta = {
    [SyncType.Incremental]: {
        value: SyncType.Incremental,
        label: 'Incremental',
        description: 'Syncs only new or changed records.',
    },
    [SyncType.Full]: {
        value: SyncType.Full,
        label: 'Full',
        description: 'Syncs all records every run.',
    },
};
exports.SyncCategoryMeta = {
    [SyncCategory.TICKETING]: {
        value: SyncCategory.TICKETING,
        label: 'Ticketing',
        description: 'Sync issues, tickets, and related activity.',
        icon: 'ncClipboard',
    },
    [SyncCategory.HRIS]: {
        value: SyncCategory.HRIS,
        label: 'HRIS',
        description: 'Sync employees, leaves and timesheet.',
        icon: 'ncUsers',
    },
    [SyncCategory.CRM]: {
        value: SyncCategory.CRM,
        label: 'CRM',
        description: 'Sync customer and lead data.',
        icon: 'ncUsers',
    },
    [SyncCategory.FILE_STORAGE]: {
        value: SyncCategory.FILE_STORAGE,
        label: 'File Storage',
        description: 'Sync files, folders, and metadata.',
        icon: 'ncFolder',
    },
    [SyncCategory.CUSTOM]: {
        value: SyncCategory.CUSTOM,
        label: 'Custom',
        description: 'Build a sync for another service or app.',
        icon: 'ncDatabase',
        beta: true,
    },
};
var TARGET_TABLES;
(function (TARGET_TABLES) {
    TARGET_TABLES["TICKETING_TICKET"] = "ticketing_ticket";
    TARGET_TABLES["TICKETING_USER"] = "ticketing_user";
    TARGET_TABLES["TICKETING_COMMENT"] = "ticketing_comment";
    TARGET_TABLES["TICKETING_TEAM"] = "ticketing_team";
    TARGET_TABLES["HRIS_EMPLOYEE"] = "hris_employee";
    // one by one will be enabled
    // HRIS_BANK_INFO = 'hris_bank_info',
    // HRIS_BENEFIT = 'hris_benefit',
    // HRIS_COMPANY = 'hris_company',
    // HRIS_DEPENDENT = 'hris_dependent',
    // HRIS_EMPLOYEE_PAYROLL_RUN = 'hris_employee_payroll_run',
    TARGET_TABLES["HRIS_EMPLOYMENT"] = "hris_employment";
    // HRIS_GROUP = 'hris_group',
    TARGET_TABLES["HRIS_LOCATION"] = "hris_location";
    // HRIS_PAYROLL_RUN = 'hris_payroll_run',
    // HRIS_TIME_OFF = 'hris_time_off',
    // HRIS_TIME_OFF_BALANCE = 'hris_time_off_balance',
    // HRIS_TIMESHEET_ENTRY = 'hris_timesheet_entry',
    // some not prioritized HRIS tables are commented
    // HRIS_EMPLOYER_BENEFIT = 'hris_employer_benefit',
    TARGET_TABLES["FILE_STORAGE_FILE"] = "fs_file";
    TARGET_TABLES["FILE_STORAGE_FOLDER"] = "fs_folder";
    TARGET_TABLES["CRM_ACCOUNT"] = "crm_account";
    // CRM_ASSOCIATION = 'crm_association',
    // CRM_ASSOCIATION_TYPE = 'crm_association_type',
    TARGET_TABLES["CRM_CONTACT"] = "crm_contact";
    // CRM_CUSTOM_OBJECT = 'crm_custom_object',
    // CRM_CUSTOM_OBJECT_CLASS = 'crm_custom_object_class',
    // CRM_ENGAGEMENT = 'crm_engagement',
    // CRM_ENGAGEMENT_TYPE = 'crm_engagement_type',
    // CRM_LEAD = 'crm_lead',
    // CRM_NOTE = 'crm_note',
    // CRM_OPPORTUNITY = 'crm_opportunity',
    // CRM_STAGE = 'crm_stage',
    // CRM_TASK = 'crm_task',
    TARGET_TABLES["CRM_USER"] = "crm_user";
})(TARGET_TABLES || (exports.TARGET_TABLES = TARGET_TABLES = {}));
exports.TARGET_TABLES_META = {
    [TARGET_TABLES.TICKETING_TICKET]: {
        category: SyncCategory.TICKETING,
        value: TARGET_TABLES.TICKETING_TICKET,
        icon: 'ncBookOpen',
        label: 'Ticket',
        description: 'Represents a ticket, issue, task, or case.',
        required: true,
    },
    [TARGET_TABLES.TICKETING_USER]: {
        category: SyncCategory.TICKETING,
        value: TARGET_TABLES.TICKETING_USER,
        icon: 'ncUsers',
        label: 'User',
        description: 'Represents users in the source app.',
        required: true,
    },
    [TARGET_TABLES.TICKETING_COMMENT]: {
        category: SyncCategory.TICKETING,
        value: TARGET_TABLES.TICKETING_COMMENT,
        icon: 'ncMessageCircle',
        label: 'Comment',
        description: 'Represents comments added to a ticket.',
        required: false,
    },
    [TARGET_TABLES.TICKETING_TEAM]: {
        category: SyncCategory.TICKETING,
        value: TARGET_TABLES.TICKETING_TEAM,
        icon: 'ncUsers',
        label: 'Team',
        description: 'Represents teams or groups in the source system.',
        required: false,
    },
    [TARGET_TABLES.HRIS_EMPLOYEE]: {
        category: SyncCategory.HRIS,
        value: TARGET_TABLES.HRIS_EMPLOYEE,
        icon: 'ncUsers',
        label: 'HR_Employee',
        description: 'Represents human resources employee data.',
        required: true,
    },
    [TARGET_TABLES.FILE_STORAGE_FILE]: {
        category: SyncCategory.FILE_STORAGE,
        value: TARGET_TABLES.FILE_STORAGE_FILE,
        icon: 'file',
        label: 'FS_File',
        description: 'Represents file storage file metadata.',
        required: false,
    },
    [TARGET_TABLES.FILE_STORAGE_FOLDER]: {
        category: SyncCategory.FILE_STORAGE,
        value: TARGET_TABLES.FILE_STORAGE_FOLDER,
        icon: 'ncFolder',
        label: 'FS_Folder',
        description: 'Represents file storage folder metadata.',
        required: false,
    },
    // [TARGET_TABLES.HRIS_BANK_INFO]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_BANK_INFO,
    //   icon: 'ncDatabase',
    //   label: 'HR_Bank Info',
    //   description: 'Represents human resources bank information data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_BENEFIT]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_BENEFIT,
    //   icon: 'ncDatabase',
    //   label: 'HR_Benefit',
    //   description: 'Represents human resources benefit data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_COMPANY]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_COMPANY,
    //   icon: 'ncDatabase',
    //   label: 'HR_Company',
    //   description: 'Represents human resources company data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_DEPENDENT]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_DEPENDENT,
    //   icon: 'ncUsers',
    //   label: 'HR_Dependent',
    //   description: 'Represents human resources dependent data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_EMPLOYEE_PAYROLL_RUN]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_EMPLOYEE_PAYROLL_RUN,
    //   icon: 'ncDatabase',
    //   label: 'HR_Employee Payroll Run',
    //   description: 'Represents human resources employee payroll run data.',
    //   required: false,
    // },
    [TARGET_TABLES.HRIS_EMPLOYMENT]: {
        category: SyncCategory.HRIS,
        value: TARGET_TABLES.HRIS_EMPLOYMENT,
        icon: 'ncDatabase',
        label: 'HR_Employment',
        description: 'Represents human resources employment data.',
        required: false,
    },
    // [TARGET_TABLES.HRIS_GROUP]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_GROUP,
    //   icon: 'ncUsers',
    //   label: 'HR_Group',
    //   description: 'Represents human resources group data.',
    //   required: false,
    // },
    [TARGET_TABLES.HRIS_LOCATION]: {
        category: SyncCategory.HRIS,
        value: TARGET_TABLES.HRIS_LOCATION,
        icon: 'ncDatabase',
        label: 'HR_Location',
        description: 'Represents human resources location data.',
        required: false,
    },
    // [TARGET_TABLES.HRIS_PAYROLL_RUN]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_PAYROLL_RUN,
    //   icon: 'ncDatabase',
    //   label: 'HR - Payroll Run',
    //   description: 'Represents human resources payroll run data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_TIME_OFF]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_TIME_OFF,
    //   icon: 'ncDatabase',
    //   label: 'HR - Time Off',
    //   description: 'Represents human resources time off data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_TIME_OFF_BALANCE]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_TIME_OFF_BALANCE,
    //   icon: 'ncDatabase',
    //   label: 'HR - Time Off Balance',
    //   description: 'Represents human resources time off balance data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_TIMESHEET_ENTRY]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_TIMESHEET_ENTRY,
    //   icon: 'ncDatabase',
    //   label: 'HR - Timesheet Entry',
    //   description: 'Represents human resources timesheet entry data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_EMPLOYER_BENEFIT]: {
    //   category: SyncCategory.CUSTOM,
    //   value: TARGET_TABLES.HRIS_EMPLOYER_BENEFIT,
    //   icon: 'ncDatabase',
    //   label: 'HR - Employer Benefit',
    //   description: 'Represents human resources employer benefit data.',
    //   required: false,
    // },
    [TARGET_TABLES.CRM_ACCOUNT]: {
        category: SyncCategory.CRM,
        value: TARGET_TABLES.CRM_ACCOUNT,
        icon: 'ncUsers',
        label: 'CRM_Account',
        description: 'Represents crm account data.',
        required: true,
    },
    // [TARGET_TABLES.CRM_ASSOCIATION]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_ASSOCIATION,
    //   icon: 'link2',
    //   label: 'CRM_Association',
    //   description: 'Represents crm association data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_ASSOCIATION_TYPE]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_ASSOCIATION_TYPE,
    //   icon: 'label',
    //   label: 'CRM_Association_type',
    //   description: 'Represents crm association types data.',
    //   required: false,
    // },
    [TARGET_TABLES.CRM_CONTACT]: {
        category: SyncCategory.CRM,
        value: TARGET_TABLES.CRM_CONTACT,
        icon: 'ncUsers',
        label: 'CRM_Contact',
        description: 'Represents crm contact data.',
        required: true,
    },
    // [TARGET_TABLES.CRM_CUSTOM_OBJECT]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_CUSTOM_OBJECT,
    //   icon: 'box',
    //   label: 'CRM_Custom_Object',
    //   description: 'Represents crm custom object data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_CUSTOM_OBJECT_CLASS]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_CUSTOM_OBJECT_CLASS,
    //   icon: 'layers',
    //   label: 'CRM_Custom_Object_Class',
    //   description: 'Represents crm custom object class data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_ENGAGEMENT]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_ENGAGEMENT,
    //   icon: 'message-square',
    //   label: 'CRM_Engagement',
    //   description: 'Represents crm engagement data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_ENGAGEMENT_TYPE]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_ENGAGEMENT_TYPE,
    //   icon: 'tag',
    //   label: 'CRM_Engagement_Type',
    //   description: 'Represents crm engagement type data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_LEAD]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_LEAD,
    //   icon: 'user-plus',
    //   label: 'CRM_Lead',
    //   description: 'Represents crm lead data.',
    //   required: true,
    // },
    // [TARGET_TABLES.CRM_NOTE]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_NOTE,
    //   icon: 'file-text',
    //   label: 'CRM_Note',
    //   description: 'Represents crm note data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_OPPORTUNITY]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_OPPORTUNITY,
    //   icon: 'trending-up',
    //   label: 'CRM_Opportunity',
    //   description: 'Represents crm opportunity data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_STAGE]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_STAGE,
    //   icon: 'sliders',
    //   label: 'CRM_Stage',
    //   description: 'Represents crm stage data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_TASK]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_TASK,
    //   icon: 'check-square',
    //   label: 'CRM_Task',
    //   description: 'Represents crm task data.',
    //   required: false,
    // },
    [TARGET_TABLES.CRM_USER]: {
        category: SyncCategory.CRM,
        value: TARGET_TABLES.CRM_USER,
        icon: 'user',
        label: 'CRM_User',
        description: 'Represents crm user data.',
        required: true,
    },
};
//# sourceMappingURL=data:application/json;base64,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