"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isServiceUser = exports.NOCO_SERVICE_USERS = exports.ServiceUserType = void 0;
const ServiceUserType = {
    AUTOMATION_USER: 'AUTOMATION_USER',
    SYNC_USER: 'SYNC_USER',
    WORKFLOW_USER: 'WORKFLOW_USER',
};
exports.ServiceUserType = ServiceUserType;
const NOCO_SERVICE_USERS = {
    [ServiceUserType.AUTOMATION_USER]: {
        id: 'usrautomation',
        email: 'automation@nocodb.com',
        display_name: 'NocoDB Automation',
        email_verified: true,
    },
    [ServiceUserType.SYNC_USER]: {
        id: 'usrsync',
        email: 'sync-service@nocodb.com',
        display_name: 'NocoDB Sync',
        email_verified: true,
    },
    [ServiceUserType.WORKFLOW_USER]: {
        id: 'usrworkflow',
        email: 'workflow-service@nocodb.com',
        display_name: 'NocoDB Workflow',
        email_verified: true,
    },
};
exports.NOCO_SERVICE_USERS = NOCO_SERVICE_USERS;
const isServiceUser = (user, serviceType) => {
    if (!user)
        return false;
    if (Array.isArray(serviceType)) {
        return serviceType.some((type) => isServiceUser(user, type));
    }
    // If specific service type is provided, check against that service user only
    if (serviceType) {
        const serviceUser = NOCO_SERVICE_USERS[serviceType];
        return (user === null || user === void 0 ? void 0 : user.email) === serviceUser.email || (user === null || user === void 0 ? void 0 : user.id) === serviceUser.id;
    }
    // Otherwise, check against all service users
    return Object.values(NOCO_SERVICE_USERS).some((serviceUser) => (user === null || user === void 0 ? void 0 : user.email) === serviceUser.email || (user === null || user === void 0 ? void 0 : user.id) === serviceUser.id);
};
exports.isServiceUser = isServiceUser;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VydmljZVVzZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL3N5c3RlbS9zZXJ2aWNlVXNlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxNQUFNLGVBQWUsR0FBRztJQUN0QixlQUFlLEVBQUUsaUJBQWlCO0lBQ2xDLFNBQVMsRUFBRSxXQUFXO0lBQ3RCLGFBQWEsRUFBRSxlQUFlO0NBQ3RCLENBQUM7QUFnREYsMENBQWU7QUE5Q3hCLE1BQU0sa0JBQWtCLEdBQUc7SUFDekIsQ0FBQyxlQUFlLENBQUMsZUFBZSxDQUFDLEVBQUU7UUFDakMsRUFBRSxFQUFFLGVBQWU7UUFDbkIsS0FBSyxFQUFFLHVCQUF1QjtRQUM5QixZQUFZLEVBQUUsbUJBQW1CO1FBQ2pDLGNBQWMsRUFBRSxJQUFJO0tBQ3JCO0lBQ0QsQ0FBQyxlQUFlLENBQUMsU0FBUyxDQUFDLEVBQUU7UUFDM0IsRUFBRSxFQUFFLFNBQVM7UUFDYixLQUFLLEVBQUUseUJBQXlCO1FBQ2hDLFlBQVksRUFBRSxhQUFhO1FBQzNCLGNBQWMsRUFBRSxJQUFJO0tBQ3JCO0lBQ0QsQ0FBQyxlQUFlLENBQUMsYUFBYSxDQUFDLEVBQUU7UUFDL0IsRUFBRSxFQUFFLGFBQWE7UUFDakIsS0FBSyxFQUFFLDZCQUE2QjtRQUNwQyxZQUFZLEVBQUUsaUJBQWlCO1FBQy9CLGNBQWMsRUFBRSxJQUFJO0tBQ3JCO0NBQ08sQ0FBQztBQTJCZSxnREFBa0I7QUF2QjVDLE1BQU0sYUFBYSxHQUFHLENBQ3BCLElBQVMsRUFDVCxXQUErQyxFQUN0QyxFQUFFO0lBQ1gsSUFBSSxDQUFDLElBQUk7UUFBRSxPQUFPLEtBQUssQ0FBQztJQUV4QixJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLEVBQUUsQ0FBQztRQUMvQixPQUFPLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUMvRCxDQUFDO0lBRUQsNkVBQTZFO0lBQzdFLElBQUksV0FBVyxFQUFFLENBQUM7UUFDaEIsTUFBTSxXQUFXLEdBQUcsa0JBQWtCLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDcEQsT0FBTyxDQUFBLElBQUksYUFBSixJQUFJLHVCQUFKLElBQUksQ0FBRSxLQUFLLE1BQUssV0FBVyxDQUFDLEtBQUssSUFBSSxDQUFBLElBQUksYUFBSixJQUFJLHVCQUFKLElBQUksQ0FBRSxFQUFFLE1BQUssV0FBVyxDQUFDLEVBQUUsQ0FBQztJQUMxRSxDQUFDO0lBRUQsNkNBQTZDO0lBQzdDLE9BQU8sTUFBTSxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLElBQUksQ0FDM0MsQ0FBQyxXQUFXLEVBQUUsRUFBRSxDQUNkLENBQUEsSUFBSSxhQUFKLElBQUksdUJBQUosSUFBSSxDQUFFLEtBQUssTUFBSyxXQUFXLENBQUMsS0FBSyxJQUFJLENBQUEsSUFBSSxhQUFKLElBQUksdUJBQUosSUFBSSxDQUFFLEVBQUUsTUFBSyxXQUFXLENBQUMsRUFBRSxDQUNuRSxDQUFDO0FBQ0osQ0FBQyxDQUFDO0FBRTRDLHNDQUFhIn0=