"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Timer = void 0;
class Timer {
    constructor({ handler, time, errorHandler, }) {
        this.handler = handler;
        this.time = time;
        this.errorHandler = errorHandler;
    }
    static start(handler, 
    // set time default as 1 minute
    time = 60 * 1000, { errorHandler } = {}) {
        if (time <= 0) {
            // if time invalid, set it to 1 minute
            time = 60 * 1000;
        }
        const timer = new Timer({ handler, time, errorHandler });
        timer.start();
        return timer;
    }
    start() {
        this.timeoutHandle = setTimeout(async () => {
            var _a;
            try {
                await this.handler(this);
            }
            catch (ex) {
                (_a = this.errorHandler) === null || _a === void 0 ? void 0 : _a.call(this, ex);
            }
        }, this.time);
        // Safe unref call
        // need to do this because the typescript is not specific for node, and unref is node-specific
        if (this.timeoutHandle &&
            typeof this.timeoutHandle === 'object' &&
            'unref' in this.timeoutHandle) {
            this.timeoutHandle.unref();
        }
    }
    stop() {
        if (this.timeoutHandle) {
            clearTimeout(this.timeoutHandle);
            this.timeoutHandle = undefined;
        }
    }
}
exports.Timer = Timer;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGltZXIudXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL3RpbWVyLnV0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLE1BQWEsS0FBSztJQUNoQixZQUFvQixFQUNsQixPQUFPLEVBQ1AsSUFBSSxFQUNKLFlBQVksR0FLYjtRQUNDLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLElBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFDO0lBQ25DLENBQUM7SUFLRCxNQUFNLENBQUMsS0FBSyxDQUNWLE9BQW9CO0lBQ3BCLCtCQUErQjtJQUMvQixPQUFlLEVBQUUsR0FBRyxJQUFJLEVBQ3hCLEVBQUUsWUFBWSxLQUE2QyxFQUFFO1FBRTdELElBQUksSUFBSSxJQUFJLENBQUMsRUFBRSxDQUFDO1lBQ2Qsc0NBQXNDO1lBQ3RDLElBQUksR0FBRyxFQUFFLEdBQUcsSUFBSSxDQUFDO1FBQ25CLENBQUM7UUFDRCxNQUFNLEtBQUssR0FBRyxJQUFJLEtBQUssQ0FBQyxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsWUFBWSxFQUFFLENBQUMsQ0FBQztRQUN6RCxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDZCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFHRCxLQUFLO1FBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxVQUFVLENBQUMsS0FBSyxJQUFJLEVBQUU7O1lBQ3pDLElBQUksQ0FBQztnQkFDSCxNQUFNLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDM0IsQ0FBQztZQUFDLE9BQU8sRUFBRSxFQUFFLENBQUM7Z0JBQ1osTUFBQSxJQUFJLENBQUMsWUFBWSxxREFBRyxFQUFFLENBQUMsQ0FBQztZQUMxQixDQUFDO1FBQ0gsQ0FBQyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVkLGtCQUFrQjtRQUNsQiw4RkFBOEY7UUFDOUYsSUFDRSxJQUFJLENBQUMsYUFBYTtZQUNsQixPQUFPLElBQUksQ0FBQyxhQUFhLEtBQUssUUFBUTtZQUN0QyxPQUFPLElBQUksSUFBSSxDQUFDLGFBQWEsRUFDN0IsQ0FBQztZQUNBLElBQUksQ0FBQyxhQUFxQixDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3RDLENBQUM7SUFDSCxDQUFDO0lBQ0QsSUFBSTtRQUNGLElBQUksSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQ3ZCLFlBQVksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7WUFDakMsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7UUFDakMsQ0FBQztJQUNILENBQUM7Q0FDRjtBQTNERCxzQkEyREMifQ==