"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const timezoneUtils_1 = require("./timezoneUtils");
describe('timezoneUtils', () => {
    describe('getNodejsTimezone', () => {
        it('will get Asia/Kolkata', () => {
            expect((0, timezoneUtils_1.getNodejsTimezone)('Asia/Kolkata', 'Asia/Jakarta')).toBe('Asia/Calcutta');
        });
    });
    describe('isDateTimeStringHasTimezone', () => {
        it('will evaluate some test cases', () => {
            // Test cases with expected values
            const testCases = [
                { value: '2024-10-14T10:30:00Z', expected: true },
                { value: '2024-10-14T10:30:00+05:30', expected: true },
                { value: '2024-10-14T10:30:00+0530', expected: true },
                { value: '2024-10-14T10:30:00-08:00', expected: true },
                { value: '2024-10-14 10:30:00 EST', expected: true },
                { value: '2024-10-14 10:30:00 GMT', expected: true },
                { value: 'Mon Oct 14 2024 10:30:00 GMT+0530', expected: true },
                { value: '2024-10-14 10:30:00 (PST)', expected: true },
                { value: '2024-10-14 10:30:00', expected: false },
                { value: '2024-10-14T10:30:00', expected: false },
                { value: '10/14/2024 10:30 AM', expected: false },
                { value: 'Mon Oct 14 10:30:00 2024', expected: false },
            ];
            const failed = [];
            testCases.forEach(({ value, expected }) => {
                const result = (0, timezoneUtils_1.isDateTimeStringHasTimezone)(value);
                if (result !== expected) {
                    failed.push(`${value} is expected ${expected} but found ${result}`);
                }
            });
            if (failed.length) {
                console.log(failed);
            }
            expect(failed.length).toBe(0);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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