"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getColOptions = void 0;
const getColOptions = async (context, { column }) => {
    if ('colOptions' in column) {
        return column.colOptions;
    }
    else if ('getColOptions' in column) {
        return await column.getColOptions(Object.assign(Object.assign({}, context), { base_id: column.base_id || context.base_id }));
    }
    return undefined;
};
exports.getColOptions = getColOptions;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0Q29sT3B0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9saWIvdW5pZmllZE1ldGEvZ2V0Q29sT3B0aW9ucy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFHTyxNQUFNLGFBQWEsR0FBRyxLQUFLLEVBQ2hDLE9BQWtCLEVBQ2xCLEVBQUUsTUFBTSxFQUF1QyxFQUMvQyxFQUFFO0lBQ0YsSUFBSSxZQUFZLElBQUksTUFBTSxFQUFFLENBQUM7UUFDM0IsT0FBVSxNQUFNLENBQUMsVUFBVSxDQUFDO0lBQzlCLENBQUM7U0FBTSxJQUFJLGVBQWUsSUFBSSxNQUFNLEVBQUUsQ0FBQztRQUNyQyxPQUFVLE1BQU0sTUFBTSxDQUFDLGFBQWEsaUNBQy9CLE9BQU8sS0FDVixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sSUFBSSxPQUFPLENBQUMsT0FBTyxJQUMxQyxDQUFDO0lBQ0wsQ0FBQztJQUNELE9BQVUsU0FBUyxDQUFDO0FBQ3RCLENBQUMsQ0FBQztBQWJXLFFBQUEsYUFBYSxpQkFheEIifQ==