"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getColumns = void 0;
const getColumns = async (context, { model }) => {
    var _a;
    if (!model) {
        return undefined;
    }
    if ('columns' in model && ((_a = model.columns) === null || _a === void 0 ? void 0 : _a.length)) {
        return await model.columns;
    }
    else if ('getColumns' in model) {
        return await model.getColumns(Object.assign(Object.assign({}, context), { base_id: model.base_id || context.base_id }));
    }
    return undefined;
};
exports.getColumns = getColumns;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0Q29sdW1ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9saWIvdW5pZmllZE1ldGEvZ2V0Q29sdW1ucy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFHTyxNQUFNLFVBQVUsR0FBRyxLQUFLLEVBQzdCLE9BQWtCLEVBQ2xCLEVBQUUsS0FBSyxFQUFxQyxFQUM1QyxFQUFFOztJQUNGLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUNYLE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFDRCxJQUFJLFNBQVMsSUFBSSxLQUFLLEtBQUksTUFBQSxLQUFLLENBQUMsT0FBTywwQ0FBRSxNQUFNLENBQUEsRUFBRSxDQUFDO1FBQ2hELE9BQU8sTUFBTSxLQUFLLENBQUMsT0FBTyxDQUFDO0lBQzdCLENBQUM7U0FBTSxJQUFJLFlBQVksSUFBSSxLQUFLLEVBQUUsQ0FBQztRQUNqQyxPQUFPLE1BQU0sS0FBSyxDQUFDLFVBQVUsaUNBQ3hCLE9BQU8sS0FDVixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU8sSUFBSSxPQUFPLENBQUMsT0FBTyxJQUN6QyxDQUFDO0lBQ0wsQ0FBQztJQUNELE9BQU8sU0FBUyxDQUFDO0FBQ25CLENBQUMsQ0FBQztBQWhCVyxRQUFBLFVBQVUsY0FnQnJCIn0=