"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLinkInfo = void 0;
const lib_1 = require("../../lib");
const getColOptions_1 = require("../../lib/unifiedMeta/getColOptions");
const getColumns_1 = require("../../lib/unifiedMeta/getColumns");
const getLTARRelatedTable_1 = require("./getLTARRelatedTable");
/*
case 1:
table mw7s5x1ser8b8js
  ltar col: crxl9mqbdo9y06o
hm mkglmt0b0h84jp7
  ltar col: cps6kvxuf4s5phn

from crxl9mqbdo9y06o coloption:
  {
    "fk_column_id" : "crxl9mqbdo9y06o",
    "fk_related_model_id" : "mkglmt0b0h84jp7",
    "fk_child_column_id" : "ccz3j0i9d927vqf", // foreign key
    "fk_parent_column_id" : "ck2w0o0nhmjbvgj", // id
    "type": "hm"
  }

from cps6kvxuf4s5phn coloption:
  {
    "fk_column_id" : "cps6kvxuf4s5phn",
    "fk_related_model_id" : "mw7s5x1ser8b8js",
    "fk_child_column_id" : "ccz3j0i9d927vqf",
    "fk_parent_column_id" : "ck2w0o0nhmjbvgj",
    "type": "bt"
  }
*/
/*
case 2:
table mfz4bdhu24tl0yn
  ltar col: ckcs3zpt3opiadu
oo mdtzpm7lrqm0euq
  ltar col: ctmbms7ytc649i2

from ckcs3zpt3opiadu coloption:
  {
    "fk_column_id" : "ckcs3zpt3opiadu",
    "fk_related_model_id" : "mdtzpm7lrqm0euq",
    "fk_child_column_id" : "cjkd684tddrpvib", // foreign key
    "fk_parent_column_id" : "cytxetm7x9l24s4", // id
    "type": "oo"
  }

from ctmbms7ytc649i2 coloption:
  {
    "fk_column_id" : "ctmbms7ytc649i2",
    "fk_related_model_id" : "mfz4bdhu24tl0yn",
    "fk_child_column_id" : "cjkd684tddrpvib",
    "fk_parent_column_id" : "cytxetm7x9l24s4",
    "type": "oo"
  }

*/
const getLinkInfo = async (context, { linkColumn, sourceModel, getMeta, }) => {
    var _a, _b, _c, _d, _e, _f, _g;
    const relationColOptions = await (0, getColOptions_1.getColOptions)(context, {
        column: linkColumn,
    });
    switch (relationColOptions.type) {
        case lib_1.RelationTypes.ONE_TO_ONE:
        case lib_1.RelationTypes.BELONGS_TO:
        case lib_1.RelationTypes.HAS_MANY: {
            const joinIds = [
                relationColOptions.fk_child_column_id,
                relationColOptions.fk_parent_column_id,
            ];
            const sourceJoinColumn = (await (0, getColumns_1.getColumns)(context, { model: sourceModel })).find((col) => joinIds.includes(col.id));
            const targetContext = Object.assign(Object.assign({}, context), { base_id: (_a = relationColOptions.fk_related_base_id) !== null && _a !== void 0 ? _a : context.base_id });
            const targetModel = await (0, getLTARRelatedTable_1.getLTARRelatedTable)(targetContext, {
                colOptions: relationColOptions,
                getMeta,
            });
            const targetJoinColumn = (await targetModel.getColumns(targetContext)).find((col) => joinIds.includes(col.id));
            return {
                source: {
                    context,
                    model: sourceModel,
                    linkColumn: linkColumn,
                    joinColumn: sourceJoinColumn,
                },
                target: {
                    context: targetContext,
                    model: targetModel,
                    joinColumn: targetJoinColumn,
                },
                relationType: relationColOptions.type,
                isBelongsTo: (_c = (_b = linkColumn.meta) === null || _b === void 0 ? void 0 : _b.bt) !== null && _c !== void 0 ? _c : false,
                relationFromSource: ((_d = linkColumn.meta) === null || _d === void 0 ? void 0 : _d.bt)
                    ? lib_1.RelationTypes.BELONGS_TO
                    : relationColOptions.type,
            };
        }
        case lib_1.RelationTypes.MANY_TO_MANY: {
            const joinIds = [
                relationColOptions.fk_child_column_id,
                relationColOptions.fk_parent_column_id,
            ];
            const sourceJoinColumn = (await sourceModel.getColumns(context)).find((col) => joinIds.includes(col.id));
            const mmContext = Object.assign(Object.assign({}, context), { base_id: (_e = relationColOptions.fk_mm_base_id) !== null && _e !== void 0 ? _e : context.base_id });
            const mmModel = await getMeta(mmContext, {
                id: relationColOptions.fk_mm_model_id,
            });
            const mmColumns = await mmModel.getColumns(mmContext);
            let mmSourceJoinColumn;
            let mmTargetJoinColumn;
            if (sourceJoinColumn.id === relationColOptions.fk_parent_column_id) {
                mmSourceJoinColumn = mmColumns.find((col) => col.id === relationColOptions.fk_mm_parent_column_id);
                mmTargetJoinColumn = mmColumns.find((col) => col.id === relationColOptions.fk_mm_child_column_id);
            }
            else {
                mmSourceJoinColumn = mmColumns.find((col) => col.id === relationColOptions.fk_mm_child_column_id);
                mmTargetJoinColumn = mmColumns.find((col) => col.id === relationColOptions.fk_mm_parent_column_id);
            }
            const targetContext = Object.assign(Object.assign({}, context), { base_id: (_f = relationColOptions.fk_related_base_id) !== null && _f !== void 0 ? _f : context.base_id });
            const targetModel = await relationColOptions.getRelatedTable(targetContext);
            const targetJoinColumn = (await targetModel.getColumns(targetContext)).find((col) => joinIds.includes(col.id));
            return {
                source: {
                    context,
                    model: sourceModel,
                    linkColumn: linkColumn,
                    joinColumn: sourceJoinColumn,
                },
                mm: {
                    sourceJoinColumn: mmSourceJoinColumn,
                    targetJoinColumn: mmTargetJoinColumn,
                    model: mmModel,
                    context: mmContext,
                },
                target: {
                    context: targetContext,
                    model: targetModel,
                    joinColumn: targetJoinColumn,
                },
                relationType: relationColOptions.type,
                isBelongsTo: false,
                relationFromSource: ((_g = linkColumn.meta) === null || _g === void 0 ? void 0 : _g.bt)
                    ? lib_1.RelationTypes.BELONGS_TO
                    : relationColOptions.type,
            };
        }
        // should not be possible to land into this
        default:
            return undefined;
    }
};
exports.getLinkInfo = getLinkInfo;
//# sourceMappingURL=data:application/json;base64,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