"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLookupRelatedInfo = void 0;
const getLTARRelatedTable_1 = require("./getLTARRelatedTable");
const getContextFromObject_1 = require("./getContextFromObject");
const getColOptions_1 = require("./getColOptions");
const getColumns_1 = require("./getColumns");
const getLookupRelatedInfo = async (context, { colOptions, columns, getMeta, }) => {
    var _a;
    let relationColumn;
    relationColumn = columns.find((col) => col.id === colOptions.fk_relation_column_id);
    if (!relationColumn && 'getRelationColumn' in colOptions) {
        relationColumn = await colOptions.getRelationColumn(Object.assign(Object.assign({}, context), { base_id: ((_a = columns === null || columns === void 0 ? void 0 : columns[0]) === null || _a === void 0 ? void 0 : _a.base_id) || context.base_id }));
    }
    const relatedTable = await (0, getLTARRelatedTable_1.getLTARRelatedTable)((0, getContextFromObject_1.getContextFromObject)(relationColumn), {
        colOptions: await (0, getColOptions_1.getColOptions)((0, getContextFromObject_1.getContextFromObject)(relationColumn), {
            column: relationColumn,
        }),
        getMeta,
    });
    let lookupColumn;
    if ('getLookupColumn' in colOptions) {
        lookupColumn = await colOptions.getLookupColumn(Object.assign(Object.assign({}, context), { base_id: (relatedTable === null || relatedTable === void 0 ? void 0 : relatedTable.base_id) || context.base_id }));
    }
    else {
        lookupColumn = (await (0, getColumns_1.getColumns)((0, getContextFromObject_1.getContextFromObject)(relatedTable), {
            model: relatedTable,
        })).find((col) => col.id === colOptions.fk_lookup_column_id);
    }
    return {
        relatedTable,
        relationColumn,
        lookupColumn,
    };
};
exports.getLookupRelatedInfo = getLookupRelatedInfo;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0TG9va3VwUmVsYXRlZEluZm8uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL3VuaWZpZWRNZXRhL2dldExvb2t1cFJlbGF0ZWRJbmZvLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLCtEQUE0RDtBQUM1RCxpRUFBOEQ7QUFDOUQsbURBQWdEO0FBQ2hELDZDQUEwQztBQUVuQyxNQUFNLG9CQUFvQixHQUFHLEtBQUssRUFDdkMsT0FBa0IsRUFDbEIsRUFDRSxVQUFVLEVBQ1YsT0FBTyxFQUNQLE9BQU8sR0FLUixFQUNELEVBQUU7O0lBQ0YsSUFBSSxjQUF1QyxDQUFDO0lBQzVDLGNBQWMsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUMzQixDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsR0FBRyxDQUFDLEVBQUUsS0FBSyxVQUFVLENBQUMscUJBQXFCLENBQ3JELENBQUM7SUFDRixJQUFJLENBQUMsY0FBYyxJQUFJLG1CQUFtQixJQUFJLFVBQVUsRUFBRSxDQUFDO1FBQ3pELGNBQWMsR0FBRyxNQUFNLFVBQVUsQ0FBQyxpQkFBaUIsaUNBQzlDLE9BQU8sS0FDVixPQUFPLEVBQUUsQ0FBQSxNQUFBLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRyxDQUFDLENBQUMsMENBQUUsT0FBTyxLQUFJLE9BQU8sQ0FBQyxPQUFPLElBQ2pELENBQUM7SUFDTCxDQUFDO0lBRUQsTUFBTSxZQUFZLEdBQUcsTUFBTSxJQUFBLHlDQUFtQixFQUM1QyxJQUFBLDJDQUFvQixFQUFDLGNBQWMsQ0FBQyxFQUNwQztRQUNFLFVBQVUsRUFDUixNQUFNLElBQUEsNkJBQWEsRUFDakIsSUFBQSwyQ0FBb0IsRUFBQyxjQUFjLENBQUMsRUFDcEM7WUFDRSxNQUFNLEVBQUUsY0FBYztTQUN2QixDQUNGO1FBQ0gsT0FBTztLQUNSLENBQ0YsQ0FBQztJQUNGLElBQUksWUFBcUMsQ0FBQztJQUMxQyxJQUFJLGlCQUFpQixJQUFJLFVBQVUsRUFBRSxDQUFDO1FBQ3BDLFlBQVksR0FBRyxNQUFNLFVBQVUsQ0FBQyxlQUFlLGlDQUMxQyxPQUFPLEtBQ1YsT0FBTyxFQUFFLENBQUEsWUFBWSxhQUFaLFlBQVksdUJBQVosWUFBWSxDQUFFLE9BQU8sS0FBSSxPQUFPLENBQUMsT0FBTyxJQUNqRCxDQUFDO0lBQ0wsQ0FBQztTQUFNLENBQUM7UUFDTixZQUFZLEdBQUcsQ0FDYixNQUFNLElBQUEsdUJBQVUsRUFBQyxJQUFBLDJDQUFvQixFQUFDLFlBQVksQ0FBQyxFQUFFO1lBQ25ELEtBQUssRUFBRSxZQUFZO1NBQ3BCLENBQUMsQ0FDSCxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsR0FBRyxDQUFDLEVBQUUsS0FBSyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBRUQsT0FBTztRQUNMLFlBQVk7UUFDWixjQUFjO1FBQ2QsWUFBWTtLQUNiLENBQUM7QUFDSixDQUFDLENBQUM7QUF2RFcsUUFBQSxvQkFBb0Isd0JBdUQvQiJ9