"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRollupColumn = void 0;
const getColOptions_1 = require("./getColOptions");
const getColumns_1 = require("./getColumns");
const getLTARRelatedTable_1 = require("./getLTARRelatedTable");
const getRollupColumn = async (context, { column, columns, getMeta, }) => {
    const colOptions = await (0, getColOptions_1.getColOptions)(context, { column });
    if ('getRollupColumn' in colOptions) {
        return await colOptions.getRollupColumn(context);
    }
    else {
        const relationColumn = columns.find((col) => col.id ===
            colOptions.fk_relation_column_id);
        if (!relationColumn) {
            // TODO: better error type
            throw new Error(`Relation column not found on column ${column.title}(${column.id})`);
        }
        const relationColOptions = await (0, getColOptions_1.getColOptions)(context, {
            column: relationColumn,
        });
        const relatedTable = await (0, getLTARRelatedTable_1.getLTARRelatedTable)(context, {
            colOptions: relationColOptions,
            getMeta,
        });
        const relatedTableColumns = await (0, getColumns_1.getColumns)(context, {
            model: relatedTable,
        });
        // TODO: possibly throw when column not found on relatedTableColumns
        return relatedTableColumns.find((col) => col.id ===
            colOptions.fk_rollup_column_id);
    }
};
exports.getRollupColumn = getRollupColumn;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0Um9sbHVwQ29sdW1uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2xpYi91bmlmaWVkTWV0YS9nZXRSb2xsdXBDb2x1bW4udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUEsbURBQWdEO0FBQ2hELDZDQUEwQztBQUMxQywrREFBNEQ7QUFFckQsTUFBTSxlQUFlLEdBQUcsS0FBSyxFQUNsQyxPQUFrQixFQUNsQixFQUNFLE1BQU0sRUFDTixPQUFPLEVBQ1AsT0FBTyxHQUtSLEVBQ2lDLEVBQUU7SUFDcEMsTUFBTSxVQUFVLEdBQUcsTUFBTSxJQUFBLDZCQUFhLEVBQ3BDLE9BQU8sRUFDUCxFQUFFLE1BQU0sRUFBRSxDQUNYLENBQUM7SUFDRixJQUFJLGlCQUFpQixJQUFJLFVBQVUsRUFBRSxDQUFDO1FBQ3BDLE9BQU8sTUFBTSxVQUFVLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ25ELENBQUM7U0FBTSxDQUFDO1FBQ04sTUFBTSxjQUFjLEdBQUcsT0FBTyxDQUFDLElBQUksQ0FDakMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUNOLEdBQUcsQ0FBQyxFQUFFO1lBQ0wsVUFBNEMsQ0FBQyxxQkFBcUIsQ0FDdEUsQ0FBQztRQUNGLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztZQUNwQiwwQkFBMEI7WUFDMUIsTUFBTSxJQUFJLEtBQUssQ0FDYix1Q0FBdUMsTUFBTSxDQUFDLEtBQUssSUFBSSxNQUFNLENBQUMsRUFBRSxHQUFHLENBQ3BFLENBQUM7UUFDSixDQUFDO1FBQ0QsTUFBTSxrQkFBa0IsR0FDdEIsTUFBTSxJQUFBLDZCQUFhLEVBQTZDLE9BQU8sRUFBRTtZQUN2RSxNQUFNLEVBQUUsY0FBYztTQUN2QixDQUFDLENBQUM7UUFFTCxNQUFNLFlBQVksR0FBRyxNQUFNLElBQUEseUNBQW1CLEVBQUMsT0FBTyxFQUFFO1lBQ3RELFVBQVUsRUFBRSxrQkFBa0I7WUFDOUIsT0FBTztTQUNSLENBQUMsQ0FBQztRQUNILE1BQU0sbUJBQW1CLEdBQUcsTUFBTSxJQUFBLHVCQUFVLEVBQUMsT0FBTyxFQUFFO1lBQ3BELEtBQUssRUFBRSxZQUFZO1NBQ3BCLENBQUMsQ0FBQztRQUNILG9FQUFvRTtRQUNwRSxPQUFPLG1CQUFtQixDQUFDLElBQUksQ0FDN0IsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUNOLEdBQUcsQ0FBQyxFQUFFO1lBQ0wsVUFBNEMsQ0FBQyxtQkFBbUIsQ0FDcEUsQ0FBQztJQUNKLENBQUM7QUFDSCxDQUFDLENBQUM7QUFqRFcsUUFBQSxlQUFlLG1CQWlEMUIifQ==