"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UNIQUE_CONSTRAINT_SUPPORTED_TYPES = void 0;
exports.isUniqueConstraintSupportedType = isUniqueConstraintSupportedType;
const _1 = require("./");
/**
 * Field types that support unique constraints
 */
exports.UNIQUE_CONSTRAINT_SUPPORTED_TYPES = [
    _1.UITypes.SingleLineText,
    _1.UITypes.Email,
    _1.UITypes.PhoneNumber,
    _1.UITypes.URL,
    _1.UITypes.Number,
    _1.UITypes.Decimal,
    _1.UITypes.Currency,
    _1.UITypes.Percent,
    _1.UITypes.Date,
    _1.UITypes.DateTime,
    _1.UITypes.Time,
];
/**
 * Validates if a field type supports unique constraints
 * @param uidt - UI data type
 * @param meta - Column metadata (for rich text check)
 * @returns true if the field type supports unique constraints
 */
function isUniqueConstraintSupportedType(uidt, meta) {
    // Check for LongText with rich text enabled (not supported)
    if (uidt === _1.UITypes.LongText && (meta === null || meta === void 0 ? void 0 : meta.richMode)) {
        return false;
    }
    return exports.UNIQUE_CONSTRAINT_SUPPORTED_TYPES.includes(uidt);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidW5pcXVlQ29uc3RyYWludEhlbHBlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL3VuaXF1ZUNvbnN0cmFpbnRIZWxwZXJzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQXlCQSwwRUFVQztBQW5DRCx5QkFBNkI7QUFFN0I7O0dBRUc7QUFDVSxRQUFBLGlDQUFpQyxHQUFHO0lBQy9DLFVBQU8sQ0FBQyxjQUFjO0lBQ3RCLFVBQU8sQ0FBQyxLQUFLO0lBQ2IsVUFBTyxDQUFDLFdBQVc7SUFDbkIsVUFBTyxDQUFDLEdBQUc7SUFDWCxVQUFPLENBQUMsTUFBTTtJQUNkLFVBQU8sQ0FBQyxPQUFPO0lBQ2YsVUFBTyxDQUFDLFFBQVE7SUFDaEIsVUFBTyxDQUFDLE9BQU87SUFDZixVQUFPLENBQUMsSUFBSTtJQUNaLFVBQU8sQ0FBQyxRQUFRO0lBQ2hCLFVBQU8sQ0FBQyxJQUFJO0NBQ2IsQ0FBQztBQUVGOzs7OztHQUtHO0FBQ0gsU0FBZ0IsK0JBQStCLENBQzdDLElBQWEsRUFDYixJQUFVO0lBRVYsNERBQTREO0lBQzVELElBQUksSUFBSSxLQUFLLFVBQU8sQ0FBQyxRQUFRLEtBQUksSUFBSSxhQUFKLElBQUksdUJBQUosSUFBSSxDQUFFLFFBQVEsQ0FBQSxFQUFFLENBQUM7UUFDaEQsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDO0lBRUQsT0FBTyx5Q0FBaUMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDMUQsQ0FBQyJ9