"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.INIT_WORKFLOW_NODES = exports.GENERAL_DEFAULT_NODES = exports.TriggerTestMode = exports.TriggerActivationType = exports.GeneralNodeID = void 0;
exports.isTriggerNode = isTriggerNode;
const stringHelpers_1 = require("../../lib/stringHelpers");
const node_1 = require("./node");
exports.GeneralNodeID = {
    TRIGGER: 'core.trigger',
    PLUS: 'core.plus',
    NOTE: 'note',
};
/**
 * Trigger activation types determine how triggers are managed when workflow is published/unpublished
 */
var TriggerActivationType;
(function (TriggerActivationType) {
    TriggerActivationType["NONE"] = "none";
    TriggerActivationType["WEBHOOK"] = "webhook";
    TriggerActivationType["CRON"] = "cron";
})(TriggerActivationType || (exports.TriggerActivationType = TriggerActivationType = {}));
/**
 * Trigger test modes determine how a trigger can be tested
 * A trigger can support multiple test modes (array)
 */
var TriggerTestMode;
(function (TriggerTestMode) {
    /** Use sample/mock data for testing (default) */
    TriggerTestMode["SAMPLE_DATA"] = "sample_data";
    /** Create temporary webhook URL and wait for real request */
    TriggerTestMode["LISTEN_WEBHOOK"] = "listen_webhook";
    /** User must trigger event on external service (GitHub, Stripe, etc.) */
    TriggerTestMode["TRIGGER_EVENT"] = "trigger_event";
})(TriggerTestMode || (exports.TriggerTestMode = TriggerTestMode = {}));
/**
 * Check if a node is a trigger node
 * Trigger nodes include:
 * - core.trigger (generic trigger placeholder)
 * - nocodb.trigger.* (NocoDB-specific triggers)
 * - *.trigger (external service triggers like github.trigger, gitlab.trigger)
 */
function isTriggerNode(nodeType) {
    if (!nodeType)
        return false;
    return (nodeType === exports.GeneralNodeID.TRIGGER ||
        nodeType.startsWith('nocodb.trigger.') ||
        nodeType.includes('.trigger'));
}
exports.GENERAL_DEFAULT_NODES = [
    {
        id: exports.GeneralNodeID.PLUS,
        title: 'Add Action / Condition',
        icon: 'ncPlus',
        description: 'Add a new action or condition to the workflow',
        category: node_1.WorkflowNodeCategory.ACTION,
        hidden: true,
        ports: [],
    },
    {
        id: exports.GeneralNodeID.TRIGGER,
        title: 'Add Trigger',
        icon: 'ncPlus',
        description: 'Start your workflow',
        category: node_1.WorkflowNodeCategory.TRIGGER,
        hidden: true,
        ports: [],
    },
];
const initWorkflowNodes = [
    {
        id: (0, stringHelpers_1.generateRandomUuid)(),
        type: exports.GeneralNodeID.TRIGGER,
        position: { x: 250, y: 50 },
        data: {
            title: 'Trigger',
        },
    },
];
exports.INIT_WORKFLOW_NODES = initWorkflowNodes;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2xpYi93b3JrZmxvdy9jb25zdGFudHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBc0NBLHNDQVFDO0FBOUNELHVEQUF5RDtBQUN6RCxpQ0FBc0U7QUFFekQsUUFBQSxhQUFhLEdBQUc7SUFDM0IsT0FBTyxFQUFFLGNBQWM7SUFDdkIsSUFBSSxFQUFFLFdBQVc7SUFDakIsSUFBSSxFQUFFLE1BQU07Q0FDSixDQUFDO0FBRVg7O0dBRUc7QUFDSCxJQUFZLHFCQUlYO0FBSkQsV0FBWSxxQkFBcUI7SUFDL0Isc0NBQWEsQ0FBQTtJQUNiLDRDQUFtQixDQUFBO0lBQ25CLHNDQUFhLENBQUE7QUFDZixDQUFDLEVBSlcscUJBQXFCLHFDQUFyQixxQkFBcUIsUUFJaEM7QUFFRDs7O0dBR0c7QUFDSCxJQUFZLGVBT1g7QUFQRCxXQUFZLGVBQWU7SUFDekIsaURBQWlEO0lBQ2pELDhDQUEyQixDQUFBO0lBQzNCLDZEQUE2RDtJQUM3RCxvREFBaUMsQ0FBQTtJQUNqQyx5RUFBeUU7SUFDekUsa0RBQStCLENBQUE7QUFDakMsQ0FBQyxFQVBXLGVBQWUsK0JBQWYsZUFBZSxRQU8xQjtBQUVEOzs7Ozs7R0FNRztBQUNILFNBQWdCLGFBQWEsQ0FBQyxRQUE0QjtJQUN4RCxJQUFJLENBQUMsUUFBUTtRQUFFLE9BQU8sS0FBSyxDQUFDO0lBRTVCLE9BQU8sQ0FDTCxRQUFRLEtBQUsscUJBQWEsQ0FBQyxPQUFPO1FBQ2xDLFFBQVEsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDdEMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FDOUIsQ0FBQztBQUNKLENBQUM7QUFFWSxRQUFBLHFCQUFxQixHQUE2QjtJQUM3RDtRQUNFLEVBQUUsRUFBRSxxQkFBYSxDQUFDLElBQUk7UUFDdEIsS0FBSyxFQUFFLHdCQUF3QjtRQUMvQixJQUFJLEVBQUUsUUFBUTtRQUNkLFdBQVcsRUFBRSwrQ0FBK0M7UUFDNUQsUUFBUSxFQUFFLDJCQUFvQixDQUFDLE1BQU07UUFDckMsTUFBTSxFQUFFLElBQUk7UUFDWixLQUFLLEVBQUUsRUFBRTtLQUNWO0lBQ0Q7UUFDRSxFQUFFLEVBQUUscUJBQWEsQ0FBQyxPQUFPO1FBQ3pCLEtBQUssRUFBRSxhQUFhO1FBQ3BCLElBQUksRUFBRSxRQUFRO1FBQ2QsV0FBVyxFQUFFLHFCQUFxQjtRQUNsQyxRQUFRLEVBQUUsMkJBQW9CLENBQUMsT0FBTztRQUN0QyxNQUFNLEVBQUUsSUFBSTtRQUNaLEtBQUssRUFBRSxFQUFFO0tBQ1Y7Q0FDRixDQUFDO0FBRUYsTUFBTSxpQkFBaUIsR0FBRztJQUN4QjtRQUNFLEVBQUUsRUFBRSxJQUFBLGtDQUFrQixHQUFFO1FBQ3hCLElBQUksRUFBRSxxQkFBYSxDQUFDLE9BQU87UUFDM0IsUUFBUSxFQUFFLEVBQUUsQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFO1FBQzNCLElBQUksRUFBRTtZQUNKLEtBQUssRUFBRSxTQUFTO1NBQ2pCO0tBQ0Y7Q0FDRixDQUFDO0FBRVcsUUFBQSxtQkFBbUIsR0FBRyxpQkFBaUIsQ0FBQyJ9