import { arrFlatMap } from './arrayHelpers';
import { NcErrorBase } from './error-handler';
export class CircularRefContext {
    constructor(existing) {
        this.refs = new Map();
        if ((existing === null || existing === void 0 ? void 0 : existing.size) > 0) {
            this.refs = new Map(existing);
        }
    }
    static make(...existingArr) {
        const existingRefs = [];
        for (const existing of existingArr) {
            if (existing &&
                !(existing instanceof CircularRefContext) &&
                !(existing instanceof Map)) {
                continue;
            }
            existingRefs.push(existing instanceof CircularRefContext ? existing.refs : existing);
        }
        // make immutable
        const result = new CircularRefContext(new Map(arrFlatMap(existingRefs.map((k) => [...k]))));
        return result;
    }
    add(ref) {
        if (!ref) {
            return;
        }
        if (this.refs.has(ref.id)) {
            const [_root_id, root] = this.refs.entries().next().value;
            new NcErrorBase().formulaCircularRefError(`Detected circular ref for column '${this.formatRef(ref)}', when evaluate column '${this.formatRef(root)}'`);
        }
        this.refs.set(ref.id, ref);
    }
    cloneAndAdd(ref) {
        const result = CircularRefContext.make(this);
        result.add(ref);
        return result;
    }
    formatRef(ref) {
        return `${ref.table ? ref.table + '.' : ''}${ref.title}`;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ2lyY3VsYXJSZWZDb250ZXh0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2xpYi9DaXJjdWxhclJlZkNvbnRleHQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQzVDLE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxpQkFBaUIsQ0FBQztBQVM5QyxNQUFNLE9BQU8sa0JBQWtCO0lBQzdCLFlBQW9CLFFBQTZCO1FBTWpELFNBQUksR0FBdUIsSUFBSSxHQUFHLEVBQTJCLENBQUM7UUFMNUQsSUFBSSxDQUFBLFFBQVEsYUFBUixRQUFRLHVCQUFSLFFBQVEsQ0FBRSxJQUFJLElBQUcsQ0FBQyxFQUFFLENBQUM7WUFDdkIsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsQ0FBMEIsUUFBUSxDQUFDLENBQUM7UUFDekQsQ0FBQztJQUNILENBQUM7SUFHRCxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsV0FBd0Q7UUFDckUsTUFBTSxZQUFZLEdBQXlCLEVBQUUsQ0FBQztRQUM5QyxLQUFLLE1BQU0sUUFBUSxJQUFJLFdBQVcsRUFBRSxDQUFDO1lBQ25DLElBQ0UsUUFBUTtnQkFDUixDQUFDLENBQUMsUUFBUSxZQUFZLGtCQUFrQixDQUFDO2dCQUN6QyxDQUFDLENBQUMsUUFBUSxZQUFZLEdBQUcsQ0FBQyxFQUMxQixDQUFDO2dCQUNELFNBQVM7WUFDWCxDQUFDO1lBQ0QsWUFBWSxDQUFDLElBQUksQ0FDZixRQUFRLFlBQVksa0JBQWtCLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FDbEUsQ0FBQztRQUNKLENBQUM7UUFFRCxpQkFBaUI7UUFDakIsTUFBTSxNQUFNLEdBQUcsSUFBSSxrQkFBa0IsQ0FDbkMsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FDckQsQ0FBQztRQUNGLE9BQU8sTUFBTSxDQUFDO0lBQ2hCLENBQUM7SUFFRCxHQUFHLENBQUMsR0FBb0I7UUFDdEIsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDO1lBQ1QsT0FBTztRQUNULENBQUM7UUFDRCxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDO1lBQzFCLE1BQU0sQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxLQUFLLENBQUM7WUFDMUQsSUFBSSxXQUFXLEVBQUUsQ0FBQyx1QkFBdUIsQ0FDdkMscUNBQXFDLElBQUksQ0FBQyxTQUFTLENBQ2pELEdBQUcsQ0FDSiw0QkFBNEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUNyRCxDQUFDO1FBQ0osQ0FBQztRQUNELElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDN0IsQ0FBQztJQUVELFdBQVcsQ0FBQyxHQUFvQjtRQUM5QixNQUFNLE1BQU0sR0FBRyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDN0MsTUFBTSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNoQixPQUFPLE1BQU0sQ0FBQztJQUNoQixDQUFDO0lBRUQsU0FBUyxDQUFDLEdBQUc7UUFDWCxPQUFPLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLEtBQUssR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7SUFDM0QsQ0FBQztDQUNGIn0=