import { CircularRefContext } from './CircularRefContext';
const cweriu64Ax = {
    id: 'cweriu64Ax',
    title: 'col1',
    table: 'Table1',
};
const cx8sfE9AQz = {
    id: 'cx8sfE9AQz',
    title: 'col2',
    table: 'Table2',
};
const cleJBgyg1N = {
    id: 'cleJBgyg1N',
    title: 'col3',
    table: 'Table3',
};
const cpg4Ym5nl8 = {
    id: 'cpg4Ym5nl8',
    title: 'col4',
    table: 'Table4',
};
describe('CircularRefContext', () => {
    it(`will add refs without triggering circular issue`, () => {
        const refs = [cweriu64Ax, cx8sfE9AQz, cleJBgyg1N];
        const refContext = CircularRefContext.make();
        for (const each of refs) {
            refContext.add(each);
        }
        expect(refContext.refs.size).toBe(3);
    });
    it(`will add refs and triggering circular issue`, () => {
        const refs = [cweriu64Ax, cx8sfE9AQz, cleJBgyg1N, cx8sfE9AQz];
        expect(() => {
            const refContext = CircularRefContext.make();
            for (const each of refs) {
                refContext.add(each);
            }
        }).toThrow(`Detected circular ref for column '${cx8sfE9AQz.table}.${cx8sfE9AQz.title}', when evaluate column '${cweriu64Ax.table}.${cweriu64Ax.title}'`);
    });
    it(`will add refs and triggering circular issue when continuing refs`, () => {
        const refs = [cweriu64Ax, cx8sfE9AQz, cleJBgyg1N];
        const refs2 = [cpg4Ym5nl8, cx8sfE9AQz];
        expect(() => {
            const refContext = CircularRefContext.make();
            for (const each of refs) {
                refContext.add(each);
            }
            const refContext2 = CircularRefContext.make(refContext);
            for (const each of refs2) {
                refContext2.add(each);
            }
        }).toThrow(`Detected circular ref for column '${cx8sfE9AQz.table}.${cx8sfE9AQz.title}', when evaluate column '${cweriu64Ax.table}.${cweriu64Ax.title}'`);
    });
});
//# sourceMappingURL=data:application/json;base64,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