import { ColumnReqType, ColumnType, TableType } from './Api';
import { FormulaDataTypes } from './formula/enums';
declare enum UITypes {
    ID = "ID",
    LinkToAnotherRecord = "LinkToAnotherRecord",
    ForeignKey = "ForeignKey",
    Lookup = "Lookup",
    SingleLineText = "SingleLineText",
    LongText = "LongText",
    Attachment = "Attachment",
    Checkbox = "Checkbox",
    MultiSelect = "MultiSelect",
    SingleSelect = "SingleSelect",
    Collaborator = "Collaborator",
    Date = "Date",
    Year = "Year",
    Time = "Time",
    PhoneNumber = "PhoneNumber",
    GeoData = "GeoData",
    Email = "Email",
    URL = "URL",
    Number = "Number",
    Decimal = "Decimal",
    Currency = "Currency",
    Percent = "Percent",
    Duration = "Duration",
    Rating = "Rating",
    Formula = "Formula",
    Rollup = "Rollup",
    Count = "Count",
    DateTime = "DateTime",
    CreatedTime = "CreatedTime",
    LastModifiedTime = "LastModifiedTime",
    AutoNumber = "AutoNumber",
    Geometry = "Geometry",
    JSON = "JSON",
    SpecificDBType = "SpecificDBType",
    Barcode = "Barcode",
    QrCode = "QrCode",
    Button = "Button",
    Links = "Links",
    User = "User",
    CreatedBy = "CreatedBy",
    LastModifiedBy = "LastModifiedBy",
    Order = "Order",
    Meta = "Meta"
}
export declare const UITypesName: {
    ID: string;
    LinkToAnotherRecord: string;
    ForeignKey: string;
    Order: string;
    Lookup: string;
    SingleLineText: string;
    LongText: string;
    RichText: string;
    Attachment: string;
    Checkbox: string;
    MultiSelect: string;
    SingleSelect: string;
    Collaborator: string;
    Date: string;
    Year: string;
    Time: string;
    PhoneNumber: string;
    GeoData: string;
    Email: string;
    URL: string;
    Number: string;
    Decimal: string;
    Currency: string;
    Percent: string;
    Duration: string;
    Rating: string;
    Formula: string;
    Rollup: string;
    Count: string;
    DateTime: string;
    CreatedTime: string;
    LastModifiedTime: string;
    AutoNumber: string;
    Geometry: string;
    JSON: string;
    SpecificDBType: string;
    Barcode: string;
    QrCode: string;
    Button: string;
    Links: string;
    User: string;
    CreatedBy: string;
    LastModifiedBy: string;
    Meta: string;
    AIButton: string;
    AIPrompt: string;
};
export declare const UITypesSearchTerms: {
    ID: string[];
    ForeignKey: string[];
    LinkToAnotherRecord: string[];
    Lookup: string[];
    SingleLineText: string[];
    LongText: string[];
    Attachment: string[];
    Checkbox: string[];
    MultiSelect: string[];
    SingleSelect: string[];
    Collaborator: string[];
    Date: string[];
    Year: string[];
    Time: string[];
    PhoneNumber: string[];
    GeoData: string[];
    Email: string[];
    URL: string[];
    Number: string[];
    Decimal: string[];
    Currency: string[];
    Percent: string[];
    Duration: string[];
    Rating: string[];
    Formula: string[];
    Rollup: string[];
    Count: string[];
    DateTime: string[];
    CreatedTime: string[];
    LastModifiedTime: string[];
    AutoNumber: string[];
    Geometry: string[];
    JSON: string[];
    SpecificDBType: string[];
    Barcode: string[];
    QrCode: string[];
    Button: string[];
    Links: string[];
    User: string[];
    CreatedBy: string[];
    LastModifiedBy: string[];
    AIButton: string[];
    AIPrompt: string[];
};
export declare const columnTypeName: (column?: ColumnType) => any;
export declare const FieldNameFromUITypes: Record<UITypes, string>;
export declare const numericUITypes: UITypes[];
export declare function isNumericCol(col: UITypes | {
    readonly uidt: UITypes | string;
} | ColumnReqType | ColumnType): boolean;
export declare function isVirtualCol(col: UITypes | {
    readonly uidt: UITypes | string;
} | ColumnReqType | ColumnType): boolean;
export declare function isAIPromptCol(col: ColumnReqType | ColumnType): any;
export declare function isCreatedOrLastModifiedTimeCol(col: UITypes | {
    readonly uidt: UITypes | string;
} | ColumnReqType | ColumnType): boolean;
export declare function isCreatedOrLastModifiedByCol(col: UITypes | {
    readonly uidt: UITypes | string;
} | ColumnReqType | ColumnType): boolean;
export declare function isOrderCol(col: UITypes | {
    readonly uidt: UITypes | string;
} | ColumnReqType | ColumnType): boolean;
export declare function isActionButtonCol(col: (ColumnReqType | ColumnType) & {
    colOptions?: any;
}): boolean;
export declare function isHiddenCol(col: (ColumnReqType | ColumnType) & {
    colOptions?: any;
    system?: number | boolean;
}, tableMeta: Partial<TableType>): boolean;
export declare function isLinksOrLTAR(colOrUidt: ColumnType | {
    uidt: UITypes | string;
} | UITypes | string): boolean;
export declare function isSelfLinkCol(col: ColumnType & {
    colOptions: unknown;
}): boolean;
export declare const getEquivalentUIType: ({ formulaColumn, }: {
    formulaColumn: ColumnType;
}) => void | UITypes;
export declare const isSelectTypeCol: (colOrUidt: ColumnType | {
    uidt: UITypes | string;
} | UITypes | string) => boolean;
export declare const isInUIType: <T extends UITypes>(colOrUidt: ColumnType | {
    uidt: UITypes | string;
} | UITypes | string, types: T | readonly T[]) => colOrUidt is (ColumnType & {
    uidt: T;
}) | {
    uidt: T;
} | T;
export default UITypes;
export declare const readonlyMetaAllowedTypes: UITypes[];
export declare const partialUpdateAllowedTypes: UITypes[];
export declare const getUITypesForFormulaDataType: (dataType: FormulaDataTypes) => UITypes[];
export declare const isSupportedDisplayValueColumn: (column: Partial<ColumnType>) => boolean;
export declare const checkboxIconList: {
    checked: string;
    unchecked: string;
    label: string;
}[];
export declare const checkboxIconListMap: Record<string, {
    checked: string;
    unchecked: string;
    label: string;
}>;
export declare const ratingIconList: {
    full: string;
    empty: string;
    label: string;
}[];
export declare const ratingIconListMap: Record<string, {
    full: string;
    empty: string;
    label: string;
}>;
export declare const durationOptions: {
    id: number;
    title: string;
    example: string;
    regex: RegExp;
}[];
/**
 * Checks if a given column is read-only.
 * A column is considered read-only if it belongs to specific UI types
 * (e.g., Lookup, Rollup, Formula, etc.) or if it represents system-generated
 * metadata such as created/modified timestamps or ordering information.
 *
 * @param {ColumnType} column - The column to check.
 * @returns {boolean} - Returns `true` if the column is read-only, otherwise `false`.
 */
export declare const isReadOnlyColumn: (column: ColumnType) => boolean;
/**
 * Determines whether a given column type represents a Date or DateTime field.
 *
 * @param column - The column type to check.
 * @returns `true` if the column is a Date, DateTime, CreatedTime, or LastModifiedTime field;
 *          `true` if it is a Formula column that evaluates to DateTime;
 *          otherwise, `false`.
 */
export declare const isDateOrDateTimeCol: (column: ColumnType) => boolean;
export declare const customLinkSupportedTypes: UITypes[];
export declare const hiddenColumnTypes: UITypes[];
