import type { ColumnType } from '../lib/Api';
import { SerializerOrParserFnProps } from './columnHelper/column.interface';
declare enum NumericalAggregations {
    Sum = "sum",
    Min = "min",
    Max = "max",
    Avg = "avg",
    Median = "median",
    StandardDeviation = "std_dev",
    Range = "range"
}
declare enum CommonAggregations {
    Count = "count",
    CountEmpty = "count_empty",
    CountFilled = "count_filled",
    CountUnique = "count_unique",
    PercentEmpty = "percent_empty",
    PercentFilled = "percent_filled",
    PercentUnique = "percent_unique",
    None = "none"
}
declare enum AttachmentAggregations {
    AttachmentSize = "attachment_size"
}
declare enum BooleanAggregations {
    Checked = "checked",
    Unchecked = "unchecked",
    PercentChecked = "percent_checked",
    PercentUnchecked = "percent_unchecked"
}
declare enum DateAggregations {
    EarliestDate = "earliest_date",
    LatestDate = "latest_date",
    DateRange = "date_range",
    MonthRange = "month_range"
}
declare const AllAggregations: {
    EarliestDate: DateAggregations.EarliestDate;
    LatestDate: DateAggregations.LatestDate;
    DateRange: DateAggregations.DateRange;
    MonthRange: DateAggregations.MonthRange;
    Checked: BooleanAggregations.Checked;
    Unchecked: BooleanAggregations.Unchecked;
    PercentChecked: BooleanAggregations.PercentChecked;
    PercentUnchecked: BooleanAggregations.PercentUnchecked;
    AttachmentSize: AttachmentAggregations.AttachmentSize;
    Sum: NumericalAggregations.Sum;
    Min: NumericalAggregations.Min;
    Max: NumericalAggregations.Max;
    Avg: NumericalAggregations.Avg;
    Median: NumericalAggregations.Median;
    StandardDeviation: NumericalAggregations.StandardDeviation;
    Range: NumericalAggregations.Range;
    Count: CommonAggregations.Count;
    CountEmpty: CommonAggregations.CountEmpty;
    CountFilled: CommonAggregations.CountFilled;
    CountUnique: CommonAggregations.CountUnique;
    PercentEmpty: CommonAggregations.PercentEmpty;
    PercentFilled: CommonAggregations.PercentFilled;
    PercentUnique: CommonAggregations.PercentUnique;
    None: CommonAggregations.None;
};
type AggregationValue = (typeof AllAggregations)[keyof typeof AllAggregations];
declare const getAvailableAggregations: (type: string, parsed_tree?: any) => string[];
declare const formatAggregation: (aggregation: any, value: any, column: ColumnType, 
/**
 * If columnHelperParams is provided then it will be used to format the aggregation value
 */
columnHelperParams?: SerializerOrParserFnProps["params"]) => any;
export { getAvailableAggregations, NumericalAggregations, CommonAggregations, BooleanAggregations, DateAggregations, AttachmentAggregations, AllAggregations, formatAggregation, AggregationValue, };
