import { arrDetailedDiff, arrFlattenChildren, arrIntersection, } from './arrayHelpers';
describe('arrayHelpers', () => {
    describe('arrIntersection', () => {
        it('will intersect 2 array', () => {
            const a = ['a', 'b', 'c'];
            const b = ['c', 'd', 'e'];
            const result = arrIntersection(a, b);
            expect(result).toEqual(['c']);
        });
    });
    describe('arrDetailedDiff', () => {
        it('will detailed diff 2 array', () => {
            const a = ['a', 'b', 'c'];
            const b = ['c', 'd', 'e'];
            const result = arrDetailedDiff(a, b);
            expect(result).toEqual({
                removed: ['a', 'b'],
                intersected: ['c'],
                added: ['d', 'e'],
            });
        });
    });
    describe('arrFlattenChildren', () => {
        it('will flatten children', () => {
            const payload = [
                {
                    name: 'foo',
                    children: [
                        {
                            name: 'bar',
                        },
                        {
                            name: 'baz',
                        },
                    ],
                },
                {
                    name: 'foo2',
                    children: [
                        {
                            name: 'bar2',
                        },
                        {
                            name: 'baz2',
                            children: [
                                {
                                    name: 'buz2',
                                },
                            ],
                        },
                    ],
                },
                {
                    name: 'foo3',
                },
            ];
            const result = arrFlattenChildren({
                payload,
                childHandle: (each) => {
                    return each.children;
                },
            });
            expect(result.map((k) => k.name).join(',')).toBe('foo,bar,baz,foo2,bar2,baz2,buz2,foo3');
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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