var AuditOperationTypes;
(function (AuditOperationTypes) {
    AuditOperationTypes["COMMENT"] = "COMMENT";
    AuditOperationTypes["DATA"] = "DATA";
    AuditOperationTypes["PROJECT"] = "PROJECT";
    AuditOperationTypes["VIRTUAL_RELATION"] = "VIRTUAL_RELATION";
    AuditOperationTypes["RELATION"] = "RELATION";
    AuditOperationTypes["TABLE_VIEW"] = "TABLE_VIEW";
    AuditOperationTypes["TABLE"] = "TABLE";
    AuditOperationTypes["VIEW"] = "VIEW";
    AuditOperationTypes["META"] = "META";
    AuditOperationTypes["TABLE_COLUMN"] = "TABLE_COLUMN";
    AuditOperationTypes["WEBHOOKS"] = "WEBHOOKS";
    AuditOperationTypes["AUTHENTICATION"] = "AUTHENTICATION";
    AuditOperationTypes["ORG_USER"] = "ORG_USER";
})(AuditOperationTypes || (AuditOperationTypes = {}));
var AuditOperationSubTypes;
(function (AuditOperationSubTypes) {
    AuditOperationSubTypes["INSERT"] = "INSERT";
    AuditOperationSubTypes["CREATE"] = "CREATE";
    AuditOperationSubTypes["UPDATE"] = "UPDATE";
    AuditOperationSubTypes["DELETE"] = "DELETE";
    AuditOperationSubTypes["BULK_INSERT"] = "BULK_INSERT";
    AuditOperationSubTypes["BULK_UPDATE"] = "BULK_UPDATE";
    AuditOperationSubTypes["BULK_DELETE"] = "BULK_DELETE";
    AuditOperationSubTypes["LINK_RECORD"] = "LINK_RECORD";
    AuditOperationSubTypes["UNLINK_RECORD"] = "UNLINK_RECORD";
    AuditOperationSubTypes["RENAME"] = "RENAME";
    AuditOperationSubTypes["IMPORT_FROM_ZIP"] = "IMPORT_FROM_ZIP";
    AuditOperationSubTypes["EXPORT_TO_FS"] = "EXPORT_TO_FS";
    AuditOperationSubTypes["EXPORT_TO_ZIP"] = "EXPORT_TO_ZIP";
    AuditOperationSubTypes["SIGNIN"] = "SIGNIN";
    AuditOperationSubTypes["SIGNUP"] = "SIGNUP";
    AuditOperationSubTypes["PASSWORD_RESET"] = "PASSWORD_RESET";
    AuditOperationSubTypes["PASSWORD_FORGOT"] = "PASSWORD_FORGOT";
    AuditOperationSubTypes["PASSWORD_CHANGE"] = "PASSWORD_CHANGE";
    AuditOperationSubTypes["EMAIL_VERIFICATION"] = "EMAIL_VERIFICATION";
    AuditOperationSubTypes["ROLES_MANAGEMENT"] = "ROLES_MANAGEMENT";
    AuditOperationSubTypes["INVITE"] = "INVITE";
    AuditOperationSubTypes["RESEND_INVITE"] = "RESEND_INVITE";
})(AuditOperationSubTypes || (AuditOperationSubTypes = {}));
const auditOperationTypeLabels = {
    [AuditOperationTypes.COMMENT]: 'Comment',
    [AuditOperationTypes.DATA]: 'Data',
    [AuditOperationTypes.PROJECT]: 'Project',
    [AuditOperationTypes.VIRTUAL_RELATION]: 'Virtual Relation',
    [AuditOperationTypes.RELATION]: 'Relation',
    [AuditOperationTypes.TABLE_VIEW]: 'Table View',
    [AuditOperationTypes.TABLE]: 'Table',
    [AuditOperationTypes.VIEW]: 'View',
    [AuditOperationTypes.META]: 'Meta',
    [AuditOperationTypes.WEBHOOKS]: 'Webhooks',
    [AuditOperationTypes.AUTHENTICATION]: 'Authentication',
    [AuditOperationTypes.TABLE_COLUMN]: 'Table Column',
    [AuditOperationTypes.ORG_USER]: 'Org User',
};
const auditOperationSubTypeLabels = {
    [AuditOperationSubTypes.UPDATE]: 'Update',
    [AuditOperationSubTypes.INSERT]: 'Insert',
    [AuditOperationSubTypes.DELETE]: 'Delete',
    [AuditOperationSubTypes.BULK_INSERT]: 'Bulk Insert',
    [AuditOperationSubTypes.BULK_UPDATE]: 'Bulk Update',
    [AuditOperationSubTypes.BULK_DELETE]: 'Bulk Delete',
    [AuditOperationSubTypes.LINK_RECORD]: 'Link Record',
    [AuditOperationSubTypes.UNLINK_RECORD]: 'Unlink Record',
    [AuditOperationSubTypes.CREATE]: 'Create',
    [AuditOperationSubTypes.RENAME]: 'Rename',
    [AuditOperationSubTypes.IMPORT_FROM_ZIP]: 'Import From Zip',
    [AuditOperationSubTypes.EXPORT_TO_FS]: 'Export To FS',
    [AuditOperationSubTypes.EXPORT_TO_ZIP]: 'Export To Zip',
    [AuditOperationSubTypes.SIGNIN]: 'Signin',
    [AuditOperationSubTypes.SIGNUP]: 'Signup',
    [AuditOperationSubTypes.PASSWORD_RESET]: 'Password Reset',
    [AuditOperationSubTypes.PASSWORD_FORGOT]: 'Password Forgot',
    [AuditOperationSubTypes.PASSWORD_CHANGE]: 'Password Change',
    [AuditOperationSubTypes.EMAIL_VERIFICATION]: 'Email Verification',
    [AuditOperationSubTypes.ROLES_MANAGEMENT]: 'Roles Management',
    [AuditOperationSubTypes.INVITE]: 'Invite',
    [AuditOperationSubTypes.RESEND_INVITE]: 'Resend Invite',
};
export { AuditOperationTypes, AuditOperationSubTypes, auditOperationTypeLabels, auditOperationSubTypeLabels, };
//# sourceMappingURL=data:application/json;base64,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