import { RelationTypes, UITypes } from '../../lib';
declare enum AuditV1OperationTypes {
    USER_SIGNUP = "USER_SIGNUP",
    USER_SIGNIN = "USER_SIGNIN",
    USER_INVITE = "USER_INVITE",
    WORKSPACE_USER_INVITE = "WORKSPACE_USER_INVITE",
    WORKSPACE_USER_UPDATE = "WORKSPACE_USER_UPDATE",
    WORKSPACE_USER_DELETE = "WORKSPACE_USER_DELETE",
    WORKSPACE_TEAM_INVITE = "WORKSPACE_TEAM_INVITE",
    WORKSPACE_TEAM_UPDATE = "WORKSPACE_TEAM_UPDATE",
    WORKSPACE_TEAM_DELETE = "WORKSPACE_TEAM_DELETE",
    USER_PASSWORD_CHANGE = "USER_PASSWORD_CHANGE",
    USER_PASSWORD_RESET = "USER_PASSWORD_RESET",
    USER_PASSWORD_FORGOT = "USER_PASSWORD_FORGOT",
    USER_EMAIL_VERIFY = "USER_EMAIL_VERIFY",
    BASE_USER_INVITE = "BASE_USER_INVITE",
    BASE_USER_UPDATE = "BASE_USER_UPDATE",
    BASE_USER_INVITE_RESEND = "BASE_USER_INVITE_RESEND",
    BASE_TEAM_INVITE = "BASE_TEAM_INVITE",
    BASE_TEAM_UPDATE = "BASE_TEAM_UPDATE",
    BASE_TEAM_DELETE = "BASE_TEAM_DELETE",
    TABLE_CREATE = "TABLE_CREATE",
    TABLE_DELETE = "TABLE_DELETE",
    COLUMN_CREATE = "FIELD_CREATE",
    COLUMN_UPDATE = "FIELD_UPDATE",
    COLUMN_DELETE = "FIELD_DELETE",
    COLUMN_RENAME = "FIELD_RENAME",
    ORG_USER_INVITE = "ORG_USER_INVITE",
    ORG_USER_INVITE_RESEND = "ORG_USER_INVITE_RESEND",
    DATA_INSERT = "DATA_INSERT",
    DATA_UPDATE = "DATA_UPDATE",
    DATA_DELETE = "DATA_DELETE",
    DATA_BULK_INSERT = "DATA_BULK_INSERT",
    DATA_BULK_UPDATE = "DATA_BULK_UPDATE",
    DATA_BULK_DELETE = "DATA_BULK_DELETE",
    DATA_BULK_ALL_DELETE = "DATA_BULK_ALL_DELETE",
    DATA_BULK_ALL_UPDATE = "DATA_BULK_ALL_UPDATE",
    DATA_LINK = "DATA_LINK",
    DATA_UNLINK = "DATA_UNLINK",
    WORKSPACE_CREATE = "WORKSPACE_CREATE",
    WORKSPACE_UPDATE = "WORKSPACE_UPDATE",
    WORKSPACE_DELETE = "WORKSPACE_DELETE",
    WORKSPACE_RENAME = "WORKSPACE_RENAME",
    BASE_CREATE = "BASE_CREATE",
    BASE_UPDATE = "BASE_UPDATE",
    BASE_DELETE = "BASE_DELETE",
    BASE_RENAME = "BASE_RENAME",
    VIEW_CREATE = "VIEW_CREATE",
    VIEW_UPDATE = "VIEW_UPDATE",
    VIEW_DELETE = "VIEW_DELETE",
    VIEW_RENAME = "VIEW_RENAME",
    HOOK_CREATE = "HOOK_CREATE",
    HOOK_UPDATE = "HOOK_UPDATE",
    HOOK_DELETE = "HOOK_DELETE",
    HOOK_FILTER_CREATE = "HOOK_FILTER_CREATE",
    HOOK_FILTER_UPDATE = "HOOK_FILTER_UPDATE",
    HOOK_FILTER_DELETE = "HOOK_FILTER_DELETE",
    VIEW_FILTER_CREATE = "VIEW_FILTER_CREATE",
    VIEW_FILTER_UPDATE = "VIEW_FILTER_UPDATE",
    VIEW_FILTER_DELETE = "VIEW_FILTER_DELETE",
    LINK_FILTER_CREATE = "LINK_FILTER_CREATE",
    LINK_FILTER_UPDATE = "LINK_FILTER_UPDATE",
    LINK_FILTER_DELETE = "LINK_FILTER_DELETE",
    WIDGET_FILTER_CREATE = "WIDGET_FILTER_CREATE",
    WIDGET_FILTER_UPDATE = "WIDGET_FILTER_UPDATE",
    WIDGET_FILTER_DELETE = "WIDGET_FILTER_DELETE",
    VIEW_SORT_CREATE = "VIEW_SORT_CREATE",
    VIEW_SORT_UPDATE = "VIEW_SORT_UPDATE",
    VIEW_SORT_DELETE = "VIEW_SORT_DELETE",
    SHARED_BASE_CREATE = "SHARED_BASE_CREATE",
    SHARED_BASE_DELETE = "SHARED_BASE_DELETE",
    SOURCE_CREATE = "SOURCE_CREATE",
    SOURCE_UPDATE = "SOURCE_UPDATE",
    SOURCE_DELETE = "SOURCE_DELETE",
    SOURCE_RENAME = "SOURCE_RENAME",
    SHARED_VIEW_DELETE = "SHARED_VIEW_DELETE",
    SHARED_VIEW_CREATE = "SHARED_VIEW_CREATE",
    SHARED_VIEW_UPDATE = "SHARED_VIEW_UPDATE",
    API_TOKEN_DELETE = "API_TOKEN_DELETE",
    API_TOKEN_CREATE = "API_TOKEN_CREATE",
    BASE_DUPLICATE = "BASE_DUPLICATE",
    BASE_DUPLICATE_ERROR = "BASE_DUPLICATE_ERROR",
    TABLE_DUPLICATE = "TABLE_DUPLICATE",
    TABLE_DUPLICATE_ERROR = "TABLE_DUPLICATE_ERROR",
    COLUMN_DUPLICATE = "FIELD_DUPLICATE",
    COLUMN_DUPLICATE_ERROR = "FIELD_DUPLICATE_ERROR",
    VIEW_DUPLICATE = "VIEW_DUPLICATE",
    VIEW_DUPLICATE_ERROR = "VIEW_DUPLICATE_ERROR",
    FORM_COLUMN_UPDATE = "FORM_FIELD_UPDATE",
    USER_SIGNOUT = "USER_SIGNOUT",
    TABLE_UPDATE = "TABLE_UPDATE",
    TABLE_RENAME = "TABLE_RENAME",
    VIEW_COLUMN_UPDATE = "VIEW_FIELD_UPDATE",
    UI_ACL = "UI_ACL",
    AIRTABLE_IMPORT = "AIRTABLE_IMPORT",
    AIRTABLE_IMPORT_ERROR = "AIRTABLE_IMPORT_ERROR",
    INTEGRATION_CREATE = "INTEGRATION_CREATE",
    INTEGRATION_UPDATE = "INTEGRATION_UPDATE",
    INTEGRATION_DELETE = "INTEGRATION_DELETE",
    SNAPSHOT_DELETE = "SNAPSHOT_DELETE",
    SNAPSHOT_CREATE = "SNAPSHOT_CREATE",
    SNAPSHOT_RESTORE = "SNAPSHOT_RESTORE",
    DATA_IMPORT = "DATA_IMPORT",
    DATA_EXPORT = "DATA_EXPORT",
    USER_PROFILE_UPDATE = "USER_PROFILE_UPDATE",
    SCRIPT_CREATE = "SCRIPT_CREATE",
    SCRIPT_UPDATE = "SCRIPT_UPDATE",
    SCRIPT_DELETE = "SCRIPT_DELETE",
    SCRIPT_DUPLICATE = "SCRIPT_DUPLICATE",
    DASHBOARD_CREATE = "DASHBOARD_CREATE",
    DASHBOARD_UPDATE = "DASHBOARD_UPDATE",
    DASHBOARD_DELETE = "DASHBOARD_DELETE",
    DASHBOARD_DUPLICATE = "DASHBOARD_DUPLICATE",
    DASHBOARD_DUPLICATE_ERROR = "DASHBOARD_DUPLICATE_ERROR",
    SHARED_DASHBOARD_CREATE = "SHARED_DASHBOARD_CREATE",
    SHARED_DASHBOARD_DELETE = "SHARED_DASHBOARD_DELETE",
    SHARED_DASHBOARD_UPDATE = "SHARED_DASHBOARD_UPDATE",
    WIDGET_CREATE = "WIDGET_CREATE",
    WIDGET_UPDATE = "WIDGET_UPDATE",
    WIDGET_DELETE = "WIDGET_DELETE",
    WIDGET_DUPLICATE = "WIDGET_DUPLICATE",
    PERMISSION_CREATE = "PERMISSION_CREATE",
    PERMISSION_UPDATE = "PERMISSION_UPDATE",
    PERMISSION_DELETE = "PERMISSION_DELETE",
    TEAM_CREATE = "TEAM_CREATE",
    TEAM_UPDATE = "TEAM_UPDATE",
    TEAM_DELETE = "TEAM_DELETE",
    TEAM_MEMBER_ADD = "TEAM_MEMBER_ADD",
    TEAM_MEMBER_UPDATE = "TEAM_MEMBER_UPDATE",
    TEAM_MEMBER_DELETE = "TEAM_MEMBER_DELETE",
    WORKFLOW_CREATE = "WORKFLOW_CREATE",
    WORKFLOW_UPDATE = "WORKFLOW_UPDATE",
    WORKFLOW_DELETE = "WORKFLOW_DELETE",
    WORKFLOW_DUPLICATE = "WORKFLOW_DUPLICATE"
}
export declare const auditV1OperationTypesAlias: Record<string, string>;
/**
 * For audit logs table filter usecase only
 */
export interface AuditV1OperationsCategoryItemType {
    label: string;
    value: string;
    types: Array<AuditV1OperationTypes>;
}
/**
 * For audit logs table filter usecase only
 */
export declare const auditV1OperationsCategory: Record<string, AuditV1OperationsCategoryItemType>;
export type BulkAuditV1OperationTypes = AuditV1OperationTypes.DATA_BULK_INSERT | AuditV1OperationTypes.DATA_BULK_UPDATE | AuditV1OperationTypes.DATA_BULK_DELETE;
export interface UserSigninPayload {
}
export interface UserSignupPayload {
}
export interface UserInvitePayload {
    user_id: string;
    user_email: string;
    user_name?: string;
}
export interface UserPasswordChangePayload {
}
export interface UserPasswordResetPayload {
}
export interface UserPasswordForgotPayload {
}
export interface UserEmailVerifyPayload {
}
export interface BaseUserInvitePayload {
    user_email: string;
    user_id: string;
    base_role: string;
    user_name?: string;
    base_title: string;
}
export interface BaseUserDeletePayload {
    user_email: string;
    user_id: string;
    user_role: string;
    user_name?: string;
    base_title: string;
}
export interface BaseUserInviteResendPayload {
    user_id: string;
    user_email: string;
    base_role: string;
    user_name?: string;
    base_title: string;
}
export interface BaseUserRoleUpdatePayload extends UpdatePayload {
    user_id: string;
    user_email: string;
    base_role: string;
    user_name?: string;
    base_title: string;
}
export interface BaseTeamInvitePayload {
    base_title: string;
    team_id: string;
    team_title: string;
    team_role: string;
}
export interface BaseTeamUpdatePayload extends UpdatePayload {
    base_title: string;
    team_id: string;
    team_title: string;
    team_role: string;
}
export interface BaseTeamDeletePayload {
    base_title: string;
    team_id: string;
    team_title: string;
    team_role: string;
}
export interface UserProfileUpdatePayload extends UpdatePayload {
    user_id: string;
    user_email: string;
}
export interface TableCreatePayload {
    table_title: string;
}
export interface TableDeletePayload {
    table_title: string;
}
export interface ColumnCreatePayload {
    field_id: string;
    field_title: string;
    field_type: UITypes;
    required?: boolean;
    options?: any;
}
export interface ColumnUpdatePayload extends UpdatePayload {
    field_id: string;
    field_title: string;
    options?: any;
}
export interface ColumnRenamePayload {
    field_id: string;
    old_field_title: string;
    new_field_title: string;
}
export interface ViewColumnUpdatePayload extends UpdatePayload {
    view_type: string;
    field_id: string;
    view_id: string;
    view_title: string;
    field_title: string;
    show: boolean;
    system: boolean;
}
export interface ColumnDeletePayload {
    field_id: string;
    field_title: string;
    field_type: UITypes;
    required?: boolean;
    options?: any;
}
export interface OrgUserInvitePayload {
    fk_user_id: string;
    email: string;
    role: string;
}
export interface OrgUserInviteResendPayload {
    fk_user_id: string;
    email: string;
}
export interface DataInsertPayload {
    data: any;
    column_meta: Record<string, ColumnMeta>;
}
export interface DataUpdatePayload {
    old_data: any;
    data: any;
    column_meta: Record<string, ColumnMeta>;
}
export interface DataDeletePayload {
    data: any;
    column_meta: Record<string, ColumnMeta>;
}
export type ColumnMeta = Record<string, unknown>;
export interface DataBulkInsertPayload {
}
export interface DataBulkInsertPayloadRecord {
}
export interface DataBulkUpdatePayload {
}
export interface DataBulkDeletePayload {
}
export interface DataBulkDeletePayloadRecord {
    data: Record<string, unknown>;
    column_meta: Record<string, ColumnMeta>;
}
export interface DataLinkPayload {
    table_title: string;
    ref_table_title: string;
    link_field_title: string;
    link_field_id: string;
    row_id: unknown;
    ref_row_id: unknown;
    display_value: unknown;
    ref_display_value: unknown;
    type: RelationTypes;
}
export interface DataUnlinkPayload {
    table_title: string;
    ref_table_title: string;
    link_field_title: string;
    link_field_id: string;
    row_id: unknown;
    ref_row_id: unknown;
    display_value: unknown;
    ref_display_value: unknown;
    type: RelationTypes;
}
export interface UpdatePayload {
    modifications?: Record<string, unknown>;
    previous_state: Record<string, unknown>;
    [key: string]: unknown;
}
export interface UpdateDestructedPayload {
    [key: string]: unknown;
    previous_state: Record<string, unknown>;
}
export interface WorkspaceCreatePayload {
    workspace_title: string;
}
export interface WorkspaceUpdatePayload extends UpdatePayload {
    workspace_title: string;
}
export interface ViewFieldUpdatePayload extends UpdatePayload {
    view_title: string;
}
export interface WorkspaceDeletePayload {
    workspace_title: string;
}
export interface WorkspaceRenamePayload {
    new_workspace_title: string;
    old_workspace_title: string;
}
export interface WorkspaceDuplicatePayload {
    duplicated_workspace_title: string;
    source_workspace_title: string;
}
export interface BaseCreatePayload {
    base_title: string;
}
export interface BaseUpdatePayload extends UpdatePayload {
    base_title: string;
}
export interface BaseDeletePayload {
    base_title: string;
}
export interface BaseRenamePayload {
    new_base_title: string;
    old_base_title: string;
    error?: string;
}
export interface TableRenamePayload {
    new_table_title: string;
    old_table_title: string;
    error?: string;
}
export interface WorkspaceInvitePayload {
    workspace_title: string;
    user_email: string;
    user_name?: string;
    user_id: string;
    user_role: string;
}
export interface WorkspaceUserUpdatePayload extends UpdatePayload {
    workspace_title: string;
    user_email: string;
    user_name?: string;
    user_role: string;
    user_id: string;
}
export interface WorkspaceUserDeletePayload {
    workspace_title: string;
    user_email: string;
    user_name?: string;
    user_id: string;
    user_role: string;
}
export interface WorkspaceTeamInvitePayload {
    workspace_title: string;
    team_id: string;
    team_title: string;
    team_role: string;
}
export interface WorkspaceTeamUpdatePayload extends UpdatePayload {
    workspace_title: string;
    team_id: string;
    team_title: string;
    team_role: string;
}
export interface WorkspaceTeamDeletePayload {
    workspace_title: string;
    team_id: string;
    team_title: string;
    team_role: string;
}
export interface BaseDuplicatePayload {
    duplicated_base_title: string;
    duplicated_base_id: string;
    source_base_title?: string;
    source_base_id?: string;
    error?: string;
    options?: unknown;
}
export interface ColumnDuplicatePayload {
    source_field_title: string;
    source_field_id: string;
    duplicated_field_title?: string;
    duplicated_field_id?: string;
    error?: string;
    options?: unknown;
}
export interface TableDuplicatePayload {
    source_table_title: string;
    source_table_id: string;
    duplicated_table_title?: string;
    duplicated_table_id?: string;
    error?: string;
    options: unknown;
}
export interface ViewCreatePayload {
    view_title: string;
    view_id: string;
    view_type: string;
    view_owner_id: string;
    view_owner_email: string;
}
export interface SharedViewCreatePayload {
    view_title: string;
    view_id: string;
    view_type: string;
}
export interface TableUpdatePayload extends UpdatePayload {
    table_title: string;
}
export interface ViewUpdatePayload extends UpdatePayload {
    view_title: string;
    view_id: string;
    view_type: string;
    view_owner_id: string;
    view_owner_email: string;
}
export interface SharedViewUpdatePayload extends UpdatePayload {
    view_title: string;
    view_id: string;
    view_type: string;
}
export interface ViewDeletePayload {
    view_title: string;
    view_id: string;
    view_type: string;
    view_owner_id: string;
    view_owner_email: string;
}
export interface SharedViewDeletePayload {
    view_title: string;
    view_id: string;
    view_type: string;
}
export interface ViewRenamePayload {
    new_view_title: string;
    old_view_title: string;
    view_id: string;
    view_type: string;
}
export interface ViewDuplicatePayload {
    duplicated_view_title: string;
    duplicated_view_id: string;
    source_view_title: string;
    source_view_id: string;
    view_type: string;
    error?: string;
}
export interface ModelRoleVisibilityPayload {
    view_title: string;
    view_id: string;
    role: string;
    disabled: boolean;
}
export interface SharedViewCreatePayload {
    view_title: string;
    view_id: string;
}
export interface SharedViewUpdatePayload extends UpdatePayload {
    view_title: string;
    view_id: string;
}
export interface SharedViewDeletePayload {
    view_title: string;
    view_id: string;
}
export interface HookCreatePayload {
    hook_id: string;
    hook_title: string;
}
export interface HookUpdatePayload extends UpdatePayload {
    hook_id: string;
    hook_title: string;
}
export interface HookDeletePayload {
    hook_id: string;
    hook_title: string;
}
export type FilterPayload = {
    view_title: string;
    view_id: string;
    view_type: string;
} | {
    hook_title: string;
    hook_id: string;
} | {
    link_field_title: string;
    link_field_id: string;
} | {
    widget_title: string;
    widget_id: string;
};
export type FilterCreatePayload = FilterPayload & {
    filter_id: string;
    filter_field_id?: string;
    filter_comparison_op?: string;
    filter_field_title?: string;
    is_group?: boolean;
    logical_operator?: string;
};
export type FilterUpdatePayload = UpdatePayload & FilterPayload & {
    filter_id: string;
    filter_field_id?: string;
    filter_comparison_op?: string;
    filter_field_title?: string;
    is_group?: boolean;
    logical_operator?: string;
};
export type FilterDeletePayload = FilterPayload & {
    filter_id: string;
    filter_field_id: string;
    filter_field_title: string;
};
export interface DataBulkAllPayload {
    conditions: any[];
    column_meta?: Record<string, ColumnMeta>;
}
export interface DataBulkUpdateAllPayload extends DataBulkAllPayload {
    data: Record<string, unknown>;
    old_data: Record<string, unknown>;
    column_meta: Record<string, ColumnMeta>;
}
export interface DataBulkDeleteAllPayload extends DataBulkAllPayload {
}
export interface SortCreatePayload {
    sort_field_id: string;
    sort_field_title: string;
    view_id: string;
    view_title: string;
    sort_id: string;
}
export interface SortUpdatePayload extends UpdatePayload {
    sort_field_id: string;
    sort_field_title: string;
    view_id: string;
    view_title: string;
    sort_id: string;
}
export interface SortDeletePayload {
    sort_id: string;
    sort_field_id: string;
    sort_field_title: string;
    view_id: string;
    view_title: string;
}
export interface FieldCreatePayload {
    field_title: string;
    op: string;
    filter_id: string;
}
export interface FieldUpdatePayload {
    field_title: string;
    updated_properties: any;
    filter_id: string;
}
export interface FieldDeletePayload {
    field_title: string;
}
export interface APITokenCreatePayload {
    token_id: string;
    token_title: string;
}
export interface APITokenDeletePayload {
    token_id: string;
    token_title: string;
}
export interface SharedBasePayload {
    base_title: string;
    uuid: string;
    custom_url_id?: string;
    custom_url?: string;
}
export interface SharedBasePayloadType {
    base_title: string;
}
export interface SourceCreatePayload {
    source_title: string;
    source_id: string;
    source_integration_id: string;
    source_integration_title: string;
    is_data_readonly: boolean;
    is_schema_readonly: boolean;
}
export interface SourceUpdatePayload extends UpdatePayload {
    source_title: string;
    source_id: string;
    source_integration_id: string;
    source_integration_title: string;
    is_data_readonly: boolean;
    is_schema_readonly: boolean;
}
export interface SourceDeletePayload {
    source_title: string;
    source_id: string;
    source_integration_id: string;
    source_integration_title: string;
    is_data_readonly: boolean;
    is_schema_readonly: boolean;
}
export interface AirtableImportPayload {
    airtable_sync_id: string;
}
export interface AirtableImportFailPayload {
    airtable_sync_id: string;
    error: string;
}
export interface IntegrationCreatePayload {
    integration_id: string;
    integration_title: string;
    integration_type: string;
}
export interface IntegrationUpdatePayload extends UpdatePayload {
    integration_id: string;
    integration_title: string;
    integration_type: string;
}
export interface IntegrationDeletePayload {
    integration_id: string;
    integration_title: string;
    integration_type: string;
}
export interface SnapshotPayload {
    snapshot_title: string;
    snapshot_id: string;
    base_title: string;
    snapshot_base_id: string;
}
export interface SnapshotRestorePayload {
    snapshot_title: string;
    snapshot_id: string;
    base_title: string;
    target_base_id: string;
    target_base_title: string;
    snapshot_base_id: string;
}
export interface DataExportPayload {
    view_id: string;
    view_title: string;
    table_id: string;
    table_title: string;
    export_type: 'excel' | 'csv';
}
export interface DataImportPayload {
    view_id: string;
    view_title: string;
    table_id: string;
    table_title: string;
    import_type: 'excel' | 'csv';
}
export interface ScriptCreatePayload {
    script_title: string;
    script_id: string;
    script_content: string;
    script_description: string;
    script_config: string;
}
export interface ScriptUpdatePayload extends UpdatePayload {
    script_title: string;
    script_id: string;
}
export interface ScriptDeletePayload {
    script_title: string;
    script_id: string;
}
export interface ScriptDuplicatePayload {
    duplicated_script_title: string;
    duplicated_script_id: string;
    source_script_title: string;
    source_script_id: string;
    error?: string;
}
export interface DashboardCreatePayload {
    dashboard_title: string;
    dashboard_id: string;
    dashboard_description: string;
}
export interface DashboardUpdatePayload extends UpdatePayload {
    dashboard_title: string;
    dashboard_id: string;
    dashboard_description: string;
}
export interface DashboardDeletePayload {
    dashboard_title: string;
    dashboard_id: string;
}
export interface DashboardDuplicatePayload {
    duplicated_dashboard_title: string;
    duplicated_dashboard_id: string;
    source_dashboard_title: string;
    source_dashboard_id: string;
    error?: string;
}
export interface SharedDashboardCreatePayload {
    dashboard_title: string;
    dashboard_id: string;
}
export interface SharedDashboardUpdatePayload extends UpdatePayload {
    dashboard_title: string;
    dashboard_id: string;
}
export interface SharedDashboardDeletePayload {
    dashboard_title: string;
    dashboard_id: string;
}
export interface WidgetCreatePayload {
    widget_title: string;
    widget_id: string;
    widget_type: string;
    widget_description: string;
    widget_config: Record<string, any>;
}
export interface WidgetUpdatePayload extends UpdatePayload {
    widget_title: string;
    widget_id: string;
    widget_type: string;
}
export interface WidgetDeletePayload {
    widget_title: string;
    widget_id: string;
    widget_type: string;
}
export interface WidgetDuplicatePayload {
    duplicated_widget_title: string;
    duplicated_widget_id: string;
    source_widget_title: string;
    source_widget_id: string;
    error?: string;
}
export interface PermissionCreatePayload {
    permission_id: string;
    permission: string;
    entity: string;
    entity_id: string;
    granted_type?: string;
    granted_role?: string;
    enforce_for_form?: boolean;
    enforce_for_automation?: boolean;
    subjects?: Array<{
        type: 'user' | 'team';
        id: string;
    }>;
}
export interface PermissionUpdatePayload {
    permission_id: string;
    permission: string;
    entity: string;
    entity_id: string;
    granted_type?: string;
    granted_role?: string;
    enforce_for_form?: boolean;
    enforce_for_automation?: boolean;
    subjects?: Array<{
        type: 'user' | 'team';
        id: string;
    }>;
}
export interface PermissionDeletePayload {
    permission_id: string;
    permission: string;
    entity: string;
    entity_id: string;
}
export interface TeamCreatePayload {
    team_id: string;
    team_title: string;
    workspace_title?: string;
    base_title?: string;
    meta?: any;
}
export interface TeamUpdatePayload extends UpdatePayload {
    team_id: string;
    team_title: string;
    workspace_title?: string;
    base_title?: string;
    meta?: any;
}
export interface TeamDeletePayload {
    team_id: string;
    team_title: string;
    workspace_title?: string;
    base_title?: string;
    meta?: any;
}
export interface TeamMemberAddPayload {
    team_id: string;
    team_title: string;
    user_id: string;
    user_email: string;
    user_name?: string;
    team_role: string;
    workspace_title?: string;
    base_title?: string;
}
export interface TeamMemberUpdatePayload extends UpdatePayload {
    team_id: string;
    team_title: string;
    user_id: string;
    user_email: string;
    user_name?: string;
    team_role: string;
    workspace_title?: string;
    base_title?: string;
}
export interface TeamMemberDeletePayload {
    team_id: string;
    team_title: string;
    user_id: string;
    user_email: string;
    user_name?: string;
    team_role: string;
    workspace_title?: string;
    base_title?: string;
}
export interface WorkflowCreatePayload {
    workflow_title: string;
    workflow_id: string;
    workflow_description: string;
}
export interface WorkflowUpdatePayload extends UpdatePayload {
    workflow_title: string;
    workflow_id: string;
    workflow_description: string;
}
export interface WorkflowDeletePayload {
    workflow_title: string;
    workflow_id: string;
}
export interface WorkflowDuplicatePayload {
    duplicated_workflow_title: string;
    duplicated_workflow_id: string;
    source_workflow_title: string;
    source_workflow_id: string;
    error?: string;
}
export interface AuditV1<T = any> {
    id?: string;
    created_at?: string;
    updated_at?: string;
    user: string;
    ip: string;
    fk_user_id: string;
    user_agent: string;
    fk_workspace_id: string | null;
    base_id: string | null;
    source_id: string | null;
    fk_model_id: string | null;
    row_id: string | null;
    op_type: AuditV1OperationTypes;
    details: T;
    version: 1;
    fk_parent_id?: string;
}
declare function auditDescription(audit: AuditV1): any;
export { AuditV1OperationTypes, auditDescription };
