import { getTrueCircularReplacer } from './circularReplacer';
describe('CircularReplacer', () => {
    it(`will stringify objects normally`, () => {
        const obj1 = {
            foo: 'foo',
            bar: 'bar',
            baz: 'baz',
        };
        const obj2 = {
            foo2: 'foo2',
            bar2: 'bar2',
            baz2: 'baz2',
        };
        const obj3 = {
            foo3: 'foo3',
            bar3: 'bar3',
            baz3: 'baz3',
        };
        const objToStringify = Object.assign(Object.assign({}, obj1), { obj2: Object.assign(Object.assign({}, obj2), { obj3 }), obj3 });
        const result = JSON.stringify(objToStringify, getTrueCircularReplacer(), 2);
        const expectedResult = [
            `{`,
            `  "foo": "foo",`,
            `  "bar": "bar",`,
            `  "baz": "baz",`,
            `  "obj2": {`,
            `    "foo2": "foo2",`,
            `    "bar2": "bar2",`,
            `    "baz2": "baz2",`,
            `    "obj3": {`,
            `      "foo3": "foo3",`,
            `      "bar3": "bar3",`,
            `      "baz3": "baz3"`,
            `    }`,
            `  },`,
            `  "obj3": {`,
            `    "foo3": "foo3",`,
            `    "bar3": "bar3",`,
            `    "baz3": "baz3"`,
            `  }`,
            `}`,
        ];
        expect(result).toBe(expectedResult.join('\n'));
    });
    it(`will stringify objects normally with circular reference1`, () => {
        const obj1 = {
            foo: 'foo',
            bar: 'bar',
            baz: 'baz',
        };
        const obj2 = {
            foo2: 'foo2',
            bar2: 'bar2',
            baz2: 'baz2',
        };
        const obj3 = {
            foo3: 'foo3',
            bar3: 'bar3',
            baz3: 'baz3',
        };
        obj1.obj2 = obj2;
        obj2.obj1 = obj1;
        obj1.obj1 = obj1;
        const objToStringify = {
            obj1,
            obj3,
        };
        obj3.objToStringify = objToStringify;
        const result = JSON.stringify(objToStringify, getTrueCircularReplacer(), 2);
        const expectedResult = [
            `{`,
            `  "obj1": {`,
            `    "foo": "foo",`,
            `    "bar": "bar",`,
            `    "baz": "baz",`,
            `    "obj2": {`,
            `      "foo2": "foo2",`,
            `      "bar2": "bar2",`,
            `      "baz2": "baz2"`,
            `    }`,
            `  },`,
            `  "obj3": {`,
            `    "foo3": "foo3",`,
            `    "bar3": "bar3",`,
            `    "baz3": "baz3"`,
            `  }`,
            `}`,
        ];
        expect(result).toBe(expectedResult.join('\n'));
    });
    it(`will stringify objects normally with circular reference2`, () => {
        const obj1 = {
            foo: 'foo',
            bar: 'bar',
            baz: 'baz',
        };
        const obj2 = {
            foo2: 'foo2',
            bar2: 'bar2',
            baz2: 'baz2',
        };
        const obj3 = {
            foo3: 'foo3',
            bar3: 'bar3',
            baz3: 'baz3',
        };
        obj1.obj2 = obj2;
        obj2.obj1 = obj1;
        obj1.obj1 = obj1;
        const objToStringify = Object.assign(Object.assign({}, obj1), { obj2: Object.assign(Object.assign({}, obj2), { obj3 }), obj3 });
        obj3.objToStringify = objToStringify;
        const result = JSON.stringify(objToStringify, getTrueCircularReplacer(), 2);
        const expectedResult = [
            `{`,
            `  "foo": "foo",`,
            `  "bar": "bar",`,
            `  "baz": "baz",`,
            `  "obj2": {`,
            `    "foo2": "foo2",`,
            `    "bar2": "bar2",`,
            `    "baz2": "baz2",`,
            `    "obj1": {`,
            `      "foo": "foo",`,
            `      "bar": "bar",`,
            `      "baz": "baz",`,
            `      "obj2": {`,
            `        "foo2": "foo2",`,
            `        "bar2": "bar2",`,
            `        "baz2": "baz2"`,
            `      }`,
            `    },`,
            `    "obj3": {`,
            `      "foo3": "foo3",`,
            `      "bar3": "bar3",`,
            `      "baz3": "baz3"`,
            `    }`,
            `  },`,
            `  "obj1": {`,
            `    "foo": "foo",`,
            `    "bar": "bar",`,
            `    "baz": "baz",`,
            `    "obj2": {`,
            `      "foo2": "foo2",`,
            `      "bar2": "bar2",`,
            `      "baz2": "baz2"`,
            `    }`,
            `  },`,
            `  "obj3": {`,
            `    "foo3": "foo3",`,
            `    "bar3": "bar3",`,
            `    "baz3": "baz3"`,
            `  }`,
            `}`,
        ];
        expect(result).toBe(expectedResult.join('\n'));
    });
});
//# sourceMappingURL=data:application/json;base64,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