import { ncIsString } from '../is';
import UITypes from '../UITypes';
import { AttachmentHelper, BarcodeHelper, ButtonHelper, CheckboxHelper, CreatedTimeHelper, CurrencyHelper, DateHelper, DateTimeHelper, DecimalHelper, DefaultColumnHelper, DurationHelper, EmailHelper, FormulaHelper, GeoDataHelper, JsonHelper, LastModifiedTimeHelper, LinksHelper, LongTextHelper, LookupHelper, LTARHelper, MultiSelectHelper, NumberHelper, PercentHelper, PhoneNumberHelper, QrCodeHelper, RatingHelper, RollupHelper, SingleLineTextHelper, TimeHelper, UrlHelper, UserHelper, YearHelper, } from './columns';
import { SingleSelectHelper } from './columns/SingleSelect';
import { getClipboardConfigForColumn } from './utils/clipboard-config';
export class ColumnHelperClass {
    constructor() {
        this.defautlHelper = 'defautlHelper';
        this.registry = {
            [this.defautlHelper]: DefaultColumnHelper,
            [UITypes.SingleLineText]: SingleLineTextHelper,
            [UITypes.LongText]: LongTextHelper,
            [UITypes.Number]: NumberHelper,
            [UITypes.Decimal]: DecimalHelper,
            [UITypes.Currency]: CurrencyHelper,
            [UITypes.Duration]: DurationHelper,
            [UITypes.Percent]: PercentHelper,
            [UITypes.Checkbox]: CheckboxHelper,
            [UITypes.Rating]: RatingHelper,
            [UITypes.PhoneNumber]: PhoneNumberHelper,
            [UITypes.Email]: EmailHelper,
            [UITypes.URL]: UrlHelper,
            [UITypes.JSON]: JsonHelper,
            [UITypes.GeoData]: GeoDataHelper,
            [UITypes.Barcode]: BarcodeHelper,
            [UITypes.QrCode]: QrCodeHelper,
            [UITypes.Formula]: FormulaHelper,
            [UITypes.Date]: DateHelper,
            [UITypes.DateTime]: DateTimeHelper,
            [UITypes.Time]: TimeHelper,
            [UITypes.Year]: YearHelper,
            [UITypes.CreatedTime]: CreatedTimeHelper,
            [UITypes.LastModifiedTime]: LastModifiedTimeHelper,
            [UITypes.SingleSelect]: SingleSelectHelper,
            [UITypes.MultiSelect]: MultiSelectHelper,
            [UITypes.User]: UserHelper,
            [UITypes.Attachment]: AttachmentHelper,
            [UITypes.CreatedBy]: UserHelper,
            [UITypes.LastModifiedBy]: UserHelper,
            [UITypes.Lookup]: LookupHelper,
            [UITypes.Rollup]: RollupHelper,
            [UITypes.Links]: LinksHelper,
            [UITypes.LinkToAnotherRecord]: LTARHelper,
            [UITypes.Button]: ButtonHelper,
        };
    }
    // Method to retrieve the specific column class and instantiate it
    getColumn(params) {
        let ColumnClass;
        if (ncIsString(params)) {
            ColumnClass = this.registry[params] || this.registry[this.defautlHelper];
        }
        else {
            if (!params.col || !this.registry[params.col.uidt]) {
                ColumnClass = this.registry[this.defautlHelper];
            }
            else {
                ColumnClass = this.registry[params.col.uidt];
            }
        }
        // Instantiate the class with the column data
        return new ColumnClass();
    }
    getColumnDefaultMeta(uidt) {
        const columnInstance = this.getColumn(uidt);
        if (columnInstance) {
            return columnInstance.columnDefaultMeta || {};
        }
        return {};
    }
    /**
     * Parses a stored value back into its original form.
     * Converts a database-stored value into a display-friendly format.
     *
     * @example
     * // Example: Formatting percentage values
     * dbValue = 59; // Stored in DB
     * displayValue = "59%"; // Displayed to users
     *
     * @param value - The value to be parsed from storage format.
     * @param params - Additional parameters related to column parsing.
     * @returns The parsed value in a display-friendly format.
     */
    parseValue(value, params) {
        const columnInstance = this.getColumn(params);
        if (columnInstance) {
            return columnInstance.parseValue(value, params);
        }
    }
    /**
     * Serializes the given value based on column parameters.
     *
     * **WARNING:** This method **can throw errors**. Use a `try-catch` block when calling it.
     *
     * @param value - The value to be serialized.
     * @param params - Additional parameters related to column serialization.
     * @returns The serialized value.
     * @throws {Error} If serialization fails.
     */
    serializeValue(value, params) {
        const columnInstance = this.getColumn(params);
        if (columnInstance) {
            return columnInstance.serializeValue(value, params);
        }
    }
    /**
     * Parses a plain cell value back into its original form.
     * Converts a plain cell value into a display-friendly format.
     *
     * @param value - The value to be parsed from storage format.
     * @param params - Additional parameters related to column parsing.
     * @returns The parsed value in a display-friendly format.
     */
    parsePlainCellValue(value, params) {
        const columnInstance = this.getColumn(params);
        if (columnInstance) {
            return columnInstance.parsePlainCellValue(value, params);
        }
        return value;
    }
    populateFillHandle(params) {
        const columnInstance = this.getColumn({
            col: params.column,
        });
        if (columnInstance) {
            return columnInstance.populateFillHandle(params);
        }
        return undefined;
    }
    getClipboardConfig(params) {
        const columnInstance = this.getColumn(params);
        if (columnInstance) {
            return columnInstance.getClipboardConfig(params);
        }
        return getClipboardConfigForColumn({ col: params.col });
    }
}
export const ColumnHelper = new ColumnHelperClass();
//# sourceMappingURL=data:application/json;base64,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