import { SilentTypeConversionError } from '../../../lib/error';
import { parseCurrencyValue, precisionFormats, serializeCurrencyValue, } from '..';
import AbstractColumnHelper from '../column.interface';
import { populateFillHandleStringNumber } from '../utils/fill-handler';
import { ncIsNaN } from '../../../lib/is';
export class CurrencyHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            currency_locale: 'en-US',
            currency_code: 'USD',
            precision: precisionFormats[2],
        };
    }
    serializeValue(value, params) {
        value = serializeCurrencyValue(value, params);
        if (value === null) {
            if (params.isMultipleCellPaste || params.serializeSearchQuery) {
                return null;
            }
            else {
                throw new SilentTypeConversionError();
            }
        }
        return value;
    }
    parseValue(value, params) {
        // Return empty string for null/undefined values to prevent "null" text when pasting
        if (value === null || value === undefined) {
            return '';
        }
        return parseCurrencyValue(value, params.col);
    }
    parsePlainCellValue(value, params) {
        var _a;
        if (params.isAggregation && ncIsNaN(value)) {
            value = 0;
        }
        return `${(_a = this.parseValue(value, params)) !== null && _a !== void 0 ? _a : ''}`;
    }
    // using string number fill handler
    populateFillHandle(params) {
        return populateFillHandleStringNumber(params);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ3VycmVuY3kuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvbGliL2NvbHVtbkhlbHBlci9jb2x1bW5zL0N1cnJlbmN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSx5QkFBeUIsRUFBRSxNQUFNLGFBQWEsQ0FBQztBQUN4RCxPQUFPLEVBQ0wsa0JBQWtCLEVBQ2xCLGdCQUFnQixFQUNoQixzQkFBc0IsR0FDdkIsTUFBTSxJQUFJLENBQUM7QUFDWixPQUFPLG9CQUVOLE1BQU0scUJBQXFCLENBQUM7QUFDN0IsT0FBTyxFQUFFLDhCQUE4QixFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFFdkUsT0FBTyxFQUFFLE9BQU8sRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUVuQyxNQUFNLE9BQU8sY0FBZSxTQUFRLG9CQUFvQjtJQUF4RDs7UUFDRSxzQkFBaUIsR0FBRztZQUNsQixlQUFlLEVBQUUsT0FBTztZQUN4QixhQUFhLEVBQUUsS0FBSztZQUNwQixTQUFTLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO1NBQy9CLENBQUM7SUFpREosQ0FBQztJQS9DQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDO1FBRTNDLEtBQUssR0FBRyxzQkFBc0IsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFFOUMsSUFBSSxLQUFLLEtBQUssSUFBSSxFQUFFLENBQUM7WUFDbkIsSUFBSSxNQUFNLENBQUMsbUJBQW1CLElBQUksTUFBTSxDQUFDLG9CQUFvQixFQUFFLENBQUM7Z0JBQzlELE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE1BQU0sSUFBSSx5QkFBeUIsRUFBRSxDQUFDO1lBQ3hDLENBQUM7UUFDSCxDQUFDO1FBRUQsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDO0lBRUQsVUFBVSxDQUNSLEtBQVUsRUFDVixNQUEyQztRQUUzQyxvRkFBb0Y7UUFDcEYsSUFBSSxLQUFLLEtBQUssSUFBSSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUUsQ0FBQztZQUMxQyxPQUFPLEVBQUUsQ0FBQztRQUNaLENBQUM7UUFDRCxPQUFPLGtCQUFrQixDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsTUFBMkM7O1FBRTNDLElBQUksTUFBTSxDQUFDLGFBQWEsSUFBSSxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUMzQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1FBQ1osQ0FBQztRQUVELE9BQU8sR0FBRyxNQUFBLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxtQ0FBSSxFQUFFLEVBQUUsQ0FBQztJQUNuRCxDQUFDO0lBRUQsbUNBQW1DO0lBQzFCLGtCQUFrQixDQUFDLE1BSTNCO1FBQ0MsT0FBTyw4QkFBOEIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUNoRCxDQUFDO0NBQ0YifQ==