import { DateHelper } from './Date';
describe('Date', () => {
    describe('populateFillHandle', () => {
        it('will populate with strict copy because some is empty', () => {
            const highlightedData = ['2025-01-01', '', '2025-01-02', '2025-01-03'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 8,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with strict copy because the modifier is not same', () => {
            const highlightedData = ['2025-01-01', '2025-01-03', '2025-01-04'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with strict copy because the modifier is 0', () => {
            const highlightedData = ['2025-01-01', '2025-01-01', '2025-01-01'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with incremental 1 day', () => {
            const highlightedData = ['2025-01-01', '2025-01-02', '2025-01-03'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['2025-01-04', '2025-01-05', '2025-01-06']);
        });
        it('will populate with incremental 2 days', () => {
            const highlightedData = ['2025-01-25', '2025-01-27', '2025-01-29'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['2025-01-31', '2025-02-02', '2025-02-04']);
        });
        it('will populate with incremental 1 month', () => {
            const highlightedData = ['2025-01-02', '2025-02-02', '2025-03-02'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['2025-04-02', '2025-05-02', '2025-06-02']);
        });
        it('will populate with decrement 2 days with MM/DD/YYYY format', () => {
            const highlightedData = ['02/04/2025', '02/02/2025', '01/31/2025'];
            const column = { meta: { date_format: 'MM/DD/YYYY' } };
            const result = new DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['01/29/2025', '01/27/2025', '01/25/2025']);
        });
        it('will populate with decrement 2 days', () => {
            const highlightedData = ['2025-02-04', '2025-02-02', '2025-01-31'];
            const column = { meta: { date_format: 'YYYY-MM-DD' } };
            const result = new DateHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(['2025-01-29', '2025-01-27', '2025-01-25']);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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