import { DateTimeHelper } from './DateTime';
describe('Date', () => {
    describe('populateFillHandle', () => {
        it('will populate with strict copy for 1 highlighted row only', () => {
            const highlightedData = ['2025-01-01 00:00:00'];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm:ss' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 8,
            });
            expect(result).toEqual([
                '2025-01-01 00:00:00',
                '2025-01-01 00:00:00',
                '2025-01-01 00:00:00',
                '2025-01-01 00:00:00',
                '2025-01-01 00:00:00',
                '2025-01-01 00:00:00',
                '2025-01-01 00:00:00',
            ]);
        });
        it('will populate with strict copy because some is empty', () => {
            const highlightedData = [
                '2025-01-01 00:00:00',
                '',
                '2025-01-02 00:00:00',
                '2025-01-03 00:00:00',
            ];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm:ss' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 8,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with strict copy because the modifier is not same', () => {
            const highlightedData = [
                '2025-01-01 00:00:00',
                '2025-01-03 00:00:00',
                '2025-01-04 00:00:00',
            ];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm:ss' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with strict copy because the modifier is 0', () => {
            const highlightedData = [
                '2025-01-01 00:00:00',
                '2025-01-01 00:00:00',
                '2025-01-01 00:00:00',
            ];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm:ss' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual(highlightedData);
        });
        it('will populate with incremental 1 minute', () => {
            const highlightedData = [
                '2025-01-01 00:01',
                '2025-01-01 00:02',
                '2025-01-01 00:03',
            ];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual([
                '2025-01-01 00:04',
                '2025-01-01 00:05',
                '2025-01-01 00:06',
            ]);
        });
        it('will populate with incremental 15 minutes', () => {
            const highlightedData = [
                '2025-01-01 23:15',
                '2025-01-01 23:30',
                '2025-01-01 23:45',
            ];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual([
                '2025-01-02 00:00',
                '2025-01-02 00:15',
                '2025-01-02 00:30',
            ]);
        });
        it('will populate with incremental 15 seconds', () => {
            const highlightedData = [
                '2025-01-01 23:59:15',
                '2025-01-01 23:59:30',
                '2025-01-01 23:59:45',
            ];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm:ss' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual([
                '2025-01-02 00:00:00',
                '2025-01-02 00:00:15',
                '2025-01-02 00:00:30',
            ]);
        });
        it('will populate with incremental 1 month', () => {
            const highlightedData = [
                '2025-01-02 00:00:00',
                '2025-02-02 00:00:00',
                '2025-03-02 00:00:00',
            ];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm:ss' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual([
                '2025-04-02 00:00:00',
                '2025-05-02 00:00:00',
                '2025-06-02 00:00:00',
            ]);
        });
        it('will populate with decrement 2 days with MM/DD/YYYY format', () => {
            const highlightedData = [
                '02/04/2025 00:00:00',
                '02/02/2025 00:00:00',
                '01/31/2025 00:00:00',
            ];
            const column = {
                meta: { date_format: 'MM/DD/YYYY', time_format: 'HH:mm:ss' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual([
                '01/29/2025 00:00:00',
                '01/27/2025 00:00:00',
                '01/25/2025 00:00:00',
            ]);
        });
        it('will populate with decrement 2 days', () => {
            const highlightedData = [
                '2025-02-04 00:00:00',
                '2025-02-02 00:00:00',
                '2025-01-31 00:00:00',
            ];
            const column = {
                meta: { date_format: 'YYYY-MM-DD', time_format: 'HH:mm:ss' },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual([
                '2025-01-29 00:00:00',
                '2025-01-27 00:00:00',
                '2025-01-25 00:00:00',
            ]);
        });
        it('will populate with incremental 15 minutes with AM/PM', () => {
            const highlightedData = [
                '2025-01-01 11:15 PM',
                '2025-01-01 11:30 PM',
                '2025-01-01 11:45 PM',
            ];
            const column = {
                meta: {
                    date_format: 'YYYY-MM-DD',
                    time_format: 'HH:mm',
                    is12hrFormat: true,
                },
            };
            const result = new DateTimeHelper().populateFillHandle({
                column: column,
                highlightedData,
                numberOfRows: 6,
            });
            expect(result).toEqual([
                '2025-01-02 12:00 AM',
                '2025-01-02 12:15 AM',
                '2025-01-02 12:30 AM',
            ]);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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