import { SilentTypeConversionError } from '../../../lib/error';
import { parseDecimalValue, precisionFormats, serializeDecimalValue } from '..';
import AbstractColumnHelper from '../column.interface';
import { populateFillHandleStringNumber } from '../utils/fill-handler';
import { ncIsNaN } from '../../../lib/is';
export class DecimalHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            precision: precisionFormats[1],
            isLocaleString: false,
        };
    }
    serializeValue(value, params) {
        value = serializeDecimalValue(value, undefined, params);
        if (value === null) {
            if (params.isMultipleCellPaste || params.serializeSearchQuery) {
                return null;
            }
            else {
                throw new SilentTypeConversionError();
            }
        }
        return value;
    }
    parseValue(value, params) {
        // Return empty string for null/undefined values to prevent "null" text when pasting
        if (value === null || value === undefined) {
            return '';
        }
        return parseDecimalValue(value, params.col);
    }
    parsePlainCellValue(value, params) {
        var _a;
        if (params.isAggregation && ncIsNaN(value)) {
            value = 0;
        }
        return `${(_a = parseDecimalValue(value, params.col)) !== null && _a !== void 0 ? _a : ''}`;
    }
    // using string number fill handler
    populateFillHandle(params) {
        return populateFillHandleStringNumber(params);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRGVjaW1hbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvRGVjaW1hbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUseUJBQXlCLEVBQUUsTUFBTSxhQUFhLENBQUM7QUFDeEQsT0FBTyxFQUFFLGlCQUFpQixFQUFFLGdCQUFnQixFQUFFLHFCQUFxQixFQUFFLE1BQU0sSUFBSSxDQUFDO0FBQ2hGLE9BQU8sb0JBRU4sTUFBTSxxQkFBcUIsQ0FBQztBQUM3QixPQUFPLEVBQUUsOEJBQThCLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQztBQUV2RSxPQUFPLEVBQUUsT0FBTyxFQUFFLE1BQU0sVUFBVSxDQUFDO0FBRW5DLE1BQU0sT0FBTyxhQUFjLFNBQVEsb0JBQW9CO0lBQXZEOztRQUNFLHNCQUFpQixHQUFHO1lBQ2xCLFNBQVMsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDLENBQUM7WUFDOUIsY0FBYyxFQUFFLEtBQUs7U0FDdEIsQ0FBQztJQWlESixDQUFDO0lBL0NDLGNBQWMsQ0FDWixLQUFVLEVBQ1YsTUFBMkM7UUFFM0MsS0FBSyxHQUFHLHFCQUFxQixDQUFDLEtBQUssRUFBRSxTQUFTLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFFeEQsSUFBSSxLQUFLLEtBQUssSUFBSSxFQUFFLENBQUM7WUFDbkIsSUFBSSxNQUFNLENBQUMsbUJBQW1CLElBQUksTUFBTSxDQUFDLG9CQUFvQixFQUFFLENBQUM7Z0JBQzlELE9BQU8sSUFBSSxDQUFDO1lBQ2QsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE1BQU0sSUFBSSx5QkFBeUIsRUFBRSxDQUFDO1lBQ3hDLENBQUM7UUFDSCxDQUFDO1FBRUQsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDO0lBRUQsVUFBVSxDQUNSLEtBQVUsRUFDVixNQUEyQztRQUUzQyxvRkFBb0Y7UUFDcEYsSUFBSSxLQUFLLEtBQUssSUFBSSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUUsQ0FBQztZQUMxQyxPQUFPLEVBQUUsQ0FBQztRQUNaLENBQUM7UUFDRCxPQUFPLGlCQUFpQixDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDOUMsQ0FBQztJQUVELG1CQUFtQixDQUNqQixLQUFVLEVBQ1YsTUFBMkM7O1FBRTNDLElBQUksTUFBTSxDQUFDLGFBQWEsSUFBSSxPQUFPLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUMzQyxLQUFLLEdBQUcsQ0FBQyxDQUFDO1FBQ1osQ0FBQztRQUVELE9BQU8sR0FBRyxNQUFBLGlCQUFpQixDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLG1DQUFJLEVBQUUsRUFBRSxDQUFDO0lBQ3pELENBQUM7SUFFRCxtQ0FBbUM7SUFDMUIsa0JBQWtCLENBQUMsTUFJM0I7UUFDQyxPQUFPLDhCQUE4QixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ2hELENBQUM7Q0FDRiJ9