import AbstractColumnHelper from '../column.interface';
import { parseProp } from '../../../lib/helperFunctions';
import { ColumnHelper } from '../column-helper';
import { ComputedTypePasteError } from '../../../lib/error';
import { FormulaDataTypes } from '../../../lib/formula/enums';
import { ncIsNaN } from '../../../lib/is';
export class FormulaHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {
            display_column_meta: {
                meta: {},
                custom: {},
            },
            display_type: null,
        };
    }
    serializeValue(value, params) {
        var _a, _b, _c, _d;
        if (params.serializeSearchQuery) {
            const dataType = (_d = (_c = (_b = (_a = params.col) === null || _a === void 0 ? void 0 : _a.colOptions) === null || _b === void 0 ? void 0 : _b.parsed_tree) === null || _c === void 0 ? void 0 : _c.dataType) !== null && _d !== void 0 ? _d : FormulaDataTypes.STRING;
            if (dataType === FormulaDataTypes.NUMERIC) {
                return ncIsNaN(value) ? '' : value;
            }
            return value;
        }
        if (params.isMultipleCellPaste) {
            return undefined;
        }
        else {
            throw new ComputedTypePasteError();
        }
    }
    parseValue(value, params) {
        var _a;
        const columnMeta = parseProp((_a = params.col) === null || _a === void 0 ? void 0 : _a.meta);
        const childColumn = Object.assign({ uidt: columnMeta.display_type }, columnMeta.display_column_meta);
        return ColumnHelper.parseValue(value, Object.assign(Object.assign({}, params), { col: childColumn }));
    }
    parsePlainCellValue(value, params) {
        var _a;
        return (_a = this.parseValue(value, params)) !== null && _a !== void 0 ? _a : '';
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRm9ybXVsYS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvRm9ybXVsYS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLG9CQUVOLE1BQU0scUJBQXFCLENBQUM7QUFDN0IsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLHVCQUF1QixDQUFDO0FBQ2xELE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxrQkFBa0IsQ0FBQztBQUNoRCxPQUFPLEVBQUUsc0JBQXNCLEVBQUUsTUFBTSxhQUFhLENBQUM7QUFDckQsT0FBTyxFQUFFLGdCQUFnQixFQUFFLE1BQU0scUJBQXFCLENBQUM7QUFDdkQsT0FBTyxFQUFFLE9BQU8sRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUVuQyxNQUFNLE9BQU8sYUFBYyxTQUFRLG9CQUFvQjtJQUF2RDs7UUFDRSxzQkFBaUIsR0FBRztZQUNsQixtQkFBbUIsRUFBRTtnQkFDbkIsSUFBSSxFQUFFLEVBQUU7Z0JBQ1IsTUFBTSxFQUFFLEVBQUU7YUFDWDtZQUNELFlBQVksRUFBRSxJQUFJO1NBQ25CLENBQUM7SUErQ0osQ0FBQztJQTdDQyxjQUFjLENBQ1osS0FBVSxFQUNWLE1BQTJDOztRQUUzQyxJQUFJLE1BQU0sQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1lBQ2hDLE1BQU0sUUFBUSxHQUNaLE1BQUEsTUFBQSxNQUFDLE1BQUEsTUFBTSxDQUFDLEdBQUcsMENBQUUsVUFBa0IsMENBQUUsV0FBVywwQ0FBRSxRQUFRLG1DQUN0RCxnQkFBZ0IsQ0FBQyxNQUFNLENBQUM7WUFFMUIsSUFBSSxRQUFRLEtBQUssZ0JBQWdCLENBQUMsT0FBTyxFQUFFLENBQUM7Z0JBQzFDLE9BQU8sT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQztZQUNyQyxDQUFDO1lBRUQsT0FBTyxLQUFLLENBQUM7UUFDZixDQUFDO1FBRUQsSUFBSSxNQUFNLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztZQUMvQixPQUFPLFNBQVMsQ0FBQztRQUNuQixDQUFDO2FBQU0sQ0FBQztZQUNOLE1BQU0sSUFBSSxzQkFBc0IsRUFBRSxDQUFDO1FBQ3JDLENBQUM7SUFDSCxDQUFDO0lBRUQsVUFBVSxDQUNSLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsTUFBTSxVQUFVLEdBQUcsU0FBUyxDQUFDLE1BQUEsTUFBTSxDQUFDLEdBQUcsMENBQUUsSUFBSSxDQUFDLENBQUM7UUFDL0MsTUFBTSxXQUFXLG1CQUNmLElBQUksRUFBRSxVQUFVLENBQUMsWUFBWSxJQUMxQixVQUFVLENBQUMsbUJBQW1CLENBQ2xDLENBQUM7UUFFRixPQUFPLFlBQVksQ0FBQyxVQUFVLENBQUMsS0FBSyxrQ0FDL0IsTUFBTSxLQUNULEdBQUcsRUFBRSxXQUFXLElBQ2hCLENBQUM7SUFDTCxDQUFDO0lBRUQsbUJBQW1CLENBQ2pCLEtBQVUsRUFDVixNQUEyQzs7UUFFM0MsT0FBTyxNQUFBLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxtQ0FBSSxFQUFFLENBQUM7SUFDOUMsQ0FBQztDQUNGIn0=