import AbstractColumnHelper from '../../../lib/columnHelper/column.interface';
import { SilentTypeConversionError } from '../../../lib/error';
import { parseJsonValue, serializeJsonValue } from '../utils';
import { ncIsString } from '../../../lib/is';
export class JsonHelper extends AbstractColumnHelper {
    constructor() {
        super(...arguments);
        this.columnDefaultMeta = {};
    }
    serializeValue(value, params) {
        if (params.serializeSearchQuery) {
            return ncIsString(value) ? value : null;
        }
        value = serializeJsonValue(value);
        if (value === null) {
            throw new SilentTypeConversionError();
        }
        return value;
    }
    parseValue(value) {
        return parseJsonValue(value);
    }
    parsePlainCellValue(value) {
        return parseJsonValue(value);
    }
    equalityComparison(a, b, _param) {
        const aStr = typeof a === 'object'
            ? JSON.stringify(a)
            : typeof a === 'string'
                ? a
                : a.toString();
        const bStr = typeof b === 'object'
            ? JSON.stringify(b)
            : typeof b === 'string'
                ? b
                : b.toString();
        return aStr === bStr;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSnNvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9saWIvY29sdW1uSGVscGVyL2NvbHVtbnMvSnNvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLG9CQUVOLE1BQU0scUNBQXFDLENBQUM7QUFDN0MsT0FBTyxFQUFFLHlCQUF5QixFQUFFLE1BQU0sYUFBYSxDQUFDO0FBQ3hELE9BQU8sRUFBRSxjQUFjLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSxVQUFVLENBQUM7QUFDOUQsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLFVBQVUsQ0FBQztBQUV0QyxNQUFNLE9BQU8sVUFBVyxTQUFRLG9CQUFvQjtJQUFwRDs7UUFDRSxzQkFBaUIsR0FBRyxFQUFFLENBQUM7SUE4Q3pCLENBQUM7SUE1Q0MsY0FBYyxDQUNaLEtBQVUsRUFDVixNQUEyQztRQUUzQyxJQUFJLE1BQU0sQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1lBQ2hDLE9BQU8sVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUMxQyxDQUFDO1FBRUQsS0FBSyxHQUFHLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRWxDLElBQUksS0FBSyxLQUFLLElBQUksRUFBRSxDQUFDO1lBQ25CLE1BQU0sSUFBSSx5QkFBeUIsRUFBRSxDQUFDO1FBQ3hDLENBQUM7UUFFRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxVQUFVLENBQUMsS0FBVTtRQUNuQixPQUFPLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQsbUJBQW1CLENBQUMsS0FBVTtRQUM1QixPQUFPLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRVEsa0JBQWtCLENBQ3pCLENBQU0sRUFDTixDQUFNLEVBQ04sTUFBMkM7UUFFM0MsTUFBTSxJQUFJLEdBQ1IsT0FBTyxDQUFDLEtBQUssUUFBUTtZQUNuQixDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDbkIsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLFFBQVE7Z0JBQ3ZCLENBQUMsQ0FBQyxDQUFDO2dCQUNILENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDbkIsTUFBTSxJQUFJLEdBQ1IsT0FBTyxDQUFDLEtBQUssUUFBUTtZQUNuQixDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDbkIsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLFFBQVE7Z0JBQ3ZCLENBQUMsQ0FBQyxDQUFDO2dCQUNILENBQUMsQ0FBQyxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7UUFDbkIsT0FBTyxJQUFJLEtBQUssSUFBSSxDQUFDO0lBQ3ZCLENBQUM7Q0FDRiJ9